//+------------------------------------------------------------------+
//|                                 Elliott_Wave_Oscillator_Sign.mq5 | 
//|                              Copyright  2008, tonyc2a@yahoo.com |
//|                                                tonyc2a@yahoo.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, tonyc2a@yahoo.com"
#property link      "tonyc2a@yahoo.com"
//----   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "Elliott_Wave_Oscillator Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "Elliott_Wave_Oscillator Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_MODE // 
  {
   MODE1 = 1,     //  
   MODE2          //  
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_MODE Mode=MODE1; //  
input Smooth_Method MA_Method1=MODE_SMA_; //   
input int Length1=5; //                      
input int Phase1=15; //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC1=PRICE_MEDIAN_;//   
input Smooth_Method MA_Method2=MODE_JJMA; //   
input int Length2=35; //   
input int Phase2=15;  //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC2=PRICE_MEDIAN_;//   
input int Shift=0; //      
input bool Sign=true; //          
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[],BuyBuffer[];
//----      
int min_rates_total;
//----      
int ATR_Handle;
//+------------------------------------------------------------------+   
//| Elliott_Wave_Oscillator initialization function                  | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_total=MathMax(GetStartBars(MA_Method1,Length1,Phase1),GetStartBars(MA_Method2,Length2,Phase2))+3;
   int ATR_Period=15;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period))+1;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname;
   StringConcatenate(shortname,"Elliott_Wave_Oscillator(",Length1,",",Length2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Elliott_Wave_Oscillator iteration function                       | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----       
   double price,x1xma,x2xma,ewo,ATR[1];
   static double ewo_prev,ewo_prev_prev;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      ewo_prev=0.0;
      ewo_prev_prev=0.0;
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC1,bar,open,low,high,close);
      x1xma=XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      price=PriceSeries(IPC2,bar,open,low,high,close);
      x2xma=XMA2.XMASeries(0,prev_calculated,rates_total,MA_Method2,Phase2,Length2,price,bar,false);
      ewo=x1xma-x2xma;
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(Mode==MODE1)
        {
         if(ewo_prev_prev>ewo_prev && ewo_prev<ewo)
           {
            //----      
            if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
            BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
            if(Sign && bar==rates_total-2) PlaySound("alert.wav");
           }

         if(ewo_prev_prev<ewo_prev && ewo_prev>ewo)
           {
            //----      
            if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
            SellBuffer[bar]=high[bar]+ATR[0]*3/8;
            if(Sign && bar==rates_total-2) PlaySound("alert.wav");
           }
        }
        
      if(Mode==MODE2)
        {
         if(ewo_prev<0.0 && ewo>0.0)
           {
            //----      
            if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
            BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
            if(Sign && bar==rates_total-2) PlaySound("alert.wav");
           }

         if(ewo_prev>0.0 && ewo<0.0)
           {
            //----      
            if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
            SellBuffer[bar]=high[bar]+ATR[0]*3/8;
            if(Sign && bar==rates_total-2) PlaySound("alert.wav");
           }
        }

      if(bar<rates_total-1)
        {
         ewo_prev_prev=ewo_prev;
         ewo_prev=ewo;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
