//+------------------------------------------------------------------+
//|                                             Ozymandias_StDev.mq5 |
//|                                     Copyright  2014, GoldnMoney |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2014, GoldnMoney"
#property link "http://www.mql5.com"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrDodgerBlue,clrOrange
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "Ozymandias"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrRed
//----    2  3
#property indicator_width2  3
//----    
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrMediumSpringGreen
//----    3  3
#property indicator_width3  3
//----    
#property indicator_label3  "Up_Signal"

//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Length=2;
input  ENUM_MA_METHOD MAType=MODE_SMA;
input double dK=2.0;  //   
input uint std_period=9; //  
input int Shift=0;   //      
//+----------------------------------------------+

//----   ,    
//      
double OzimBuffer[];
double ColorOzimBuffer[];
double BearsBuffer[];
double BullsBuffer[];
//----   ,    
//      
int Count[];
double Smooth[];
double dOzim[];
//----      
int min_rates_1,min_rates_total;
int HMA_Handle,LMA_Handle;
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_1=int(Length);
   min_rates_total=min_rates_1+1+int(std_period);

//----    
   int ATR_Period=100;
//----       
   ArrayResize(dOzim,std_period);   

//----    iMA
   HMA_Handle=iMA(NULL,0,Length,0,MAType,PRICE_HIGH);
   if(HMA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }

//----    iMA
   LMA_Handle=iMA(NULL,0,Length,0,MAType,PRICE_LOW);
   if(LMA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
   
//----      
   SetIndexBuffer(0,OzimBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(OzimBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorOzimBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorOzimBuffer,true);

//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(BearsBuffer,true);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,119);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);

//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(BullsBuffer,true);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,119);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);


//----      
   string shortname="Ozymandias";
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(HMA_Handle)<rates_total
      || BarsCalculated(LMA_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);


//----  
   int to_copy,limit,trend0,nexttrend0;
   double SMAdif,Sum,StDev,dstd,BEARS,BULLS,Filter;
   double hh,ll,maxl0,minh0,lma,hma,HMA[],LMA[];
   static int trend1,nexttrend1;
   static double maxl1,minh1;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      trend1=0;
      nexttrend1=0;
      maxl1=0;
      minh1=9999999;
     }
   else limit=rates_total-prev_calculated;  //       
   to_copy=limit+1;

//----      
   if(CopyBuffer(HMA_Handle,0,0,to_copy,HMA)<=0) return(RESET);
   if(CopyBuffer(LMA_Handle,0,0,to_copy,LMA)<=0) return(RESET);

//----         
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(HMA,true);
   ArraySetAsSeries(LMA,true);

   nexttrend0=nexttrend1;
   maxl0=maxl1;
   minh0=minh1;

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      hh=high[ArrayMaximum(high,bar,Length)];
      ll=low[ArrayMinimum(low,bar,Length)];
      lma=LMA[bar];
      hma=HMA[bar];
      trend0=trend1;

      if(nexttrend0==1)
        {
         maxl0=MathMax(ll,maxl0);

         if(hma<maxl0 && close[bar]<low[bar+1])
           {
            trend0=1;
            nexttrend0=0;
            minh0=hh;
           }
        }

      if(nexttrend0==0)
        {
         minh0=MathMin(hh,minh0);

         if(lma>minh0 && close[bar]>high[bar+1])
           {
            trend0=0;
            nexttrend0=1;
            maxl0=ll;
           }
        }

      if(trend0==0)
        {
         if(trend1!=0.0)
           {
            OzimBuffer[bar]=OzimBuffer[bar+1];
            ColorOzimBuffer[bar]=1;
           }
         else
           {
            OzimBuffer[bar]=MathMax(maxl0,OzimBuffer[bar+1]);
            ColorOzimBuffer[bar]=1;
           }
        }
      else
        {
         if(trend1!=1)
           {
            OzimBuffer[bar]=OzimBuffer[bar+1];
            ColorOzimBuffer[bar]=0;
           }
         else
           {
            OzimBuffer[bar]=MathMin(minh0,OzimBuffer[bar+1]);
            ColorOzimBuffer[bar]=0;
           }
        }

      if(bar)
        {
         nexttrend1=nexttrend0;
         trend1=trend0;
         maxl1=maxl0;
         minh1=minh0;
        }
     }
     
//----    limit
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      limit=rates_total-min_rates_total-1; //      

//----     
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorOzimBuffer[bar]=0;
      if(OzimBuffer[bar+1]<OzimBuffer[bar]) ColorOzimBuffer[bar]=1;
      if(OzimBuffer[bar+1]>OzimBuffer[bar]) ColorOzimBuffer[bar]=2;
      if(OzimBuffer[bar+1]==OzimBuffer[bar]) ColorOzimBuffer[bar]=ColorOzimBuffer[bar+1];
     }

//----      
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dOzim[iii]=OzimBuffer[bar+iii]-OzimBuffer[bar+iii+1];

      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dOzim[iii];
      SMAdif=Sum/std_period;

      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dOzim[iii]-SMAdif,2);

      //----      StDev   
      StDev=MathSqrt(Sum/std_period);

      //----  
      dstd=NormalizeDouble(dOzim[0],_Digits+2);
      Filter=NormalizeDouble(dK*StDev,_Digits+2);
      BEARS=0;
      BULLS=0;

      //----   
      if(dstd<-Filter) BEARS=OzimBuffer[bar]; //  
      if(dstd>+Filter) BULLS=OzimBuffer[bar]; //  

      //----       
      BullsBuffer[bar]=BULLS;
      BearsBuffer[bar]=BEARS;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
