//+------------------------------------------------------------------+
//|                                               PChannel3Cloud.mq5 |
//|                                           Copyright  2005, Xaoc |
//|                                             http://forex.xcd.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Xaoc"
#property link      "http://forex.xcd.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//---        
#property indicator_buffers 7
//---    
#property indicator_plots   5
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----      PaleGreen
#property indicator_color1  clrPaleGreen
//----   
#property indicator_label1  "Upper Cloud"
//+----------------------------------------------+
//|              |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrTeal
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "TOPBAND"
//+----------------------------------------------+
//|                |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----         
#property indicator_color3  clrBlue
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "MIDBAND"
//+----------------------------------------------+
//|               |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_LINE
//----         
#property indicator_color4  clrRed
//----   4 -  
#property indicator_style4  STYLE_SOLID
//----    4  2
#property indicator_width4  2
//----    
#property indicator_label4  "BOTBAND"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_FILLING
//----      Pink
#property indicator_color5  clrPink
//----   
#property indicator_label5  "Upper Cloud"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   PCPeriod=55; 
input int    Shift=0;     //       
//+----------------------------------------------+

//----      
int  min_rates_total;
//----   ,    
//      
double ExtUp1Buffer[];
double ExtUp2Buffer[];
double ExtABuffer[];
double ExtBBuffer[];
double ExtCBuffer[];
double ExtDn1Buffer[];
double ExtDn2Buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   min_rates_total=int(PCPeriod);
   
//----      
   SetIndexBuffer(0,ExtUp1Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtUp2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtUp1Buffer,true);
   ArraySetAsSeries(ExtUp2Buffer,true);
   
//----      
   SetIndexBuffer(2,ExtABuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtABuffer,true);

//----      
   SetIndexBuffer(3,ExtBBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtBBuffer,true);

//----      
   SetIndexBuffer(4,ExtCBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtCBuffer,true);
   
//----      
   SetIndexBuffer(5,ExtDn1Buffer,INDICATOR_DATA);
   SetIndexBuffer(6,ExtDn2Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtDn1Buffer,true);
   ArraySetAsSeries(ExtDn2Buffer,true);
   
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"PChannel3("+string(PCPeriod)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);
   
//----   
   int limit;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
        limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated;  //       

//----         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);   
   
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtABuffer[bar]=High[ArrayMaximum(High,bar,PCPeriod)];
      ExtCBuffer[bar]=Low[ArrayMinimum(Low,bar,PCPeriod)];
      ExtBBuffer[bar]=(ExtABuffer[bar]+ExtCBuffer[bar])/2.0;
      ExtUp1Buffer[bar]=ExtABuffer[bar];
      ExtUp2Buffer[bar]=ExtBBuffer[bar];
      ExtDn1Buffer[bar]=ExtBBuffer[bar];
      ExtDn2Buffer[bar]=ExtCBuffer[bar];
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
