//+------------------------------------------------------------------+
//|                                                    TangoLine.mq5 |
//|                                         Copyright  2015, fxborg | 
//|                                   http://fxborg-labo.hateblo.jp/ | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, fxborg"
#property link      "http://fxborg-labo.hateblo.jp/"
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    5
#property indicator_buffers 5 
//----   3  
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       BlueViolet 
#property indicator_color1 clrBlueViolet
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "TangoLine"
//+--------------------------------------------+
//|         |
//+--------------------------------------------+
//----      
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//----   
#property indicator_color2  clrLimeGreen
#property indicator_color3  clrRed
//----  -  
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
//----    2
#property indicator_width2  2
#property indicator_width3  2
//----   
#property indicator_label2  "Upper"
#property indicator_label3  "Lower"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input  int InpPeriod=20;   // Period
input  double MinSpread=5; // Min Spread 
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double LineBuffer[],HighesBuffer[],LowesBuffer[],HighBuffer[],LowBuffer[];
//----     
double dMinSpread;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(InpPeriod)+3;
//----    
   dMinSpread=MinSpread*_Point;
//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----      
   SetIndexBuffer(1,HighBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,LowBuffer,INDICATOR_DATA);
//----  ,     
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//----      
   SetIndexBuffer(3,HighesBuffer,INDICATOR_CALCULATIONS);
//----      
   SetIndexBuffer(4,LowesBuffer,INDICATOR_CALCULATIONS);
//----      
   string shortname;
   StringConcatenate(shortname,"TangoLine(",InpPeriod,", ",MinSpread,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double  dmin,dmax;
//----        
   int first,bar;
   static int top_bar,btm_bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      top_bar=0;
      btm_bar=0;
     }
   else first=prev_calculated-1; //      
//---- 
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      LowesBuffer[bar]=0.0;
      HighesBuffer[bar]=0.0;
      HighBuffer[bar]=0.0;
      LowBuffer[bar]=0.0;
      LineBuffer[bar]=0.0;
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) first=min_rates_total;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //--- calculate range spread
      dmin=1000000.0;
      dmax=-1000000.0;
      for(int kkk=bar-int(InpPeriod)+1; kkk<=bar; kkk++)
        {
         if(dmin>low[kkk]) dmin=low[kkk];
         if(dmax<high[kkk]) dmax=high[kkk];
        }
      //--- hook
      if((LowesBuffer[bar-2]-dMinSpread)>LowesBuffer[bar-1] && LowesBuffer[bar-1]==dmin)
        {
         top_bar=bar-1;
         btm_bar=bar-1;
        }
      if((HighesBuffer[bar-2]+dMinSpread)<HighesBuffer[bar-1] && HighesBuffer[bar-1]==dmax)
        {
         btm_bar=bar-1;
         top_bar=bar-1;
        }
      LowesBuffer[bar]=dmin;
      HighesBuffer[bar]=dmax;
      if(MathMax(top_bar,btm_bar)>bar-int(InpPeriod)+1)
        {
         //--- calculate range spread
         dmin=1000000.0;
         dmax=-1000000.0;
         //---
         for(int kkk=bar-int(InpPeriod)+1; kkk<=bar; kkk++)
           {
            //---
            if(kkk>=btm_bar && dmin>low[kkk]) dmin=low[kkk];
            if(kkk>=top_bar && dmax<high[kkk]) dmax=high[kkk];
           }
        }
      LowBuffer[bar]=dmin;
      HighBuffer[bar]=dmax;
      LineBuffer[bar]=(dmax+dmin)/2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
