//+---------------------------------------------------------------------+
//|                                       VKW_Bands_Modify_DeMarker.mq5 | 
//|                                     Copyright  2008, Alksnis Gatis | 
//|                                                   2xpoint@gmail.com | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): terminal_data_folder\MQL5\Include             |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2008, Alksnis Gatis"
#property link "2xpoint@gmail.com"
#property description " ,    "
#property description "         ,     "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 3 
//----     
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       LightSlateGray 
#property indicator_color1 clrLightSlateGray
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "METRO_DeMarker"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       MediumTurquoise 
#property indicator_color2 clrMediumTurquoise
//----   -  
#property indicator_style2  STYLE_SOLID
//----     3
#property indicator_width2  3
//----   
#property indicator_label2  "VKW_Bands Upper"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       Red 
#property indicator_color3 clrRed
//----   -  
#property indicator_style3  STYLE_SOLID
//----     3
#property indicator_width3  3
//----   
#property indicator_label3  "VKW_Bands Lower"
//+-----------------------------------+
//|                   |
//+-----------------------------------+
#property indicator_level1 60
#property indicator_level2 40
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0                      //        
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint PeriodDeMarker=7;                          //  
input int StepSizeFast=5;                             //  
input int StepSizeSlow=15;                            //  
input int IShift=0;                                   //       
input ENUM_APPLIED_PRICE  Applied_price=PRICE_CLOSE;  //    handle
input uint RPeriod=25;                                //    
input Smooth_Method SmMA_Method=MODE_SMA;             //  
input uint SLength=3;                                 //                      
input int SPhase=100;                                 //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int SShift=0;                                   //       
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer[],UpIndBuffer[],DnIndBuffer[];
//----      
int Ind_Handle;
//----      
int min_rates_total,min_rates_1;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_1=int(PeriodDeMarker);
   min_rates_1+=int(RPeriod);
   min_rates_total=min_rates_1+GetStartBars(SmMA_Method,SLength,SPhase);
//----    ColorMETRO_DeMarker
   Ind_Handle=iCustom(NULL,0,"ColorMETRO_DeMarker",PeriodDeMarker,StepSizeFast,StepSizeSlow,0,Applied_price);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ColorMETRO_DeMarker");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,IShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(IndBuffer,true);

//----      
   SetIndexBuffer(1,UpIndBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,SShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(UpIndBuffer,true);

//----      
   SetIndexBuffer(2,DnIndBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,SShift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(DnIndBuffer,true);

//----      
   string shortname="VKW_Bands_METRO";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<int(min_rates_total)) return(RESET);
//----       
   double d_max,d_min,InputInd[];
//----        
   int limit,to_copy,bar,maxbar;
   maxbar=rates_total-1-min_rates_1;
//----         
   ArraySetAsSeries(InputInd,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=maxbar; //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1+int(RPeriod);
//----      
   if(CopyBuffer(Ind_Handle,1,0,to_copy,InputInd)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      d_max=InputInd[ArrayMaximum(InputInd,bar,RPeriod)];
      d_min=InputInd[ArrayMinimum(InputInd,bar,RPeriod)];
      IndBuffer[bar]=InputInd[bar];
      UpIndBuffer[bar]=XMA1.XMASeries(maxbar,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,d_max,bar,true);
      DnIndBuffer[bar]=XMA2.XMASeries(maxbar,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,d_min,bar,true);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
