//+------------------------------------------------------------------+
//|                                               HistVolatility.mq5 | 
//|                              Copyright  2008, Victor Umnyashkin |
//|                                                   v354@hotbox.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Victor Umnyashkin"
#property link      "v354@hotbox.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1 clrGray,clrPurple,clrDarkTurquoise
//----   -  
#property indicator_style1 STYLE_SOLID
//----     4
#property indicator_width1  2
//----   
#property indicator_label1  "HistVolatility"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Scale_ // 
  {
   S1_ = 1,     //1
   S2_,         //2
   S3_          //3
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int Per=21;
input Scale_ Scale=S3_;
input int Trading_Day_In_Year=365;
input int Percent=100;
input double Coeff=1;
input int Shift=0; //      
//+-----------------------------------+
//----  
double LineBuffer[],ColorLineBuffer[];
//----      
int YearBase,min_rates_total;
//+------------------------------------------------------------------+   
//| HistVolatility initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=Per+1;
//----  
   YearBase=Trading_Day_In_Year*PeriodSeconds(PERIOD_D1)/PeriodSeconds(PERIOD_CURRENT);
//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+1);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(LineBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorLineBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorLineBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"HistVolatility(",Per,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| HistVolatility iteration function                                | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[])    //     
  {
//----       
   if(rates_total<min_rates_total+begin) return(0);
//----       
   double Volatility;
//----        
   int limit,bar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total-begin; //      
      //----      
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+1+begin);
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//----         
   ArraySetAsSeries(price,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Volatility=WVHiVol(Per,price,bar,Scale);
      LineBuffer[bar]=Volatility*MathSqrt(1.0*YearBase/Per)*Percent*Coeff;
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) limit--;
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorLineBuffer[bar]=0;
      if(LineBuffer[bar]>LineBuffer[bar+1]) ColorLineBuffer[bar]=2;
      if(LineBuffer[bar]<LineBuffer[bar+1]) ColorLineBuffer[bar]=1;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+
double WVHiVol(int N,const double &Price[],int index,Scale_ IsLog)
  {
//----
   double Mid,MidLog,MidIncr,delta,Vol,VolLog,VolIncr;
//----
   Mid=0;
   MidIncr=0;
   MidLog=0;
//----
   for(int i=0; i<N; i++)
     {
      delta=Price[index+i]-Price[index+i+1];
      Mid+=delta;
      delta/=Price[index+i];
      MidIncr+=delta;
      delta=Price[index+i]/Price[index+i+1];
      MidLog+=MathLog(delta);
     }
//----
   Vol=0;
   VolLog=0;
   VolIncr=0;
//----
   for(int i=0; i<N; i++)
     {
      delta=Price[index+i]-Price[index+i+1];
      Vol+=(delta-Mid)*(delta-Mid);
      delta/=Price[i];
      VolIncr+=(delta-MidIncr)*(delta-MidIncr);
      delta=MathLog(Price[index+i]/Price[index+i+1]);
      VolLog+=(delta-MidLog)*(delta-MidLog);
     }
//----
   if(IsLog == S2_) return(MathSqrt(Vol/(N-1.0)));
   if(IsLog == S1_) return(MathSqrt(VolIncr/(N-1.0)));
//----
   return(MathSqrt(VolLog/(N-1.0)));
  }
//+------------------------------------------------------------------+
