//+------------------------------------------------------------------+
//|                                          ColorBullsBearsEyes.mq5 | 
//|                   Copyright  2007, EmeraldKing, transport_david | 
//|                                                                  | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, EmeraldKing, transport_david"
#property link "http://finance.groups.yahoo.com/group/MetaTrader_Experts_and_Indicators/"
#property description "BullsBearsEyes"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 3 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level5 0.0
#property indicator_levelcolor clrLimeGreen
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_LINE
//----      
#property indicator_color1 clrBlue,clrRed,clrLime
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "BullsBearsEyes"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum AlgMode
  {
   twist,// 
   breakdown1,  //  
   breakdown2,  //    
   breakdown3   //      +     
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int period=13; //   
input double gamma=0.6; //   
input AlgMode Mode=breakdown2; //    
input uint HighLevel=75; //  
input uint MiddleLevel=50; //  
input uint LowLevel=25; //  
input int Shift=0;   //      
//+----------------------------------------------+
//----   ,    
//----      
double BullsBearsEyes[],ColorBuffer[],SignBuffer[];
//----      
int Bears_Handle,Bulls_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| BullsBearsEyes indicator initialization function                 | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(period+4);
//----    iBearsPower
   Bears_Handle=iBearsPower(NULL,0,int(period));
   if(Bears_Handle==INVALID_HANDLE) Print("      iBearsPower");
//----    iBullsPower
   Bulls_Handle=iBullsPower(NULL,0,int(period));
   if(Bulls_Handle==INVALID_HANDLE) Print("      iBullsPower");
//----      
   SetIndexBuffer(0,BullsBearsEyes,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(BullsBearsEyes,true);
//----     ,     
   SetIndexBuffer(1,ColorBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorBuffer,true);
//----            
   SetIndexBuffer(2,SignBuffer,INDICATOR_CALCULATIONS);
//----       
   ArraySetAsSeries(SignBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"BullsBearsEyes(",period,", ",gamma,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----      5   
   IndicatorSetInteger(INDICATOR_LEVELS,5);
//----    
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,100);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,HighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,MiddleLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,3,LowLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,4,0);
//----       
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrLimeGreen);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrGray);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,3,clrMagenta);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,4,clrLimeGreen);
//----       -
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASH);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,3,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,4,STYLE_DASH);
//----  
  }
//+------------------------------------------------------------------+ 
//| BullsBearsEyes iteration function                                | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Bears_Handle)<rates_total
      || BarsCalculated(Bulls_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----       
   double result,Bears[],Bulls[],CU,CD;
   double L0,L1,L2,L3,L0A,L1A,L2A,L3A;
   static double L0_,L1_,L2_,L3_;
   static int trend_;
//----   
   int limit,bar,to_copy,trend;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=int(rates_total-period-1); //      
      trend_=0;
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;
//----    ,     
   ArraySetAsSeries(Bears,true);
   ArraySetAsSeries(Bulls,true);
//----        
   if(CopyBuffer(Bears_Handle,0,0,to_copy,Bears)<=0) return(RESET);
   if(CopyBuffer(Bulls_Handle,0,0,to_copy,Bulls)<=0) return(RESET);
//----   
   L0=L0_;
   L1=L1_;
   L2=L2_;
   L3=L3_;
   if(Mode==breakdown3) trend=trend_;
//----   
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----        
      if(rates_total!=prev_calculated && bar==0)
        {
         L0_=L0;
         L1_=L1;
         L2_=L2;
         L3_=L3;
        }
      //----
      L0A=L0;
      L1A=L1;
      L2A=L2;
      L3A=L3;
      //----
      L0=(1.0-gamma)*(Bears[bar]+Bulls[bar])+gamma*L0A;
      L1=-gamma*L0+L0A+gamma*L1A;
      L2=-gamma*L1+L1A+gamma*L2A;
      L3=-gamma*L2+L2A+gamma*L3A;
      //----
      CU=0.0;
      CD=0.0;
      result=0.0;
      if(L0>=L1) CU=L0-L1; else CD=L1-L0;
      if(L1>=L2) CU+=L1-L2; else CD+=L2-L1;
      if(L2>=L3) CU+=L2-L3; else CD+=L3-L2;
      if(CU+CD!=0) result=CU/(CU+CD);
      result*=100;
      //----
      BullsBearsEyes[bar]=result;
     }
//----
   if(prev_calculated>rates_total || prev_calculated<=0) limit-=min_rates_total;
//----    
   switch(Mode)
     {
      case twist:
         for(bar=limit; bar>=0 && !IsStopped(); bar--)
           {
            int bar1=bar+1;
            ColorBuffer[bar]=0;
            if(BullsBearsEyes[bar1]>BullsBearsEyes[bar]) ColorBuffer[bar]=1;
            if(BullsBearsEyes[bar1]<BullsBearsEyes[bar]) ColorBuffer[bar]=2;
           }
         break;
         //----
      case breakdown1:
         for(bar=limit; bar>=0 && !IsStopped(); bar--)
           {
            ColorBuffer[bar]=0;
            if(BullsBearsEyes[bar]<MiddleLevel) ColorBuffer[bar]=1;
            if(BullsBearsEyes[bar]>MiddleLevel) ColorBuffer[bar]=2;
           }
         break;
         //----
      case breakdown2:
         for(bar=limit; bar>=0 && !IsStopped(); bar--)
           {
            ColorBuffer[bar]=0;
            if(BullsBearsEyes[bar]<LowLevel) ColorBuffer[bar]=1;
            if(BullsBearsEyes[bar]>HighLevel) ColorBuffer[bar]=2;
           }
         break;
         //----
      case breakdown3:
         for(bar=limit; bar>=0 && !IsStopped(); bar--)
           {
            int bar1=bar+1;
            if(BullsBearsEyes[bar1]>=HighLevel&&BullsBearsEyes[bar]<HighLevel) trend=-1;
            if(BullsBearsEyes[bar1]>=LowLevel&&BullsBearsEyes[bar]<LowLevel) trend=-1;
            //----
            if(BullsBearsEyes[bar1]<=LowLevel&&BullsBearsEyes[bar]>LowLevel) trend=+1;
            if(BullsBearsEyes[bar1]<=HighLevel&&BullsBearsEyes[bar]>HighLevel) trend=+1;
            if(bar==1) trend_=trend;
            //----
            ColorBuffer[bar]=0;
            if(trend<0) ColorBuffer[bar]=1;
            if(trend>0) ColorBuffer[bar]=2;
           }
         break;
     }
//----
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      SignBuffer[bar]=0;
      int bar1=bar+1;
      //----
      if(SignBuffer[bar1]>0 && ColorBuffer[bar]==1) SignBuffer[bar]=-2;
      else if((SignBuffer[bar1]<=0 && ColorBuffer[bar]==1) || (SignBuffer[bar+1]<0 && !ColorBuffer[bar])) SignBuffer[bar]=-1;
      //----
      if(SignBuffer[bar+1]<0 && ColorBuffer[bar]==2) SignBuffer[bar]=+2;
      else if((SignBuffer[bar1]>=0 && ColorBuffer[bar]==2) || (SignBuffer[bar1]>0 && !ColorBuffer[bar])) SignBuffer[bar]=+1;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
