//+------------------------------------------------------------------+ 
//|                                             Laguerre_ROC_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.60"
//----     
#property indicator_separate_window
//----    3
#property indicator_buffers 3 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_COLOR_HISTOGRAM2
//----     
#property indicator_color1  clrDarkOrange,clrBrown,clrGray,clrBlue,clrDeepSkyBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Laguerre_ROC"
//+----------------------------------------------+
//|                 |
//+----------------------------------------------+
#property indicator_maximum +1.1
#property indicator_minimum -0.1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+  
enum WIDTH
  {
   Width_1=1, //1
   Width_2,   //2
   Width_3,   //3
   Width_4,   //4
   Width_5    //5
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum STYLE
  {
   SOLID_,       //  
   DASH_,        //  
   DOT_,         //  
   DASHDOT_,     // - 
   DASHDOTDOT_   // -    
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;           //  
input uint vPeriod=5;                                // 
input double gamma=0.500;                            //                  
input double UpLevel=0.75;                           //    %%
input double DnLevel=0.25;                           //    %%
input color UpLevelsColor=clrMagenta;                //   
input color DnLevelsColor=clrMagenta;                //   
input STYLE Levelstyle=DASH_;                        //  
input WIDTH  LevelsWidth=Width_1;                    //  
input int  Shift=0;                                  //      
input bool ReDraw=true;                              //      
//+----------------------------------------------+
//----      
int min_rates_total;
//----      
int Ind_Handle;
//----   ,    
//----      
double UpIndBuffer[],DnIndBuffer[],ColorIndBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//----
   return(StringSubstr(EnumToString(timeframe),7,-1));
  }
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=3;
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    Laguerre_ROC       ");
      return(INIT_FAILED);
     }
//----    Laguerre_ROC
   Ind_Handle=iCustom(Symbol(),TimeFrame,"Laguerre_ROC",vPeriod,gamma,UpLevel,DnLevel,CLR_NONE,CLR_NONE,SOLID_,Width_1,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Laguerre_ROC");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,UpIndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(UpIndBuffer,true);
//----      
   SetIndexBuffer(1,DnIndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(DnIndBuffer,true);
//----     ,     
   SetIndexBuffer(2,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   string shortname;
   StringConcatenate(shortname,"Laguerre_ROC HTF( ",GetStringTimeframe(TimeFrame)," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//----     
   IndicatorSetInteger(INDICATOR_LEVELS,3);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,UpLevel);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,UpLevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,Levelstyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelsWidth);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,DnLevel);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,DnLevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,Levelstyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelsWidth);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,0.5);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrGray);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,DASHDOTDOT_);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,0);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----   
   int limit,bar;
//----     
   double UpInd[2],DnInd[2],Col[1];
   datetime IndTime[1];
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      UpIndBuffer[bar]=EMPTY_VALUE;
      DnIndBuffer[bar]=EMPTY_VALUE;
      ColorIndBuffer[bar]=0;
      //----      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      //----
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         //----      
         if(CopyBuffer(Ind_Handle,0,time[bar],1,UpInd)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,1,time[bar],1,DnInd)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,2,time[bar],1,Col)<=0) return(RESET);
         //----      
         UpIndBuffer[bar]=UpInd[0];
         DnIndBuffer[bar]=DnInd[0];
         ColorIndBuffer[bar]=Col[0];
        }
      //----
      if(ReDraw)
        {
         if(UpIndBuffer[bar+1]!=EMPTY_VALUE && UpIndBuffer[bar]==EMPTY_VALUE)
           {
            UpIndBuffer[bar]=UpIndBuffer[bar+1];
            DnIndBuffer[bar]=DnIndBuffer[bar+1];
            ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
