//+------------------------------------------------------------------+
//|                                                       KAGI-1.mq5 |
//|                           Copyright  2005,   |
//|                                   http://www.traderstools.h15.ru |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2005,  "
//----    
#property link      "http://www.traderstools.h15.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    3
#property indicator_buffers 3 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrMagenta,clrTeal
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "KAGI-1"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input bool Percent=true;
input uint Threshold=1;
input uint Size=12;
//+-----------------------------------+
//----   ,    
//----      
double KagiBuffer[];
double IndBuffer[];
double ColorIndBuffer[];
//----
double dThreshold;
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   min_rates_total=2;
   dThreshold=Threshold/_Point;
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----      
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//----      
   SetIndexBuffer(2,KagiBuffer,INDICATOR_CALCULATIONS);
//----       
   ArraySetAsSeries(KagiBuffer,true);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname="KAGI-1";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double;
//----   
   int i,j,Ind,size1,Threshold1,KagiBuffShift=0;
//----         
   ArraySetAsSeries(close,true);
//----
   KagiBuffer[KagiBuffShift]=close[rates_total-1];
//----
   for(int bar=rates_total-2; bar>=0; bar--)
     {
      if(Percent) Threshold1=int(close[bar]/100*dThreshold);
      else Threshold1=int(Threshold);
      //----
      if(!KagiBuffShift)
        {
         if(close[bar]>=KagiBuffer[KagiBuffShift]+Threshold1*_Point)
           {
            KagiBuffShift++;
            KagiBuffer[KagiBuffShift]=close[bar];
           }
         //----
         if(close[bar]<=KagiBuffer[KagiBuffShift]-Threshold1*_Point)
           {
            KagiBuffShift++;
            KagiBuffer[KagiBuffShift]=close[bar];
           }
        }
      //----
      if(KagiBuffShift>0)
        {
         if(KagiBuffer[KagiBuffShift]>KagiBuffer[KagiBuffShift-1])
           {
            if(close[bar]>KagiBuffer[KagiBuffShift]) KagiBuffer[KagiBuffShift]=close[bar];
            //----
            if(close[bar]<=KagiBuffer[KagiBuffShift]-Threshold1*_Point)
              {
               KagiBuffShift++;
               KagiBuffer[KagiBuffShift]=close[bar];
              }
           }
         //----
         if(KagiBuffer[KagiBuffShift]<KagiBuffer[KagiBuffShift-1])
           {
            if(close[bar]<KagiBuffer[KagiBuffShift]) KagiBuffer[KagiBuffShift]=close[bar];
            //----
            if(close[bar]>=KagiBuffer[KagiBuffShift]+Threshold1*_Point)
              {
               KagiBuffShift++;
               KagiBuffer[KagiBuffShift]=close[bar];
              }
           }
        }
     }
//---- 
   size1=int(MathMin(MathMax(3,Size),50));
//----
   for(i=rates_total-1; i>=0; i--) IndBuffer[i]=0.0;
//----
   for(i=0; i<=KagiBuffShift; i++)
      for(j=0; j<size1; j++)
        {
         int barX=MathMin(MathMax((KagiBuffShift-i)*size1-j,0),rates_total-1);
         IndBuffer[barX]=KagiBuffer[i];
         ColorIndBuffer[barX]=0;
        }
//----    
   if(KagiBuffer[0]<KagiBuffer[1]) Ind=1;
   else Ind=2;
//----    
   for(i=0; i<2; i++) for(j=0; j<size1; j++)
      if(Ind==1 || Ind==2) ColorIndBuffer[MathMin(MathMax((KagiBuffShift-i)*size1-j,0),rates_total-1)]=1;
//----
   for(i=2; i<=KagiBuffShift; i++)
     {
      if(Ind==2 && KagiBuffer[i]>KagiBuffer[i-1] && KagiBuffer[i]>KagiBuffer[i-2])
        {
         ColorIndBuffer[MathMin(MathMax((KagiBuffShift-i)*size1+1,0),rates_total-1)]=1;
         Ind=1;
        }
      //----
      if(Ind==1 && KagiBuffer[i]<KagiBuffer[i-1] && KagiBuffer[i]<KagiBuffer[i-2])
        {
         ColorIndBuffer[MathMin(MathMax((KagiBuffShift-i)*size1,0),rates_total-1)]=1;
         Ind=2;
        }
      //----
      if(Ind==1) for(j=0; j<size1; j++) ColorIndBuffer[MathMin(MathMax((KagiBuffShift-i)*size1-j,0),rates_total-1)]=1;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
