//+------------------------------------------------------------------+
//|                                               OrderTimeAlert.mq4 |
//|                                                         Tapochun |
//|                           https://www.mql5.com/ru/users/tapochun |
//+------------------------------------------------------------------+
#property copyright "Tapochun"
#property link      "https://www.mql5.com/ru/users/tapochun"
#property version   "1.01"
#property strict
#property description "        "
#property description "v 1.01 -     ( /Sounds)"
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
string globGVName="PTA_lastOrderTicket";
//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
input int inpNum = 10;                    //   ()  
input int inpTimerFreqSec = 1;            //   (), 
input int inpMagic = 0;                   //     (0 -  )
input string inpSymbol = "";              //    ( -  )
input bool inpUsePrint = true;            //   
input string inpSoundName = "Alert2.wav"; //   - 
//+------------------------------------------------------------------+
//|                                      |
//+------------------------------------------------------------------+
int OnInit()
  {
//---   
   EventSetTimer(inpTimerFreqSec);
//---    
   if(!GlobalVariableCheck(globGVName ) )     //     
      GlobalVariableSet( globGVName,0 );      //  

   return( INIT_SUCCEEDED );
  }
//+------------------------------------------------------------------+
//|  -                                                  |
//+------------------------------------------------------------------+
void OnTimer()
  {
   int total = OrdersTotal();                  //   
   if(total <= 0 ) return;                     //     - 

   int oType;                                   //  
   int oTicket;                                 //  
   datetime oTime;                              //   
   datetime currentTime;                        //  
   int lastOrderTicket=int(GlobalVariableGet(globGVName));      //    ""  ( )

   for(int i=total-1; i>=0; i--) //    
     {
      if(OrderSelect(i,SELECT_BY_POS)) //   
        {
         if(inpSymbol=="" || inpSymbol==OrderSymbol()) //   ,      
           {
            oType = OrderType();                                    //   
            if( oType == OP_BUY || oType == OP_SELL )               //    (/)
              {
               if(inpMagic==0 || inpMagic==OrderMagicNumber())//   ,      
                 {
                  oTime=OrderOpenTime();                           //    
                  currentTime= TimeCurrent();                      //   
                  oTicket = OrderTicket();                         //   
                  if( currentTime - oTime >= inpNum && lastOrderTicket < oTicket )     //        inpNum . ..
                    {                                                                  // ..     
                     if( inpUsePrint )                                                 //      
                        Print(_Symbol+": c    #",OrderTicket(),"    ",inpNum," !");

                     if(!PlaySound(inpSoundName)) //     -   
                        Print("!   "+inpSoundName+"  !   .     /Sounds");

                     GlobalVariableSet(globGVName,oTicket);      //     
                     break;                                      //     
                    }
                  else if(lastOrderTicket>=oTicket) break;      //     - 
                 }
              }
           }
        }
      else                                     //     -     
      Print(" #",_LastError,"!  #",i," c  #",OrderTicket(),"  !");
     }
  }
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
void OnDeinit(const int reason) //  
  {
   if(reason == REASON_REMOVE ||       //      ..
      reason == REASON_ACCOUNT ||      // ..  . /.    ..
      reason == REASON_TEMPLATE )      // ..   
     {
      //---    
      GlobalVariableDel(globGVName);
     }
//---    
   EventKillTimer();
  }
//+------------------------------------------------------------------+
