//+------------------------------------------------------------------+
//|                                                     fuzzynet.mqh |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
//| Implementation of FuzzyNet library in MetaQuotes Language 4(MQL4)|
//|                                                                  |
//| The features of the FuzzyNet library include:                    |
//| - Create Mamdani fuzzy model                                     |
//| - Create Sugeno fuzzy model                                      |
//| - Normal membership function                                     |
//| - Triangular membership function                                 |
//| - Trapezoidal membership function                                |
//| - Constant membership function                                   |
//| - Defuzzification method of center of gravity (COG)              |
//| - Defuzzification method of bisector of area (BOA)               |
//| - Defuzzification method of mean of maxima (MeOM)                |
//|                                                                  |
//| If you find any functional differences between FuzzyNet for MQL4 |
//| and the original FuzzyNet project , please contact developers of |
//| MQL4 on the Forum at www.mql4.com.                               |
//|                                                                  |
//| You can report bugs found in the computational algorithms of the |
//| FuzzyNet library by notifying the FuzzyNet project coordinators  |
//+------------------------------------------------------------------+
//|                         SOURCE LICENSE                           |
//|                                                                  |
//| This program is free software; you can redistribute it and/or    |
//| modify it under the terms of the GNU General Public License as   |
//| published by the Free Software Foundation (www.fsf.org); either  |
//| version 2 of the License, or (at your option) any later version. |
//|                                                                  |
//| This program is distributed in the hope that it will be useful,  |
//| but WITHOUT ANY WARRANTY; without even the implied warranty of   |
//| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the     |
//| GNU General Public License for more details.                     |
//|                                                                  |
//| A copy of the GNU General Public License is available at         |
//| http://www.fsf.org/licensing/licenses                            |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
#property script_show_inputs
//+------------------------------------------------------------------+
//| Connecting libraries                                             |
//+------------------------------------------------------------------+
#include <Math\FuzzyNet\MamdaniFuzzySystem.mqh>
//--- input parameters
input double   Service;
input double   Food;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- Mamdani Fuzzy System  
   MamdaniFuzzySystem *fsTips=new MamdaniFuzzySystem();
//--- Create first input variables for the system
   FuzzyVariable *fvService=new FuzzyVariable("service",0.0,10.0);
   fvService.Terms().Add(new FuzzyTerm("poor", new TriangularMembershipFunction(-5.0, 0.0, 5.0)));
   fvService.Terms().Add(new FuzzyTerm("good", new TriangularMembershipFunction(0.0, 5.0, 10.0)));
   fvService.Terms().Add(new FuzzyTerm("excellent", new TriangularMembershipFunction(5.0, 10.0, 15.0)));
   fsTips.Input().Add(fvService);
//--- Create second input variables for the system
   FuzzyVariable *fvFood=new FuzzyVariable("food",0.0,10.0);
   fvFood.Terms().Add(new FuzzyTerm("rancid", new TrapezoidMembershipFunction(0.0, 0.0, 1.0, 3.0)));
   fvFood.Terms().Add(new FuzzyTerm("delicious", new TrapezoidMembershipFunction(7.0, 9.0, 10.0, 10.0)));
   fsTips.Input().Add(fvFood);
//--- Create Output
   FuzzyVariable *fvTips=new FuzzyVariable("tips",0.0,30.0);
   fvTips.Terms().Add(new FuzzyTerm("cheap", new TriangularMembershipFunction(0.0, 5.0, 10.0)));
   fvTips.Terms().Add(new FuzzyTerm("average", new TriangularMembershipFunction(10.0, 15.0, 20.0)));
   fvTips.Terms().Add(new FuzzyTerm("generous", new TriangularMembershipFunction(20.0, 25.0, 30.0)));
   fsTips.Output().Add(fvTips);
//--- Create three Mamdani fuzzy rule
   MamdaniFuzzyRule *rule1 = fsTips.ParseRule("if (service is poor )  or (food is rancid) then tips is cheap");
   MamdaniFuzzyRule *rule2 = fsTips.ParseRule("if ((service is good)) then tips is average");
   MamdaniFuzzyRule *rule3 = fsTips.ParseRule("if (service is excellent) or (food is delicious) then (tips is generous)");
//--- Add three Mamdani fuzzy rule in system
   fsTips.Rules().Add(rule1);
   fsTips.Rules().Add(rule2);
   fsTips.Rules().Add(rule3);
//--- Set input value
   CList *in=new CList;
   Dictionary_Obj_Double *p_od_Service=new Dictionary_Obj_Double;
   Dictionary_Obj_Double *p_od_Food=new Dictionary_Obj_Double;
   p_od_Service.SetAll(fvService, Service);
   p_od_Food.SetAll(fvFood, Food);
   in.Add(p_od_Service);
   in.Add(p_od_Food);
//--- Get result
   CList *result;
   Dictionary_Obj_Double *p_od_Tips;
   result=fsTips.Calculate(in);
   p_od_Tips=result.GetNodeAtIndex(0);
   Alert("Tips, %: ",p_od_Tips.Value());
   delete in;
   delete result;
   delete fsTips;
  }
//+------------------------------------------------------------------+