//+------------------------------------------------------------------+
//|                                             CorrectedAverage.mq5 |
//|                            Copyright  2006, Alexander Piechotta |
//|                                     http://onix-trade.net/forum/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2006, Alexander Piechotta"
//----  
#property link      "http://onix-trade.net/forum/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        clrMediumSlateBlue 
#property indicator_color1 clrMediumSlateBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1  "CorrectedAverage"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_MA_METHOD MA_Method=MODE_SMA; //  
input uint Length=12; //  
input ENUM_APPLIED_PRICE Applied_price=PRICE_CLOSE; //                  
input int Shift=0; //      
input int PriceShift=0; //      
//+-----------------------------------+
//----  
double MABuffer[];
double dPriceShift;
//----   
int min_rates_total;
//----      
int MA_Handle,STD_Handle;
//+------------------------------------------------------------------+    
//| MA indicator initialization function                             | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   switch(int(MA_Method))
     {
      case MODE_SMA: min_rates_total=int(Length); break;
      case MODE_EMA: min_rates_total=2; break;
      case MODE_SMMA: min_rates_total=int(Length)+1; break;
      case MODE_LWMA: min_rates_total=int(Length)+1; break;
     }
   min_rates_total++;
//----    iStdDev
   STD_Handle=iStdDev(NULL,PERIOD_CURRENT,Length,0,MA_Method,Applied_price);
   if(STD_Handle==INVALID_HANDLE)
     {
      Print("      iStdDev");
      return(1);
     }
//----    iMA
   MA_Handle=iMA(NULL,PERIOD_CURRENT,Length,0,MA_Method,Applied_price);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(1);
     }
//----      
   SetIndexBuffer(0,MABuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(MABuffer,true);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"CorrectedAverage( Length = ",Length,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----    
   dPriceShift=_Point*PriceShift;
//----  
   return(0);
  }
//+------------------------------------------------------------------+  
//| MA iteration function                                            | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[]) //     
  {
//----       
   if(BarsCalculated(STD_Handle)<rates_total
      || BarsCalculated(MA_Handle)<rates_total
      || rates_total<min_rates_total+begin) return(RESET);
//----    
   int limit,bar,to_copy;
   double v1,v2,k,MA[],STD[];
//----         
   ArraySetAsSeries(MA,true);
   ArraySetAsSeries(STD,true);
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      to_copy=limit+2;
      //----      
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total+begin);
      for(bar=limit; bar>=0 && !IsStopped(); bar--) MABuffer[bar]=EMPTY_VALUE;
     }
   else
     {
      limit=rates_total-prev_calculated; //      
      to_copy=limit+1;
     }
//----       STD[]  ATR[]
   if(CopyBuffer(MA_Handle,0,0,to_copy,MA)<=0) return(RESET);
   if(CopyBuffer(STD_Handle,0,0,to_copy,STD)<=0) return(RESET);
//----
   if(prev_calculated>rates_total || prev_calculated<=0) MABuffer[limit+1]=MA[limit+1];
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      v1=MathPow(STD[bar],2);
      v2=MathPow(MABuffer[bar+1]-MA[bar],2);
      //----
      if(v2<v1 || !v2) k=0.0;
      else k=1-v1/v2;
      //----
      MABuffer[bar]=MABuffer[bar+1]+k*(MA[bar]-MABuffer[bar+1]);
      MABuffer[bar]+=dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
