//+---------------------------------------------------------------------+
//|                                                       ColorXATR.mq5 | 
//|                                        Copyright  2011, Martingeil | 
//|                                                       fx.09@mail.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Martingeil"
#property link "fx.09@mail.ru"
//----   
#property version   "1.01"
#property description "  ATR"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   1
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrGold,clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "XATR"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint ATRPeriod=12; // ATR 
input Smooth_Method XMA_Method=MODE_JJMA; //  
input uint XLength=5; //                      
input int XPhase=15;  //  
                      //  JJMA    -100 ... +100,     
//  VIDIA   CMO,  AMA    
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer[];
double ColorIndBuffer[];
//----       
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----    ATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)Print("      ATR");
//----     
   min_rates_total=XMA.GetStartBars(XMA_Method,XLength,XPhase)+int(ATRPeriod)+1;
//----       
   XMA.XMALengthCheck("XLength", XLength);
   XMA.XMAPhaseCheck("XPhase", XPhase, XMA_Method);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----    ,   
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----    ,   
   ArraySetAsSeries(ColorIndBuffer,true);
//----      
   string shortname;
   string Smooth=XMA.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"XATR(",ATRPeriod,", ",Smooth,", ",XLength,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double ATR[],xatr;
//----        
   int maxbar,to_copy,limit,bar;
   maxbar=rates_total-int(ATRPeriod)-1;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=maxbar; //      
   else limit=rates_total-prev_calculated; //      
//----
   to_copy=limit+1;
//----    ,     
   ArraySetAsSeries(ATR,true);
//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      xatr=XMA.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,ATR[bar],bar,true);
      IndBuffer[bar]=NormalizeDouble(xatr/_Point,0);
     }
//----  
   if(!prev_calculated) limit--;
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(IndBuffer[bar+1]<IndBuffer[bar]) ColorIndBuffer[bar]=2.0;
      else if(IndBuffer[bar+1]>IndBuffer[bar]) ColorIndBuffer[bar]=1.0;
      else ColorIndBuffer[limit]=0.0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
