//+------------------------------------------------------------------+
//|                                                 ATR_Trailing.mq5 | 
//|                             Copyright  2012,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2012, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description "   -"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2
//----   2  
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+--------------------------------------------+
//|         |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
#property indicator_type2   DRAW_LINE
//----     3
#property indicator_width1 3
#property indicator_width2 3
//----   
#property indicator_color1  LightGreen
#property indicator_color2  Magenta
//----   
#property indicator_label1  "StopLoss Sell"
#property indicator_label2  "StopLoss Buy"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int Period_ATR=14; //  R
input double Sell_Factor=2.0;
input double Buy_Factor=2.0;
//+-----------------------------------+
//----   ,    
//----      
double ExtLineBuffer1[],ExtLineBuffer2[];
//----       
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| SL_ATR indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=Period_ATR;
//----    ATR
   ATR_Handle=iATR(NULL,0,Period_ATR);
   if(ATR_Handle==INVALID_HANDLE)Print("      ATR");
//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
//----  ,      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
//----      
   string shortname;
   StringConcatenate(shortname,"ATR_Trailing(",Period_ATR,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+ 
//| SL_ATR iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar;
   double Range[],ATR;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
      for(bar=rates_total-1; bar>limit && !IsStopped(); bar--)
        {
         ExtLineBuffer1[bar]=0.0;
         ExtLineBuffer2[bar]=0.0;
        }

     }
   else limit=rates_total-prev_calculated; //      
//----     
   to_copy=limit+1;
//----       Range[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,Range)<=0) return(RESET);
//----         
   ArraySetAsSeries(Range,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ATR=Range[bar];
      ExtLineBuffer1[bar]=NormalizeDouble(low[bar]+ATR*Sell_Factor,_Digits);
      ExtLineBuffer2[bar]=NormalizeDouble(high[bar]-ATR*Buy_Factor,_Digits);
     }
//----
   return(rates_total);
  }
//+------------------------------------------------------------------+
