//+------------------------------------------------------------------+ 
//|                                              Rainbow_HMA_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
#property description " Rainbow_HMA       "
//----     
#property indicator_chart_window 
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "Rainbow_HMA"                 //    
#define SIZE 1                                       //      CountIndicator
#define INDTOTAL 60                                  //     
//+----------------------------------------------+
//----   
#property indicator_buffers INDTOTAL 
//----     
#property indicator_plots   INDTOTAL
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_color1 clrPeru
#property indicator_color2 clrPeru
#property indicator_color3 clrPeru
#property indicator_color4 clrPeru
#property indicator_color5 clrPeru
#property indicator_color6 clrPeru
#property indicator_color7 clrPeru
#property indicator_color8 clrPeru
#property indicator_color9 clrPeru
#property indicator_color10 clrPeru
//----
#property indicator_color11 clrBlue
#property indicator_color12 clrBlue
#property indicator_color13 clrBlue
#property indicator_color14 clrBlue
#property indicator_color15 clrBlue
#property indicator_color16 clrBlue
#property indicator_color17 clrBlue
#property indicator_color18 clrBlue
#property indicator_color19 clrBlue
#property indicator_color20 clrBlue
#property indicator_color21 clrBlue
//---- 
#property indicator_color22 clrAqua
#property indicator_color23 clrAqua
#property indicator_color24 clrAqua
#property indicator_color25 clrAqua
#property indicator_color26 clrAqua
#property indicator_color27 clrAqua
#property indicator_color28 clrAqua
#property indicator_color29 clrAqua
#property indicator_color30 clrAqua
#property indicator_color31 clrAqua
#property indicator_color32 clrAqua
#property indicator_color33 clrAqua
//---- 
#property indicator_color34 clrDeepPink
#property indicator_color35 clrDeepPink
#property indicator_color36 clrDeepPink
#property indicator_color37 clrDeepPink
#property indicator_color38 clrDeepPink
#property indicator_color39 clrDeepPink
#property indicator_color40 clrDeepPink
#property indicator_color41 clrDeepPink
#property indicator_color42 clrDeepPink
#property indicator_color43 clrDeepPink
#property indicator_color44 clrDeepPink
#property indicator_color45 clrDeepPink
#property indicator_color46 clrDeepPink
//---- 
#property indicator_color47 clrPurple
#property indicator_color48 clrPurple
#property indicator_color49 clrPurple
#property indicator_color50 clrPurple
#property indicator_color51 clrPurple
#property indicator_color52 clrPurple
#property indicator_color53 clrPurple
#property indicator_color54 clrPurple
#property indicator_color55 clrPurple
#property indicator_color56 clrPurple
#property indicator_color57 clrPurple
#property indicator_color58 clrPurple
#property indicator_color59 clrPurple
#property indicator_color60 clrPurple
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  //   
input uint StartLength=2; //   
input uint StartStep=2;   //     
input uint EndStep=6;     //                                             
input Applied_price_ IPC=PRICE_QUARTER_; //  
input int Shift=0;      //      
input int PriceShift=0; //             
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[];
double ColorIndBuffer[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+  
class CIndBuffers
  {
public:
   double            m_LineBuffer[];
  };
//---   ,   
//---      
CIndBuffers Ind[INDTOTAL];
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    Rainbow_HMA
   Ind_Handle=iCustom(Symbol(),TimeFrame,INDICATOR_NAME,StartLength,StartStep,EndStep,IPC,0,PriceShift);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Rainbow_HMA");
      return(INIT_FAILED);
     }
//----   
   for(int count=0; count<INDTOTAL; count++) IndInit(count,Ind[count].m_LineBuffer,EMPTY_VALUE,min_rates_total,Shift);
//----           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----         
   ArraySetAsSeries(time,true);
//----
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
//----        
   PlotIndexSetInteger(Number,PLOT_DRAW_TYPE,DRAW_LINE);
//----   
   PlotIndexSetString(Number,PLOT_LABEL,"Line "+string(Number+1));
//----
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//----      
//----   limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      for(int count=0; count<INDTOTAL; count++) Ind[count].m_LineBuffer[bar]=EMPTY_VALUE;
      //----       IndTime
      if(CopyTime(Symbol_,TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         //---
         for(int count=0; count<INDTOTAL; count++)
           {
            double Arr[1];
            //----      
            if(CopyBuffer(IndHandle,count,iTime[bar],1,Arr)<=0) return(RESET);
            Ind[count].m_LineBuffer[bar]=Arr[0];
           }
        }
      else for(int count=0; count<INDTOTAL; count++) Ind[count].m_LineBuffer[bar]=Ind[count].m_LineBuffer[bar+1];
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //  
  {
//----     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
