//+---------------------------------------------------------------------+
//|                                                 BWImp-T01_StDev.mq5 | 
//|                             Copyright  2006, HomeSoft-Tartan Corp. | 
//|                        spiky@transkeino.ru - http:\\www.fxexpert.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, HomeSoft-Tartan Corp."
#property link      "spiky@transkeino.ru - http:\\www.fxexpert.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 6
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|             |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrMagenta,clrGray,clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "BWImp-T01"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrRed
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrLime
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----        
#property indicator_color4  clrRed
//----    4  4
#property indicator_width4  4
//----    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_ARROW
//----        
#property indicator_color5  clrLime
//----    5  4
#property indicator_width5  4
//----    
#property indicator_label5  "Up_Signal 2"
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Period1=96; //  1
input uint Period2=3;  //  2
input Smooth_Method XMA_Method=MODE_T3; //  
input uint XLength=8; //                      
input int XPhase=70;  //  
                      //  JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input double dK1=1.5;  //  1   
input double dK2=2.5;  //  2   
input uint std_period=9; //   
input int Shift=0; //      
//----   ,    
//----      
double ExtLineBuffer[],ColorExtLineBuffer[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
double Point10;
//----      
int min_rates_1,min_rates_2,min_rates_total;
//----   
int Count[];
double impr[],impb[],dBWImp[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+   
double Get_dPrice(const double  &Price1[],const double  &Price2[],int index)
  {
   return(Price1[index]-Price2[index]);
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=int(Period1+Period2);
   min_rates_2=min_rates_1+XMA1.GetStartBars(XMA_Method,XLength,XPhase);
   min_rates_total=min_rates_2+int(std_period);
   Point10=_Point/10;
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----       
   ArrayResize(Count,Period2);
   ArrayResize(impr,Period2);
   ArrayResize(impb,Period2);
   ArrayResize(dBWImp,std_period);
//---
   ArrayInitialize(Count,0);
   ArrayInitialize(impr,0.0);
   ArrayInitialize(impb,0.0);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    2  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----     ,     
   SetIndexBuffer(1,ColorExtLineBuffer,INDICATOR_COLOR_INDEX);
//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer1,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer1,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    BearsBuffer   
   SetIndexBuffer(4,BearsBuffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    BullsBuffer   
   SetIndexBuffer(5,BullsBuffer2,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"BWImp-T01_StDev(",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double imppr,imppb,sipr,sipb,sum;
   double SMAdif,Sum,Line,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=int(Period1); //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      imppr=0;
      imppb=0;
      for(int kkk=0; kkk<int(Period1); kkk++)
        {
         double diff=Get_dPrice(close,open,bar-kkk);
         if(diff>0) imppr+=diff;
         if(diff<0) imppb+=diff;
        }
      imppr=MathRound(imppr/_Point);
      imppb=MathRound(imppb/_Point);
      if(!imppr) imppr=Point10;
      if(!imppb) imppb=Point10;
      impr[Count[0]]=imppr;
      impb[Count[0]]=imppb;
      sipr=0;
      sipb=0;
      for(int kkk=0; kkk<int(Period2); kkk++)
        {
         sipr+=impr[kkk];
         sipb+=impb[kkk];
        }
      sipr=MathRound((sipr/Period2));
      sipb=MathRound((sipb/Period2));
      sum=sipr+sipb;
      ExtLineBuffer[bar]=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,sum,bar,false);
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,Period2);
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;
//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int clr=1;
      if(ExtLineBuffer[bar-1]<ExtLineBuffer[bar]) clr=2;
      if(ExtLineBuffer[bar-1]>ExtLineBuffer[bar]) clr=0;
      ColorExtLineBuffer[bar]=clr;
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total;
//----      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dBWImp[iii]=ExtLineBuffer[bar-iii]-ExtLineBuffer[bar-iii-1];
      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dBWImp[iii];
      SMAdif=Sum/std_period;
      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dBWImp[iii]-SMAdif,2);
      //----      StDev   
      StDev=MathSqrt(Sum/std_period);
      //----  
      dstd=NormalizeDouble(dBWImp[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      Line=ExtLineBuffer[bar];
      //----   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=Line; //  
      if(dstd<-Filter2) BEARS2=Line; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=Line; //  
      if(dstd>+Filter2) BULLS2=Line; //  
      //----       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//----         
   return(rates_total);
  }
//+------------------------------------------------------------------+
