//+------------------------------------------------------------------+
//|                                                        Class.mqh |
//|                                           Copyright 2015, fyords |
//|                           https://login.mql5.com/ru/users/fyords |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, fyords"
#property link      "https://login.mql5.com/ru/users/fyords"
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
enum ENUM_USEMASK
  {
   MASK_TRANSPARENT,
   MASK_STANDALONE_RESOURCE,
   MASK_PIXEL,
   MASK_COLOR
  };
//+------------------------------------------------------------------+
//| Bitmap button class                                              |
//+------------------------------------------------------------------+
class CBtn
  {
private:
   long              m_chart_id;          //cahrt id
   int               m_sub_wnd;           //subwindow
   int               m_x;                 //coordinate x
   int               m_y;                 //coordinate y
   int               m_dx;                //width
   int               m_dy;                //height

   bool              m_on;                //on status
   bool              m_enable;            //enable status
   bool              m_active;            //active status
   bool              m_mouse_in_area;     //mouse on button
   bool              m_font_selected;     //font selected

   int               m_chart_width;       //chart width
   int               m_chart_height;      //chart height
   int               m_text_x;            //coordinate x of text
   int               m_text_y;            //coordinate y of text
   int               m_text_font_size;    //font size
   color             m_text_color;        //font color

   string            m_name;              //button name
   string            m_img[7];            //images state of button
   string            m_text_str;          //text of button
   string            m_text_font;         //font name

   bool              m_mask_exist;        //mask was created successfully
   uint              m_mask_data[];       //mask bitmap
   uint              m_text_data[];       //temporary resource for data mix

   CCanvas           m_canva;             //canva of button

   ENUM_BASE_CORNER  m_corner;            //corner of chart
   ENUM_ANCHOR_POINT m_anchor;            //anchor of button

   bool              SetMaskColor(uint);
   bool              SetMaskPixel(int,int);
   bool              SetMaskTranparentOrSAR(string,bool);
   bool              UseMask(ENUM_USEMASK,int,int,uint);
   void              UpdatePropertyObject(void);
   void              UpdatePropertyChart(void);
   bool              CheckWorkWindow(int,int);
   bool              CalculateCoord(int,int);
   bool              SetImgResource(string);

public:
   bool              Create(long,int,string,int,int,int,int);
   void              Resources(string,string,string,string,string,string,string);
   bool              SetUseMask(ENUM_USEMASK,int,int);
   bool              SetUseMask(ENUM_USEMASK,uint);
   bool              SetCorner(ENUM_BASE_CORNER);
   bool              SetAnchor(ENUM_ANCHOR_POINT);
   bool              SetX(int);
   bool              SetY(int);
   bool              SetXY(int,int);
   bool              AddText(int,int,string,int,color,string);
   bool              Text(string);
   bool              Enable(bool);
   bool              On(bool);
   bool              Paint();
   void              Event(int,long,double,string);
   int               GetX(void);
   int               GetY(void);
   bool              GetEnable(void);
   bool              GetOn(void);
   ENUM_BASE_CORNER  GetCorner(void);
   ENUM_ANCHOR_POINT GetAnchor(void);
                     CBtn(void);
                    ~CBtn(void);
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CBtn::CBtn(void)
  {

  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CBtn::~CBtn(void)
  {
   m_canva.Destroy();
   ChartRedraw();
  }
//+------------------------------------------------------------------+
//| Create                                                           |
//+------------------------------------------------------------------+
bool CBtn::Create(long chart_id,int sub_wnd,string name,int x,int y,int dx,int dy)
  {
//--- initialization of variables
   m_chart_id=chart_id;
   m_sub_wnd=sub_wnd;
   m_x=x;
   m_y=y;
   m_dx=dx;
   m_dy=dy;
   m_name=name;
   m_on=false;
   m_enable=true;
   m_active=false;
   m_mouse_in_area=false;
   m_corner=CORNER_LEFT_UPPER;
   m_anchor=ANCHOR_LEFT_UPPER;
   m_mask_exist=false;
   m_font_selected=false;

   ArrayResize(m_text_data,m_dx*m_dy);
//--- create object and set property
   if(!m_canva.CreateBitmapLabel(m_chart_id,m_sub_wnd,m_name,m_x,m_y,m_dx,m_dy,COLOR_FORMAT_ARGB_NORMALIZE)) return(false);
   ResetLastError();
   ChartSetInteger(m_chart_id,CHART_EVENT_MOUSE_MOVE,true);
   ObjectSetInteger(m_chart_id,m_name,OBJPROP_COLOR,clrNONE);
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set bitmaps                                                      |
//+------------------------------------------------------------------+
void CBtn::Resources(string img_up,string img_up_active="",string img_dn="",string img_dn_active="",string img_up_disable="",string img_dn_disable="",string img_mask="")
  {
   if(!m_name) return;
//--- set images
   m_img[0]=img_up;
   m_img[1]=img_up_active;
   m_img[2]=img_dn;
   m_img[3]=img_dn_active;
   m_img[4]=img_up_disable;
   m_img[5]=img_dn_disable;
   m_img[6]=img_mask;
//--- default transparent mask
   UseMask(MASK_TRANSPARENT,0,0,0);
  }
//+------------------------------------------------------------------+
//| Select work mask                                                 |
//+------------------------------------------------------------------+
bool CBtn::SetUseMask(ENUM_USEMASK mask,int x=0,int y=0)
  {
   return(UseMask(mask,x,y,0));
  }
//+------------------------------------------------------------------+
//| Select work mask                                                 |
//+------------------------------------------------------------------+
bool CBtn::SetUseMask(ENUM_USEMASK mask,uint acolor)
  {
   return(UseMask(mask,0,0,acolor));
  }
//+------------------------------------------------------------------+
//| Selection function for mask                                      |
//+------------------------------------------------------------------+
bool CBtn::UseMask(ENUM_USEMASK mask,int x,int y,uint acolor)
  {
   if(!m_name) return(false);

   bool res=false;
//--- select mask
   switch(mask)
     {
      case MASK_TRANSPARENT:
         res=SetMaskTranparentOrSAR(m_img[0],true);
         break;
      case MASK_STANDALONE_RESOURCE:
         res=SetMaskTranparentOrSAR(m_img[6],false);
         break;
      case MASK_PIXEL:
         res=SetMaskPixel(x,y);
         break;
      case MASK_COLOR:
         res=SetMaskColor(acolor);
         break;
      default:
         res=false;
     }
   m_mask_exist=res;
//--- succeed
   return(res);
  }
//+------------------------------------------------------------------+
//| Generate mask for the selected color                             |
//+------------------------------------------------------------------+
bool CBtn::SetMaskColor(uint acolor)
  {
   int array_size;
   int t_dx;
   int t_dy;
//--- load resource
   ResetLastError();
   if(!ResourceReadImage("::"+m_img[0],m_mask_data,t_dx,t_dy)) return(false);
   array_size=ArraySize(m_mask_data);
//--- processed mask
   for(int i=0;i<array_size;i++)
     {
      if(m_mask_data[i]!=acolor) m_mask_data[i]=UINT_MAX;
      else m_mask_data[i]=0;
     }
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Generate mask for the selected pixel                             |
//+------------------------------------------------------------------+
bool CBtn::SetMaskPixel(int x,int y)
  {
   int array_size;
   int t_dx;
   int t_dy;
   uint mask_color;
   int mask_pixel_adr;
//--- load resource
   ResetLastError();
   if(!ResourceReadImage("::"+m_img[0],m_mask_data,t_dx,t_dy)) return(false);
   array_size=ArraySize(m_mask_data);
//--- checking coordinate
   mask_pixel_adr=x+y*t_dx;
   if(mask_pixel_adr>=array_size) return(false);
   mask_color=m_mask_data[x+y*t_dx];
//--- processed mask
   for(int i=0;i<array_size;i++)
     {
      if(m_mask_data[i]!=mask_color) m_mask_data[i]=UINT_MAX;
      else m_mask_data[i]=0;
     }
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Generate mask for the selected ressource or transparent          |
//+------------------------------------------------------------------+
bool CBtn::SetMaskTranparentOrSAR(string resource_name,bool transparent)
  {
   int array_size;
   int t_dx;
   int t_dy;
   uint mask_color[2];
   uint res_mask_color;
//--- load resource
   ResetLastError();
   if(!ResourceReadImage("::"+resource_name,m_mask_data,t_dx,t_dy)) return(false);
   array_size=ArraySize(m_mask_data);
//--- processed mask
   if(array_size!=m_dx*m_dy) return(false);

   mask_color[0]=0;
   mask_color[1]=UINT_MAX;
//--- search mask borders
   for(int i=0;i<array_size;i++)
     {
      if(m_mask_data[i]>mask_color[0]) mask_color[0]=m_mask_data[i];
      if(m_mask_data[i]<mask_color[1]) mask_color[1]=m_mask_data[i];
     }
   res_mask_color=(uint)(((ulong)mask_color[0]+mask_color[1])/2);
//--- processed mask
   for(int i=0;i<array_size;i++)
     {
      switch(transparent)
        {
         case true:
            if(m_mask_data[i]>res_mask_color) m_mask_data[i]=UINT_MAX;
            else m_mask_data[i]=0;
            break;
         case false:
            if(m_mask_data[i]<res_mask_color) m_mask_data[i]=UINT_MAX;
            else m_mask_data[i]=0;
            break;
        }
     }
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set corner                                                       |
//+------------------------------------------------------------------+
bool CBtn::SetCorner(ENUM_BASE_CORNER corner)
  {
   if(!m_name) return(false);
//--- set property
   m_corner=corner;
   ResetLastError();
   return(ObjectSetInteger(m_chart_id,m_name,OBJPROP_CORNER,m_corner));
  }
//+------------------------------------------------------------------+
//| Set anchor                                                       |
//+------------------------------------------------------------------+
bool CBtn::SetAnchor(ENUM_ANCHOR_POINT anchor)
  {
   if(!m_name) return(false);
//--- set property
   m_anchor=anchor;
   ResetLastError();
   return(ObjectSetInteger(m_chart_id,m_name,OBJPROP_ANCHOR,m_anchor));
  }
//+------------------------------------------------------------------+
//| Set X                                                            |
//+------------------------------------------------------------------+
bool CBtn::SetX(int x)
  {
   if(!m_name) return(false);
//--- set property
   m_x=x;
   ResetLastError();
   return(ObjectSetInteger(m_chart_id,m_name,OBJPROP_XDISTANCE,m_x));
  }
//+------------------------------------------------------------------+
//| Set Y                                                            |
//+------------------------------------------------------------------+
bool CBtn::SetY(int y)
  {
   if(!m_name) return(false);
//--- set property
   m_y=y;
   ResetLastError();
   return(ObjectSetInteger(m_chart_id,m_name,OBJPROP_YDISTANCE,m_y));
  }
//+------------------------------------------------------------------+
//| Set X and Y                                                      |
//+------------------------------------------------------------------+
bool CBtn::SetXY(int x,int y)
  {
   if(!m_name) return(false);
//--- set property
   m_x=x;
   m_y=y;
   ResetLastError();
   if(!ObjectSetInteger(m_chart_id,m_name,OBJPROP_XDISTANCE,m_x)) return(false);
   return(ObjectSetInteger(m_chart_id,m_name,OBJPROP_YDISTANCE,m_y));
  }
//+------------------------------------------------------------------+
//| Set On                                                           |
//+------------------------------------------------------------------+
bool CBtn::On(bool state)
  {
   if(!m_name) return(false);
//--- set property
   m_on=state;
   ResetLastError();
   if(!ObjectSetInteger(m_chart_id,m_name,OBJPROP_STATE,m_on))return(false);
   return(Paint());
  }
//+------------------------------------------------------------------+
//| Set Enable                                                       |
//+------------------------------------------------------------------+
bool CBtn::Enable(bool state)
  {
   if(!m_name) return(false);
//--- set property
   m_enable=state;
   return(Paint());
  }
//+------------------------------------------------------------------+
//| Paint                                                            |
//+------------------------------------------------------------------+
bool CBtn::Paint(void)
  {
   if(!m_name) return(false);

   bool res=false;
   bool change_state=false;
   string resource;

   ResetLastError();
//--- set face button
   if(m_enable)
     {
      if(!m_active && !m_on) resource=m_img[0];
      else
         if(m_active && !m_on) resource=m_img[1];
      else
         if(!m_active && m_on) resource=m_img[2];
      else
         if(m_active && m_on) resource=m_img[3];
     }
   else
     {
      if(!m_on) resource=m_img[4];
      else resource=m_img[5];
     }

   SetImgResource(resource);
   m_canva.Update();

//--- succeed
   return(res);
  }
//+------------------------------------------------------------------+
//| Event                                                            |
//+------------------------------------------------------------------+
void CBtn::Event(int id,long lparam,double dparam,string sparam)
  {
   if(!m_name) {return;}

   int t_x=(int)lparam;
   int t_y=(int)dparam;
   bool change_state=false;

   if(!m_enable) return;
//--- update chart and object property
   if(id==CHARTEVENT_OBJECT_CHANGE || id==CHARTEVENT_OBJECT_DRAG) UpdatePropertyObject();
   if(id==CHARTEVENT_CHART_CHANGE) UpdatePropertyChart();
//--- mouse move event
   if(id==CHARTEVENT_MOUSE_MOVE)
     {
      m_mouse_in_area=CalculateCoord(t_x,t_y);

      if(m_mouse_in_area)
        {
         if(!m_active)
           {
            m_active=true;
            change_state=true;

           }
        }
      else
        {
         if(m_active)
           {
            m_active=false;
            change_state=true;
           }
        }
     }
//--- mouse click event
   if(id==CHARTEVENT_OBJECT_CLICK)
     {
      if(m_active)
        {
         m_on=!m_on;
         change_state=true;
        }
     }
   if(change_state) Paint();
  }
//+------------------------------------------------------------------+
//| Update property from the object                                  |
//+------------------------------------------------------------------+
void CBtn::UpdatePropertyObject(void)
  {
   int res=0;
   ResetLastError();
   bool t_on=(bool)ObjectGetInteger(m_chart_id,m_name,OBJPROP_STATE);
   m_x=(int)ObjectGetInteger(m_chart_id,m_name,OBJPROP_XDISTANCE);
   m_y=(int)ObjectGetInteger(m_chart_id,m_name,OBJPROP_YDISTANCE);
   m_corner=(ENUM_BASE_CORNER)ObjectGetInteger(m_chart_id,m_name,OBJPROP_CORNER);

   if(m_on!=t_on)
     {
      m_on=t_on;
      Paint();
     }
  }
//+------------------------------------------------------------------+
//| Update property from the chart                                   |
//+------------------------------------------------------------------+
void CBtn::UpdatePropertyChart()
  {
   ResetLastError();
   m_chart_width=(int)ChartGetInteger(m_chart_id,CHART_WIDTH_IN_PIXELS);
   m_chart_height=(int)ChartGetInteger(m_chart_id,CHART_HEIGHT_IN_PIXELS);
  }
//+------------------------------------------------------------------+
//| Check of work window                                             |
//+------------------------------------------------------------------+
bool CBtn::CheckWorkWindow(int x,int y)
  {
   int t_sub_wnd;
   datetime t_time;
   double t_price;
//--- check of work window
   ResetLastError();
   if(!ChartGetInteger(m_chart_id,CHART_WINDOW_IS_VISIBLE,1)) return(true);
   ChartXYToTimePrice(m_chart_id,x,y,t_sub_wnd,t_time,t_price);

   if(m_sub_wnd==t_sub_wnd) return(true);
   else return(false);
  }
//+------------------------------------------------------------------+
//| Calculate coordinate of mouse                                    |
//+------------------------------------------------------------------+
bool CBtn::CalculateCoord(int x,int y)
  {
   if(!m_mask_exist) return(false);

   bool res=false;
   int limits[4]={0};

   if(!CheckWorkWindow(x,y)) return(false);

   ResetLastError();
   int window_correction=0;
   if(m_sub_wnd!=0 && (m_corner==CORNER_LEFT_LOWER || m_corner==CORNER_RIGHT_LOWER))
      for(int w=1;w<=m_sub_wnd;w++) window_correction+=(int)ChartGetInteger(m_chart_id,CHART_HEIGHT_IN_PIXELS,w);
   else
      window_correction=(int)ChartGetInteger(m_chart_id,CHART_WINDOW_YDISTANCE,m_sub_wnd);
//--- correction with anchor
   switch(m_anchor)
     {
      case ANCHOR_LEFT_UPPER:
         limits[0]=m_x;
         limits[1]=m_y;
         limits[2]=m_x+m_dx;
         limits[3]=m_y+m_dy;
         break;
      case ANCHOR_UPPER:
         limits[0]=m_x-m_dx/2;
         limits[1]=m_y;
         limits[2]=m_x+m_dx/2;
         limits[3]=m_y+m_dy;
         break;
      case ANCHOR_RIGHT_UPPER:
         limits[0]=m_x-m_dx;
         limits[1]=m_y;
         limits[2]=m_x;
         limits[3]=m_y+m_dy;
         break;
      case ANCHOR_LEFT:
         limits[0]=m_x;
         limits[1]=m_y-m_dy/2;
         limits[2]=m_x+m_dx;
         limits[3]=m_y+m_dy/2;
         break;
      case ANCHOR_CENTER:
         limits[0]=m_x-m_dx/2;
         limits[1]=m_y-m_dy/2;
         limits[2]=m_x+m_dx/2;
         limits[3]=m_y+m_dy/2;
         break;
      case ANCHOR_RIGHT:
         limits[0]=m_x-m_dx;
         limits[1]=m_y-m_dy/2;
         limits[2]=m_x;
         limits[3]=m_y+m_dy/2;
         break;
      case ANCHOR_LEFT_LOWER:
         limits[0]=m_x;
         limits[1]=m_y-m_dy;
         limits[2]=m_x+m_dx;
         limits[3]=m_y;
         break;
      case ANCHOR_LOWER:
         limits[0]=m_x-m_dx/2;
         limits[1]=m_y-m_dy;
         limits[2]=m_x+m_dx/2;
         limits[3]=m_y;
         break;
      case ANCHOR_RIGHT_LOWER:
         limits[0]=m_x-m_dx;
         limits[1]=m_y-m_dy;
         limits[2]=m_x;
         limits[3]=m_y;
         break;
     }
//--- correction with corner
   switch(m_corner)
     {
      case CORNER_LEFT_UPPER:
         if(x>limits[0] && x<limits[2] && y-window_correction>limits[1] && y-window_correction<limits[3]) res=true;
         break;
      case CORNER_RIGHT_UPPER:
         limits[0]=m_chart_width-limits[0]-2*m_dx;
         limits[2]=m_chart_width-limits[2];
         if(x>limits[0] && x<limits[2] && y-window_correction>limits[1] && y-window_correction<limits[3]) res=true;
         break;
      case CORNER_LEFT_LOWER:
         limits[1]=m_chart_height-limits[1]-2*m_dy;
         limits[3]=m_chart_height-limits[3];
         if(x>limits[0] && x<limits[2] && y-window_correction>limits[1] && y-window_correction<limits[3]) res=true;
         break;
      case CORNER_RIGHT_LOWER:
         limits[0]=m_chart_width-limits[0]-2*m_dx;
         limits[1]=m_chart_height-limits[1]-2*m_dy;
         limits[2]=m_chart_width-limits[2];
         limits[3]=m_chart_height-limits[3];
         if(x>limits[0] && x<limits[2] && y-window_correction>limits[1] && y-window_correction<limits[3]) res=true;
         break;
     }
//--- if mouse on button
   if(res && m_mask_data[x-limits[0]+(y-window_correction-limits[1])*m_dx]!=0) return(true);
   else return(false);
  }
//+------------------------------------------------------------------+
//| Get x                                                            |
//+------------------------------------------------------------------+
int CBtn::GetX(void)
  {
   return(m_x);
  }
//+------------------------------------------------------------------+
//| Get Y                                                            |
//+------------------------------------------------------------------+
int CBtn::GetY(void)
  {
   return(m_y);
  }
//+------------------------------------------------------------------+
//| Get Enable                                                       |
//+------------------------------------------------------------------+
bool CBtn::GetEnable(void)
  {
   return(m_enable);
  }
//+------------------------------------------------------------------+
//| Get On                                                           |
//+------------------------------------------------------------------+
bool CBtn::GetOn(void)
  {
   return(m_on);
  }
//+------------------------------------------------------------------+
//| Get Corner                                                       |
//+------------------------------------------------------------------+
ENUM_BASE_CORNER CBtn::GetCorner(void)
  {
   return(m_corner);
  }
//+------------------------------------------------------------------+
//| Get Anchor                                                       |
//+------------------------------------------------------------------+
ENUM_ANCHOR_POINT CBtn::GetAnchor(void)
  {
   return(m_anchor);
  }
//+------------------------------------------------------------------+
//| Add text on button                                               |
//+------------------------------------------------------------------+
bool CBtn::AddText(int x,int y,string font_name,int font_size,color text_color,string text)
  {
   bool res=false;

   m_text_x=x;
   m_text_y=y;
   m_text_font=font_name;
   m_text_font_size=font_size;
   m_text_str=text;
   m_text_color=text_color;
//--- setup of font
   res=m_canva.FontSet(m_text_font,m_text_font_size);
   m_font_selected=res;
//--- succeed
   return(res);
  }
//+------------------------------------------------------------------+
//| Update text on button                                            |
//+------------------------------------------------------------------+
bool CBtn::Text(string text)
  {
   bool res=false;
//--- set text and update
   if(m_font_selected)
     {
      m_text_str=text;
      res=Paint();
     }
//--- succeed
   return(res);
  }
//+------------------------------------------------------------------+
//| Update resource of button                                        |
//+------------------------------------------------------------------+
bool CBtn::SetImgResource(string res_name)
  {
   bool res=false;
   int tx,ty;
   color text_color=m_text_color;

   if(!m_enable) text_color=clrGray;
//--- mix resource of button and text 
   ResetLastError();
   if(!ResourceReadImage("::"+res_name,m_text_data,tx,ty)) return(res);
   if(m_text_str!="") TextOut(m_text_str,m_text_x,m_text_y,TA_CENTER|TA_VCENTER,m_text_data,m_dx,m_dy,ColorToARGB(text_color),COLOR_FORMAT_ARGB_NORMALIZE);
   if(!ResourceCreate(m_name,m_text_data,tx,ty,0,0,tx,COLOR_FORMAT_ARGB_NORMALIZE)) return(res);
   res=ObjectSetString(m_chart_id,m_name,OBJPROP_BMPFILE,"::"+m_name);
//--- succeed
   return(res);
  }
//+------------------------------------------------------------------+
