//+------------------------------------------------------------------+
//|                                                   i-Bul_Jerk.mq5 |
//|                         Copyright  2013,   . aka KimIV | 
//|                                              http://www.kimiv.ru | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2013,   . aka KimIV"
//---    
#property link      "http://www.kimiv.ru"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0    //        
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "i-Bul_Jerk Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "i-Bul_Jerk Buy"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint NumbOfBars    = 3;     //   
input uint PriceDistance = 1000;  //   
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
double dPriceDistance;
//---      
int ATR_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   dPriceDistance=_Point*PriceDistance;
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,NumbOfBars));
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,234);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,233);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---        
   string short_name="i-Bul_Jerk";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit,bar;
   double ATR[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---        ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
   ArraySetAsSeries(Close,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      double bs=GetSignal(bar,High,Low,Close);
      if(bs>0) BuyBuffer[bar]=Low[bar]-0.3*ATR[bar];
      if(bs<0) SellBuffer[bar]=High[bar]+0.3*ATR[bar];
     }
//---     
   return(rates_total);
  }
//+----------------------------------------------------------------------------+
//|                                                                            |
//|                                                     |
//|                                                                            |
//+----------------------------------------------------------------------------+
//|      :  , al22bag@live.com.au                        |
//|           : http://ruforum.mt5.com/members/11292-al22bag                   |
//+----------------------------------------------------------------------------+
//|     : 29.06.2013                                                     |
//|   :     .                        |
//+----------------------------------------------------------------------------+
//|  :                                                                |
//|    nb -                   (0 -  )                       |
//+----------------------------------------------------------------------------+
//|   :                                                    |
//|     1 -                                                             |
//|     0 - ,                                                    |
//|    -1 -                                                            |
//+----------------------------------------------------------------------------+
int GetSignal(int nb,const double &high[],const double &low[],const double &close[])
  {
//---
   int bs=0;
   double hi=NormalizeDouble(high[ArrayMaximum(high,nb,NumbOfBars)],_Digits);
   double lo=NormalizeDouble(low[ArrayMinimum(low,nb,NumbOfBars)],_Digits);
//---
   if(close[nb]-lo>=dPriceDistance) bs=-1;
   if(hi-close[nb]>=dPriceDistance) bs=+1;
//---
   return(bs);
  }
//+------------------------------------------------------------------+
