//+------------------------------------------------------------------+
//|                                            Skype_Test_Script.mq4 |
//|                                                        avoitenko |
//|                        https://login.mql5.com/en/users/avoitenko |
//+------------------------------------------------------------------+
#property copyright  "avoitenko"
#property link       "https://login.mql5.com/en/users/avoitenko"

#property show_inputs

//--- skype status (TOnlineStatus)
#define  STATUS_OFFLINE       1
#define  STATUS_ONLINE        2
#define  STATUS_AWAY          4
#define  STATUS_DONT_DISTURB  16

//--- skype errors
#define  ERROR_UNKNOWN     -1
#define  ERROR_NO_ERRORS   0
#define  ERROR_ATTACH      1
#define  ERROR_AUTHORIZED  2
#define  ERROR_STATUS      3
#define  ERROR_TIMEOUTS    4
#define  ERROR_RUNNING     5
#define  ERROR_SENDING     6
#define  ERROR_VALUE       7
#define  ERROR_ACCESS      8
#define  ERROR_SKYPE4COM   9

//--- import functions
#import "SkypeMQL.dll"
int SkypeSendInstantMessageA(string skype_name,string message,int status);
int SkypeSendSmsMessageA(string phone_number,string message);
#import

//--- input parameters
extern string InpSkypeName     =  "echo123";        // Skype name
extern string InpTextMessage   =  "Hello :)";       // Text message
extern string InpPhoneNumber   =  "+380123456789";  // Phone number
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void start()
  {
   string msg;
   int err;

//--- send IM
   err = SkypeSendInstantMessageA(InpSkypeName,InpTextMessage,STATUS_ONLINE|STATUS_AWAY);
   if(err==ERROR_NO_ERRORS) msg="Sent IM to " + InpSkypeName + ", " + InpTextMessage;
   else msg="Error sending IM to " + InpSkypeName + ", error: " + SkypeErrorToStr(err);
   Print(msg);

//--- send SMS
   err = SkypeSendSmsMessageA(InpPhoneNumber,InpTextMessage);
   if(err==ERROR_NO_ERRORS) msg="Sent SMS to " + InpPhoneNumber + ", " + InpTextMessage;
   else msg = "Error sending SMS to " + InpPhoneNumber + ", error: " + SkypeErrorToStr(err);
   Print(msg);

  }
//+------------------------------------------------------------------+
//|   SkypeErrorToStr                                                |
//+------------------------------------------------------------------+
string SkypeErrorToStr(int err_no)
{
   switch(err_no)
   {
      case ERROR_UNKNOWN:     return("Unknown error");
      case ERROR_NO_ERRORS:   return("No error");
      case ERROR_ATTACH:      return("Do not attach");
      case ERROR_AUTHORIZED:  return("User not authorized");
      case ERROR_STATUS:      return("Wrong status");
      case ERROR_TIMEOUTS:    return("Timeout is over");
      case ERROR_RUNNING:     return("Skype is not running");
      case ERROR_SENDING:     return("Error sending");
      case ERROR_VALUE:       return("Wrong value");
      case ERROR_ACCESS:      return("Access denied");
      case ERROR_SKYPE4COM:   return("Skype4COM not registered");
   }
}
//+------------------------------------------------------------------+