//+------------------------------------------------------------------+
//|		"Skype Control Library" for MetaTrader 4/5					 |
//|		Author: avoitenko											 |
//+------------------------------------------------------------------+

//--- include
#include <windows.h>
#import "Skype4COM.dll" rename("CreateEvent","_CreateEvent"), rename("SendMessage","_SendMessage")

using namespace SKYPE4COMLib;
using namespace std;

//--- defines
#define	TIMEOUT				100	// msec
#define TIMEOUT_COUNT		10	// wait 1 sec

#define ERROR_UNKNOWN		-1
#define ERROR_NO_ERRORS		0
#define ERROR_ATTACH		1
#define ERROR_AUTHORIZED	2
#define	ERROR_STATUS		3
#define	ERROR_TIMEOUTS		4
#define	ERROR_RUNNING		5
#define	ERROR_SENDING		6
#define ERROR_VALUE			7
#define ERROR_ACCESS		8
#define ERROR_SKYPE4COM		9

//--- global variables
LONG flagSendIM=0;
LONG flagSendSMS=0;

//+------------------------------------------------------------------+
//|		AnsiToUnicode				                                 |
//+------------------------------------------------------------------+
int AnsiToUnicode(wchar_t * unicode_string, char *utf8_string)
{
	int err;

	int res_len = MultiByteToWideChar(
		CP_ACP,				// Code page
		0,					// No flags
		utf8_string,		// Multibyte characters string
		-1,					// The string is NULL terminated
		NULL,				// No buffer yet, allocate it later
		0					// No buffer
		);
	if (res_len == 0) return NULL;

	err = MultiByteToWideChar(
		CP_ACP,				// Code page
		0,					// No flags
		utf8_string,		// Multibyte characters string
		-1,					// The string is NULL terminated
		unicode_string,		// Output buffer
		res_len				// buffer size
		);
	if (err == 0)
	{
		unicode_string=NULL;
		return -1;
	}
	return 0;
}

//+------------------------------------------------------------------+
//|		SkypeSendInstantMessageW									 |
//+------------------------------------------------------------------+
int __stdcall SkypeSendInstantMessageW(wchar_t *skype_name, wchar_t *message, int status)
{
	//--- return value
	int result=ERROR_NO_ERRORS;

	//--- check input values
	if(wcslen(skype_name) == 0 || wcslen(message) == 0 ||
		(skype_name[0] >= '0' && skype_name[0] <= '9')) return(ERROR_VALUE);

	//--- entries to critical section
	int count = TIMEOUT_COUNT;
	do
	{
		Sleep(TIMEOUT);
		if(--count<0) return(ERROR_TIMEOUTS);
	}
	while((InterlockedExchange(&flagSendIM, 1) == 1));

	//--- initialization of Skype pointers
	SKYPE4COMLib::ISkypePtr pSkype;
	SKYPE4COMLib::IChatMessagePtr pMsg;
	SKYPE4COMLib::IUserPtr pUser;

	try
	{
		HRESULT rets = pSkype.CreateInstance(__uuidof(SKYPE4COMLib::Skype));
		HRESULT retm = pMsg.CreateInstance(__uuidof(SKYPE4COMLib::ChatMessage));
		HRESULT retu = pUser.CreateInstance(__uuidof(SKYPE4COMLib::User));
		if(FAILED(rets) || FAILED(retm) || FAILED(retu)) throw ERROR_SKYPE4COM;
	}
	catch(...)
	{
		pSkype	=	NULL;
		pMsg	=	NULL;
		pUser	=	NULL;
		InterlockedExchange(&flagSendIM, 0);
		return ERROR_SKYPE4COM;
	}
	
	//--- work with skype
	try
	{
		if(pSkype->Client->IsRunning)
		{
			//--- start connection
			HRESULT at;
			try
			{
				at = pSkype->Attach(pSkype->GetProtocol(),VARIANT_TRUE);
			}
			catch(...)
			{
				throw ERROR_ACCESS;
			}

			if(SUCCEEDED(at))
			{
				//--- check the user authorization
				VARIANT_BOOL auth = VARIANT_FALSE;

				HRESULT us = pSkype -> get_User(skype_name,&pUser);
				if(SUCCEEDED(us))
				{
					try
					{
						auth = pUser->GetIsAuthorized();
					}
					catch(...)
					{
						throw ERROR_VALUE;
					}
				}
				else throw ERROR_VALUE;

				//--- if user is present in your contacts
				if(auth == VARIANT_TRUE)
				{
					//--- check status
					SKYPE4COMLib::TOnlineStatus ols = pUser->GetOnlineStatus();
					if(((1<<ols) & status) == (1<<ols))
					{
						try
						{
							//--- send message
							pMsg = pSkype-> _SendMessage(skype_name,message);
							if(pMsg->GetStatus() != SKYPE4COMLib::cmsSending) throw ERROR_SENDING;
						}
						catch(...)
						{
							throw ERROR_SENDING;
						}
					}
					else throw ERROR_STATUS;
				}
				else throw ERROR_AUTHORIZED;
			}
			else throw ERROR_ATTACH;
		}
		else throw ERROR_RUNNING;
	}
	catch(int err_no)
	{
		result = err_no;
	}

	pMsg	=	NULL;
	pSkype	=	NULL;
	pUser	=	NULL;

	//--- exit of a critical section
	InterlockedExchange(&flagSendIM, 0);	
	return(result);
}
//+------------------------------------------------------------------+
//|		SkypeSendInstantMessageA		                             |
//+------------------------------------------------------------------+
int __stdcall SkypeSendInstantMessageA(char *skype_name, char *message, int status)
{
	wchar_t *wcs_skype_name = new wchar_t[strlen(skype_name)+1];
	wchar_t *wcs_message = new wchar_t[strlen(message)+1];

	AnsiToUnicode(wcs_skype_name,skype_name);
	AnsiToUnicode(wcs_message,message);

	int result = SkypeSendInstantMessageW(wcs_skype_name, wcs_message, status);

	delete wcs_skype_name;
	delete wcs_message;

	return(result);
}

//+------------------------------------------------------------------+
//|		SkypeSendSmsMessageW		                                 |
//+------------------------------------------------------------------+
int __stdcall SkypeSendSmsMessageW(wchar_t *phone_number, wchar_t *message) 
{
	//--- return value
	int result=ERROR_NO_ERRORS;

	//--- check input values
	if(wcslen(phone_number) < 7 || phone_number[0] != '+' || wcslen(message) == 0) return(ERROR_VALUE);
	for(int i=1; i < (int)wcslen(phone_number); i++)
	{
		if(phone_number[i]<'0' || phone_number[i]>'9') return(ERROR_VALUE);
	}

	//--- entries to critical section
	int count = TIMEOUT_COUNT;
	do
	{
		Sleep(TIMEOUT);
		if(--count<=0) return(ERROR_TIMEOUTS);
	}
	while((InterlockedExchange(&flagSendSMS, 1) == 1));

	//--- initialization of Skype pointers
	SKYPE4COMLib::ISkypePtr pSkype;
	SKYPE4COMLib::ISmsMessagePtr pSms;

	try
	{
		HRESULT rets = pSkype.CreateInstance(__uuidof(SKYPE4COMLib::Skype));
		HRESULT retm = pSms.CreateInstance(__uuidof(SKYPE4COMLib::SmsMessage));
		if(FAILED(rets) || FAILED(retm)) throw ERROR_SKYPE4COM;
	}
	catch(...)
	{
		pSkype	=	NULL;
		pSms	=	NULL;
		InterlockedExchange(&flagSendSMS, 0);
		return ERROR_SKYPE4COM;
	}
	
	//--- work with skype
	try
	{
		if(pSkype->Client->IsRunning)
		{
			//--- start connection
			HRESULT at;
			try
			{
				at = pSkype->Attach(pSkype->GetProtocol(),VARIANT_TRUE);
			}
			catch(...)
			{
				throw ERROR_ACCESS;
			}

			if(SUCCEEDED(at))
			{
				try
				{
					//--- create SMS
					pSms = pSkype->CreateSms(SKYPE4COMLib::smsMessageTypeOutgoing,phone_number);
					pSms->TargetNumbers=phone_number;
					pSms->Body = message;
				}
				catch(...)
				{
					throw ERROR_VALUE;
				}

				try
				{
					//--- send SMS
					pSms->Send();
					if(pSms->GetStatus() != SKYPE4COMLib::smsMessageStatusSendingToServer) throw ERROR_SENDING;
				}
				catch(...)
				{
					throw ERROR_SENDING;
				}
			}
			else throw ERROR_ATTACH;
		}
		else throw ERROR_RUNNING;
	}
	catch(int err_no)
	{
		result	=	err_no;
	}
	pSms	=	NULL;
	pSkype	=	NULL;

	//--- exit of a critical section
	InterlockedExchange(&flagSendSMS, 0);
	return(result);
}

//+------------------------------------------------------------------+
//|		SkypeSendSmsMessageA		                                 |
//+------------------------------------------------------------------+
int __stdcall SkypeSendSmsMessageA(char *phone_number, char *message)
{
	wchar_t *wcs_phone_number = new wchar_t[strlen(phone_number)+1];
	wchar_t *wcs_message = new wchar_t[strlen(message)+1];

	AnsiToUnicode(wcs_phone_number,phone_number);
	AnsiToUnicode(wcs_message,message);

	int result=SkypeSendSmsMessageW(wcs_phone_number, wcs_message);

	delete wcs_phone_number;
	delete wcs_message;

	return(result);
}

//+------------------------------------------------------------------+
//|		DllMain						                                 |
//+------------------------------------------------------------------+
BOOL APIENTRY DllMain( HMODULE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		CoInitialize(NULL);
		flagSendIM=0;
		flagSendSMS=0;
		break;

	case DLL_THREAD_ATTACH:break;
	case DLL_THREAD_DETACH:break;
	case DLL_PROCESS_DETACH:
		CoUninitialize();
		break;
		break;
	}
	return TRUE;
}
//+------------------------------------------------------------------+





