//+------------------------------------------------------------------+
//|                                                testerControl.mqh |
//|                                                     Version: 1.1 |
//+------------------------------------------------------------------+

#property copyright "Copyright  2011, Symr"

#import "specialUser32.ex4"
    int GetComboboxIndex(int hWnd, string text);
#import

#import "user32.dll"
    int GetAncestor(int hWnd, int gaFlags);
    int GetDlgItem(int hDlg, int nIDDlgItem);
    int GetWindow(int hWnd, int uCmd);
    int GetClassNameA(int hWnd, string lpClassname, int nMaxCount);
    int GetWindowThreadProcessId(int hWnd, int& dwProcessId[]);
    int SendMessageA(int hWnd, int Msg, int wParam, int lParam);
    int PostMessageA(int hWnd,int Msg,int wParam,int lParam);
    int GetWindowLongA(int hWnd, int nIndex);
    //int SetWindowLongA(int hWnd, int nIndex, int dwNewLong);
    int IsWindowEnabled(int hWnd);
    //int GetDlgCtrlID(int hWnd);
    int FindWindowExA(int hwndParent, int hwndChildAfter, string lpszClass, string lpszWindow);
    int GetWindowTextA(int hWnd, string lpString, int nMaxCount);
    int GetParent(int hWnd);
#import

#import "kernel32.dll"
    int OpenProcess(int dwDesiredAccess, bool bInheritHandle, int dwProcessId);
    int VirtualAllocEx(int hProcess, int& addr, int size, int dwType, int dwProtect);
   bool VirtualFreeEx(int hProcess, int& addr, int size, int dwType);
   bool WriteProcessMemory(int hProcess, int addr, int buffer[], int size, int& bytes[]);
   void GetSystemTime(int& TimeArray[]);
#import

//+------------------------------------------------------------------+

#define GW_HWNDNEXT              2
#define GW_CHILD                 5

#define ID_TERMINAL              0xE81E
#define ID_TESTER                0x53
#define ID_PANEL                 0x81BF

#define PROCESS_ALL_ACCESS       0x1F0FFF
#define MEM_COMMIT               0x1000
#define MEM_RELEASE              0x8000
#define PAGE_READWRITE           4

//#define DTM_FIRST                0x1000
#define DTM_SETSYSTEMTIME        0x1002
#define GDT_VALID                0

#define CB_SETCURSEL             0x014E

#define BM_GETCHECK              0xF0
#define BM_SETCHECK              0xF1
//#define BST_CHECKED              1
//#define BST_UNCHECKED            0

#define WM_LBUTTONDOWN           0x0201
#define WM_LBUTTONUP             0x0202
#define WM_COMMAND               0x0111

#define TCM_FIRST                0x1300
#define TCM_SETCURSEL            0x130C
#define TCM_SETCURFOCUS          0x1330
#define GWL_ID                   -12

#define TST_POS_LONG_ONLY        "Long only"
#define TST_POS_SHORT_ONLY       "Short only"
#define TST_POS_LONG_SHORT       "Long & Short"

#define TST_OPT_BALANCE          "Balance"
#define TST_OPT_PROFIT_FACTOR    "Profit Factor"
#define TST_OPT_EXPECTED_PAYOFF  "Expected Payoff"
#define TST_OPT_MAXIMAL_DRAWDOWN "Maximal Drawdown"
#define TST_OPT_DRAWDOWN_PERCENT "Drawdown Percent"

//+------------------------------------------------------------------+

void fillArraySetting(string& array[], string data) {
  int index = 0;
  string value = stringSplit(data,";",index);
  while (value != "") {
    ArrayResize(array,ArraySize(array)+1);
    array[ArraySize(array)-1] = value;
    index++;
    value = stringSplit(data,";",index);
  }
}

//+------------------------------------------------------------------+

string stringSplit(string input, string sep, int index) {
  int count=0;
  int oldpos=0;
  int pos=StringFind(input,sep,0);
  while(pos>=0&&count<=index) {
    if(count==index)
      if(pos==oldpos) return("");
        else return(StringSubstr(input,oldpos,pos-oldpos));
    oldpos=pos+StringLen(sep);
    pos=StringFind(input,sep,oldpos);
    count++;
  }
  if(count==index) return(StringSubstr(input,oldpos));
  return("");
}

//+------------------------------------------------------------------+

int hMetaTrader,hTerminal,hTester,hPanel,hFrom,hTo,hVisual,hAdvisor,
    hSymbol,hPeriod,hModel,hDate,hStart,hOpt,hProp;

//+------------------------------------------------------------------+

void InitTester() {
  hMetaTrader = GetAncestor(WindowHandle(Symbol(),Period()),2);
  hTerminal = GetDlgItem(hMetaTrader, ID_TERMINAL);
  hTester = GetDlgItem(hTerminal, ID_TESTER);
  hPanel = GetDlgItem(hTester, ID_PANEL);
  hFrom = FindControlByID(hPanel, "SysDateTimePick32", 0);
  hTo = FindControlByID(hPanel, "SysDateTimePick32", 1);
  hVisual = FindControlByID(hPanel, "SysDateTimePick32", 2);
  hAdvisor = FindControlByID(hPanel, "ComboBox", 0);
  hSymbol = FindControlByID(hPanel, "ComboBox", 1);
  hPeriod = FindControlByID(hPanel, "ComboBox", 2);
  hModel = FindControlByID(hPanel, "ComboBox", 3);
  hProp = FindControlByID(hPanel, "Button", 0);
  hDate = FindControlByID(hPanel, "Button", 4);
  hOpt = FindControlByID(hPanel, "Button", 5);
  hStart = FindControlByID(hPanel, "Button", 9);
}

//+------------------------------------------------------------------+

void SetTesterOptions(string advisor, string symbol, string period, string model, string from, string to) {
  if (advisor != "") SetComboboxIndex(hAdvisor,GetComboboxIndex(hAdvisor,advisor));
  if (symbol != "") SetComboboxIndex(hSymbol,GetComboboxIndex(hSymbol,symbol));
  if (period != "") SetComboboxIndex(hPeriod,GetComboboxIndex(hPeriod,period));
  if (model != "") SetComboboxIndex(hModel,GetComboboxIndex(hModel,model));
  if (from != "" && to != "") {
     SetCheckbox(hDate,true);
     SetControlDateTime(hFrom,StrToTime(from));
     SetControlDateTime(hTo,StrToTime(to));
  } else SetCheckbox(hDate,false);
}

//+------------------------------------------------------------------+

void StartTester(bool wait = true) {
  SendClick(hStart);
  if (wait) {
    while (IsWindowEnabled(hAdvisor) == 1) Sleep(100); // waiting for start
    while (IsWindowEnabled(hAdvisor) == 0) Sleep(100); // waiting for end
  }
}

//+------------------------------------------------------------------+

void SetTestingOptions(string advisor, int money, string currency, string positions, string optpar, bool genetic = false) {
  
  if (advisor == "") return;  
  SetComboboxIndex(hAdvisor,GetComboboxIndex(hAdvisor,advisor));  
  int ancestor = GetAncestor(hMetaTrader,1);
  PostClick(hProp); 
  Sleep(1000);  
  int hExpertProp = findWindowByCaption(ancestor,advisor);
  int hTabControl = FindControlByID(hExpertProp,"SysTabControl32",0);
  //int id = GetWindowLongA(hTabControl, GWL_ID);
  //SendMessageA(hExpertProp,WM_NOTIFY,id,1);
  SendMessageA(hTabControl,TCM_SETCURFOCUS,0,0);
  int hTabPage1 = findWindowByCaption(hExpertProp,"");
  SendMessageA(hTabControl,TCM_SETCURFOCUS,1,0);
  int hTabPage2 = findWindowByCaption(hExpertProp,"");
  SendMessageA(hTabControl,TCM_SETCURFOCUS,2,0);
  int hTabPage3 = findWindowByCaption(hExpertProp,"");  
  SendMessageA(hTabControl,TCM_SETCURFOCUS,0,0);
 
  int hMoney,hCurrency,hPositions,hOptPar,hGenetic,hExpList,hOptList,hOK;

  hOK = FindControlByID(hExpertProp, "Button", 0);
  hMoney = FindControlByID(hTabPage1, "ComboBox", 0);
  hCurrency = FindControlByID(hTabPage1, "ComboBox", 1);
  hPositions = FindControlByID(hTabPage1, "ComboBox", 2);
  hOptPar = FindControlByID(hTabPage1, "ComboBox", 3);
  hGenetic = FindControlByID(hTabPage1, "Button", 1);
  hExpList = FindControlByID(hTabPage2, "SysListView32", 0);
  hOptList = FindControlByID(hTabPage3, "SysListView32", 0);
  
  if (money != 0) SetComboboxIndex(hMoney,GetComboboxIndex(hMoney,money));
  if (currency != "") SetComboboxIndex(hCurrency,GetComboboxIndex(hCurrency,currency));
  if (positions != "") SetComboboxIndex(hPositions,GetComboboxIndex(hPositions,positions));
  if (optpar != "") SetComboboxIndex(hOptPar,GetComboboxIndex(hOptPar,optpar));
  SetCheckbox(hGenetic,genetic);
  
  SendClick(hOK);  
}

//+------------------------------------------------------------------+

int FindControlByID(int hParentWnd, string className, int id) {
  if (id < 0 || hParentWnd <=0) return;
  int cnt = 0;
  int child = GetWindow(hParentWnd,GW_CHILD);
  while (child != 0) {
    child = GetWindow(child,GW_HWNDNEXT);
    string name = "                                                  ";
    int res = GetClassNameA(child,name,50);
    if (name == className || className == "")
      if (cnt == id) break; else cnt++;
  }
  return (child);
}

//+------------------------------------------------------------------+

void SetControlDateTime(int hWnd, datetime time) {
  int hProcessId[1];
  if (GetWindowThreadProcessId(hWnd, hProcessId) == 0) return;
  int hProcess = OpenProcess(PROCESS_ALL_ACCESS, False, hProcessId[0]);
  int addr = 0;
  int p = VirtualAllocEx(hProcess, addr, 2710, MEM_COMMIT, PAGE_READWRITE); 
  int TimeArray[4];
  GetSystemTime(TimeArray);
  int bytes[1];
  TimeArray[0] = TimeYear(time) + (TimeMonth(time) * 0x10000);
  TimeArray[1] = TimeDay(time) * 0x10000;
  WriteProcessMemory(hProcess, p, TimeArray, 16, bytes);
  SendMessageA(hWnd, DTM_SETSYSTEMTIME, GDT_VALID, p);
  VirtualFreeEx(hProcess, p, 0, MEM_RELEASE);
}

//+------------------------------------------------------------------+

void SetComboboxIndex(int hWnd, int index) {
  SendMessageA(hWnd, CB_SETCURSEL, index, 0);
}

//+------------------------------------------------------------------+

void SendClick(int hWnd) {
  SendMessageA(hWnd,WM_LBUTTONDOWN,0,0);
  SendMessageA(hWnd,WM_LBUTTONUP,0,0);
}

//+------------------------------------------------------------------+

void PostClick(int hWnd) {
  PostMessageA(hWnd,WM_LBUTTONDOWN,0,0);
  PostMessageA(hWnd,WM_LBUTTONUP,0,0);
}

//+------------------------------------------------------------------+

void SetCheckbox(int hWnd, bool checked) {
  int ch = SendMessageA(hWnd, BM_GETCHECK, 0, 0);
  if (ch != checked)
    //SendMessageA(hWnd, BM_SETCHECK, MathAbs(ch-1), 0);
    //not enough set checkbox, because the control has an event handler for datetimepicker to set enabled/disabled
    SendClick(hWnd);
}

//+------------------------------------------------------------------+

int findWindowByCaption(int hWndParent, string caption) {
  int result = 0;
  string className;
  int child = FindWindowExA(hWndParent,0,"#32770",className);
  while (child != 0) {
    string name = "                                                  ";
    GetWindowTextA(child,name,50);
    if (caption == name || caption == "") {
      result = child;
      break;
    }
    child = FindWindowExA(hWndParent,child,"#32770",className);
  }
  return (result);
}

//+------------------------------------------------------------------+