%--------------------------------------------------------------------------
% SMA with GRNN filter
% (C) 2010, Andrey Emelyanov.
% version 0.0.0.1
%----------------------!!!! WARNING !!!!----------------------------
% Without the y = GRNNFilter(z, Ad) function             - IT DOESN'T WORK!
%--------------------------------------------------------------------------
%   Task definition (SMA "classic" calculation):
%
% 1. Find a Typical Price. For this you need to add together maximum, minimum and 
%    close price of every bar and divide the sum by 3:
%    TP = (HIGH + LOW + CLOSE) / 3 
% 2. Calculate the n-period Simple Moving Average of Typical Prices:
%    SMA (TP, N) = SUM (TP, N) / N 
%
% where:
%  HIGH   maximal price of bar;
%  LOW    minimal price of bar;
%  CLOSE  price of close;
%  SMA    Simple Moving Average;
%  SUM    sum;
%  N      number of bars, used for calculation.
%--------------------------------------------------------------------------
% function y = NeoSMA(in, n, Ad)
%--------------------------------------------------------------------------
%  Input   |         Purpose                | Variable size
%----------|--------------------------------|------------------------------
% in       | input signal                   | 1 x N double
% n        | period, used for calculations  | 1 x 1 double
% Ad       | factor of noise suppression    | 1 x 1 double
%----------|--------------------------------|------------------------------
%  Output  |         Purpose                | Variable size
%----------|--------------------------------|------------------------------
% y        | SMA output signal              | 1 x N double
%--------------------------------------------------------------------------
function y = NeoSMA(in, n, Ad)
MasSize = size(in);
MasSize = MasSize(1, 2);
y(1, MasSize) = 0;
% Calculate the n-period simple
ind = n;
while ind <= MasSize
     i = ind - n;
     sum = 0;
     while i < ind
      i = i + 1;
      sum = sum + in(1, i);
     end
     y(1, ind) = sum/n;
    ind = ind + 1;
end
% Filtering
if Ad > 1
    y = GRNNFilter(y, Ad);
end
%--------------------------------------------------------------------------