%--------------------------------------------------------------------------
% Neural Network Filter (GRNN) for the MARCI indicator                     
% OBJECT OF PROJECT "ASTRAEUS" (GRNN filter #1)                            
% April 25, 2009. (C) 2009 Andrey Emelyanov.                               
% version 0.0.0.1
%--------------------------------------------------------------------------
%   Task definition:
%
% We have signal from MARCI and N values. We need:  
% Teach GRNN with N entries and smooth with Ad efficiency factor
%--------------------------------------------------------------------------
% function y = GRNNFilter(z, Ad)
%--------------------------------------------------------------------------
%  Input   |         Purpose            | Variable size
%----------|----------------------------|----------------------------------
% z        | input signal               | 1 x N double
% Ad       | efficiency factor          | 1 x 1 double
%----------|----------------------------|----------------------------------
%  Output  |         Purpose            | Variable size
%----------|----------------------------|----------------------------------
% y        | output signal              | 1 x N double
%--------------------------------------------------------------------------
function y = GRNNFilter(z, Ad)
x = size(z);
x = x(1, 2);                            %get the size of signal
P = 1:x;                                %create teaching vector
net = newgrnn(P, z, Ad);                %create and teach GPNN
y = sim(net, P);                        %get smoothed signal
%--------------------------------------------------------------------------