//------------------------------------------------------------------------------
//                                                              SpecAnalyzer.mqh
//                                     Copyright 2010, MetaQuotes Software Corp.
//                                                           http://www.mql5.com
//------------------------------------------------------------------------------
#property copyright "2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"

#include <Object.mqh>
#include <Charts\Chart.mqh>
//------------------------------------------------------------------------------
//---------------------------------------------------------- GRaphChart class --
class GRaphChart : public CChart
  {
  protected:
    struct ChartPropertyes
      {
      double shift_size;
      double fixed_max;
      double fixed_min;
      double points_per_bar;
      long   mode;
      bool   foreground;
      bool   shift;
      bool   autoscroll;
      long   scale;
      bool   scalefix;
      bool   scalefix_11;
      bool   scale_pt_per_bar;
      bool   show_ohls;
      bool   show_bid_line;
      bool   show_ask_line;
      bool   show_last_line;
      bool   show_period_sep;
      bool   show_grid;
      long   show_volumes;
      bool   show_object_descr;
      bool   show_trade_levels;
      long  color_background;
      long  color_foreground;
      long  color_grid;
      long  color_volume;
      long  color_chart_up;
      long  color_chart_down;
      long  color_chart_line;
      long  color_candle_bull;
      long  color_candle_bear;
      long  color_bid;
      long  color_ask;
      long  color_last;
      long  color_stop_level;
      string ch_comment;
      };
      ChartPropertyes ChProp;
  
  public:
                    GRaphChart();
                   ~GRaphChart();
                   
          void      SetOwnProperty();
  virtual void      Save();
  virtual void      Load();
  };

//---------------------------------------------------- Constructor GRaphChart --
GRaphChart::GRaphChart()
  {
  m_chart_id=ChartID();
  Save();                                      // Keep a original chart settings
  SetOwnProperty();                                    // Set own chart settings
  }
//----------------------------------------------------- Destructor GRaphChart --
GRaphChart::~GRaphChart()
  {
  Load();                                   // Restore a previous chart settings
  m_chart_id=-1;
  }
//------------------------------------------ Writing chart propertyes to file --
void GRaphChart::Save(void)
  {
  ChProp.shift_size=ChartGetDouble(m_chart_id,CHART_SHIFT_SIZE);
  ChProp.fixed_max=ChartGetDouble(m_chart_id,CHART_FIXED_MAX);
  ChProp.fixed_min=ChartGetDouble(m_chart_id,CHART_FIXED_MIN);
  ChProp.points_per_bar=ChartGetDouble(m_chart_id,CHART_POINTS_PER_BAR);
  ChProp.mode=ChartGetInteger(m_chart_id,CHART_MODE);
  ChProp.foreground=ChartGetInteger(m_chart_id,CHART_FOREGROUND);
  ChProp.shift=ChartGetInteger(m_chart_id,CHART_SHIFT);
  ChProp.autoscroll=ChartGetInteger(m_chart_id,CHART_AUTOSCROLL);
  ChProp.scale=ChartGetInteger(m_chart_id,CHART_SCALE);
  ChProp.scalefix=ChartGetInteger(m_chart_id,CHART_SCALEFIX);
  ChProp.scalefix_11=ChartGetInteger(m_chart_id,CHART_SCALEFIX_11);
  ChProp.scale_pt_per_bar=ChartGetInteger(m_chart_id,CHART_SCALE_PT_PER_BAR);
  ChProp.show_ohls=ChartGetInteger(m_chart_id,CHART_SHOW_OHLC);
  ChProp.show_bid_line=ChartGetInteger(m_chart_id,CHART_SHOW_BID_LINE);
  ChProp.show_ask_line=ChartGetInteger(m_chart_id,CHART_SHOW_ASK_LINE);
  ChProp.show_last_line=ChartGetInteger(m_chart_id,CHART_SHOW_LAST_LINE);
  ChProp.show_period_sep=ChartGetInteger(m_chart_id,CHART_SHOW_PERIOD_SEP);
  ChProp.show_grid=ChartGetInteger(m_chart_id,CHART_SHOW_GRID);
  ChProp.show_volumes=ChartGetInteger(m_chart_id,CHART_SHOW_VOLUMES);
  ChProp.show_object_descr=ChartGetInteger(m_chart_id,CHART_SHOW_OBJECT_DESCR);
  ChProp.show_trade_levels=ChartGetInteger(m_chart_id,CHART_SHOW_TRADE_LEVELS);  
  ChProp.color_background=ChartGetInteger(m_chart_id,CHART_COLOR_BACKGROUND);
  ChProp.color_foreground=ChartGetInteger(m_chart_id,CHART_COLOR_FOREGROUND);
  ChProp.color_grid=ChartGetInteger(m_chart_id,CHART_COLOR_GRID);
  ChProp.color_volume=ChartGetInteger(m_chart_id,CHART_COLOR_VOLUME);
  ChProp.color_chart_up=ChartGetInteger(m_chart_id,CHART_COLOR_CHART_UP);
  ChProp.color_chart_down=ChartGetInteger(m_chart_id,CHART_COLOR_CHART_DOWN);
  ChProp.color_chart_line=ChartGetInteger(m_chart_id,CHART_COLOR_CHART_LINE);
  ChProp.color_candle_bull=ChartGetInteger(m_chart_id,CHART_COLOR_CANDLE_BULL);
  ChProp.color_candle_bear=ChartGetInteger(m_chart_id,CHART_COLOR_CANDLE_BEAR);
  ChProp.color_bid=ChartGetInteger(m_chart_id,CHART_COLOR_BID);
  ChProp.color_ask=ChartGetInteger(m_chart_id,CHART_COLOR_ASK);
  ChProp.color_last=ChartGetInteger(m_chart_id,CHART_COLOR_LAST);
  ChProp.color_stop_level=ChartGetInteger(m_chart_id,CHART_COLOR_STOP_LEVEL);
  ChProp.ch_comment=ChartGetString(m_chart_id,CHART_COMMENT);
  }
//------------------------------------ Restoring chart propertyes from memory --
void GRaphChart::Load(void)
  {
  ChartSetDouble(m_chart_id,CHART_SHIFT_SIZE,ChProp.shift_size);
  ChartSetDouble(m_chart_id,CHART_FIXED_MAX,ChProp.fixed_max);
  ChartSetDouble(m_chart_id,CHART_FIXED_MIN,ChProp.fixed_min);
  ChartSetDouble(m_chart_id,CHART_POINTS_PER_BAR,ChProp.points_per_bar);
  ChartSetInteger(m_chart_id,CHART_MODE,ChProp.mode);
  ChartSetInteger(m_chart_id,CHART_FOREGROUND,ChProp.foreground);
  ChartSetInteger(m_chart_id,CHART_SHIFT,ChProp.shift);
  ChartSetInteger(m_chart_id,CHART_AUTOSCROLL,ChProp.autoscroll);
  ChartSetInteger(m_chart_id,CHART_SCALE,ChProp.scale);
  ChartSetInteger(m_chart_id,CHART_SCALEFIX,ChProp.scalefix);
  ChartSetInteger(m_chart_id,CHART_SCALEFIX_11,ChProp.scalefix_11);
  ChartSetInteger(m_chart_id,CHART_SCALE_PT_PER_BAR,ChProp.scale_pt_per_bar);
  ChartSetInteger(m_chart_id,CHART_SHOW_OHLC,ChProp.show_ohls);
  ChartSetInteger(m_chart_id,CHART_SHOW_BID_LINE,ChProp.show_bid_line);
  ChartSetInteger(m_chart_id,CHART_SHOW_ASK_LINE,ChProp.show_ask_line);
  ChartSetInteger(m_chart_id,CHART_SHOW_LAST_LINE,ChProp.show_last_line);
  ChartSetInteger(m_chart_id,CHART_SHOW_PERIOD_SEP,ChProp.show_period_sep);
  ChartSetInteger(m_chart_id,CHART_SHOW_GRID,ChProp.show_grid);
  ChartSetInteger(m_chart_id,CHART_SHOW_VOLUMES,ChProp.show_volumes);
  ChartSetInteger(m_chart_id,CHART_SHOW_OBJECT_DESCR,ChProp.show_object_descr);
  ChartSetInteger(m_chart_id,CHART_SHOW_TRADE_LEVELS,ChProp.show_trade_levels);  
  ChartSetInteger(m_chart_id,CHART_COLOR_BACKGROUND,ChProp.color_background);
  ChartSetInteger(m_chart_id,CHART_COLOR_FOREGROUND,ChProp.color_foreground);
  ChartSetInteger(m_chart_id,CHART_COLOR_GRID,ChProp.color_grid);
  ChartSetInteger(m_chart_id,CHART_COLOR_VOLUME,ChProp.color_volume);
  ChartSetInteger(m_chart_id,CHART_COLOR_CHART_UP,ChProp.color_chart_up);
  ChartSetInteger(m_chart_id,CHART_COLOR_CHART_DOWN,ChProp.color_chart_down);
  ChartSetInteger(m_chart_id,CHART_COLOR_CHART_LINE,ChProp.color_chart_line);
  ChartSetInteger(m_chart_id,CHART_COLOR_CANDLE_BULL,ChProp.color_candle_bull);
  ChartSetInteger(m_chart_id,CHART_COLOR_CANDLE_BEAR,ChProp.color_candle_bear);
  ChartSetInteger(m_chart_id,CHART_COLOR_BID,ChProp.color_bid);
  ChartSetInteger(m_chart_id,CHART_COLOR_ASK,ChProp.color_ask);
  ChartSetInteger(m_chart_id,CHART_COLOR_LAST,ChProp.color_last);
  ChartSetInteger(m_chart_id,CHART_COLOR_STOP_LEVEL,ChProp.color_stop_level);
  ChartSetString(m_chart_id,CHART_COMMENT,ChProp.ch_comment);
  }
//--------------------------------------------------- Prepare screen for draw --
void GRaphChart::SetOwnProperty(void)
  {
  ChartSetInteger(m_chart_id,CHART_FOREGROUND,1);
  ChartSetInteger(m_chart_id,CHART_SHIFT,0);
  ChartSetInteger(m_chart_id,CHART_AUTOSCROLL,0);
  ChartSetInteger(m_chart_id,CHART_AUTOSCROLL,1);
  ChartSetInteger(m_chart_id,CHART_SCALE,0);
  ChartSetInteger(m_chart_id,CHART_SCALEFIX_11,1);
  ChartSetInteger(m_chart_id,CHART_SHOW_OHLC,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_BID_LINE,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_ASK_LINE,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_LAST_LINE,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_PERIOD_SEP,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_GRID,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_VOLUMES,CHART_VOLUME_HIDE);
  ChartSetInteger(m_chart_id,CHART_SHOW_OBJECT_DESCR,0);
  ChartSetInteger(m_chart_id,CHART_SHOW_TRADE_LEVELS,0);
  ChartSetInteger(m_chart_id,CHART_COLOR_BACKGROUND,Black);
  ChartSetInteger(m_chart_id,CHART_COLOR_FOREGROUND,Black);
  ChartSetDouble(m_chart_id,CHART_FIXED_MIN,0.0);
  }

//------------------------------------------------------------------------------
//------------------------------- AllGrObject class. All gr. objects in chart --
class AllGrObject : public CChart
  {
  protected:
    long      m_chart_id;                                    // chart idintifier
    
  public:
              AllGrObject();
             ~AllGrObject();
                   
    void      AddLabel(string name,int fsize,string font,
                             color col,int x,int y,string text="");
    void      AddButton(string name,int xsize,int ysize,color bgcol,
                        int fsize,string font,color col,int x,int y,
                        string text="",int state=0);
    void      AddEdit(string name,int xsize,int ysize,color bgcol,int fsize,
                      string font,color col,int x,int y,string text="");
    void      AddTrendLine(string name,color col,int style=0,int width=1);
    void      AddArrowline(string name,color col,int style=0,int width=1);
    void      AddRectangle(string name,color col,int style=0,int width=1);
    void      MoveGrObject(string name,int x1,int y1,int x2,int y2);
    void      SetButtonProp(string name,bool state,color col);
    long      GetRowNumber(string name);
    void      LabelTxt(string name,string str);
    
  };
  
//--------------------------------------------------- Constructor AllGrObject --
AllGrObject::AllGrObject()
  {
  m_chart_id=ChartID();
  }
//---------------------------------------------------- Destructor AllGrObject --
AllGrObject::~AllGrObject()
  {
  ObjectsDeleteAll(m_chart_id);                   // Delete all graphical object
  m_chart_id=-1;  
  }
//-------------------------------------------------------- Add Label to chart --
void AllGrObject::AddLabel(string name,int fsize,string font,
                             color col,int x,int y,string text="")
  {
  ObjectCreate(m_chart_id,name,OBJ_LABEL,0,0,0);
  ObjectSetInteger(m_chart_id,name,OBJPROP_FONTSIZE,fsize);
  ObjectSetString(m_chart_id,name,OBJPROP_FONT,font);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  ObjectSetInteger(m_chart_id,name,OBJPROP_ANCHOR,ANCHOR_RIGHT_LOWER);
  ObjectSetInteger(m_chart_id,name,OBJPROP_CORNER,CORNER_RIGHT_LOWER);
  ObjectSetInteger(m_chart_id,name,OBJPROP_XDISTANCE,x);
  ObjectSetInteger(m_chart_id,name,OBJPROP_YDISTANCE,y);
  ObjectSetString(m_chart_id,name,OBJPROP_TEXT,text);
  }
//------------------------------------------------------- Add Button to chart --
void AllGrObject::AddButton(string name,int xsize,int ysize,color bgcol,
                            int fsize,string font,color col,int x,int y,
                            string text="",int state=0)
  {
  ObjectCreate(m_chart_id,name,OBJ_BUTTON,0,0,0);
  ObjectSetInteger(m_chart_id,name,OBJPROP_XSIZE,xsize);
  ObjectSetInteger(m_chart_id,name,OBJPROP_YSIZE,ysize);
  ObjectSetInteger(m_chart_id,name,OBJPROP_CORNER,CORNER_RIGHT_LOWER);
  ObjectSetInteger(m_chart_id,name,OBJPROP_BGCOLOR,bgcol);
  ObjectSetInteger(m_chart_id,name,OBJPROP_FONTSIZE,fsize);
  ObjectSetString(m_chart_id,name,OBJPROP_FONT,font);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  ObjectSetInteger(m_chart_id,name,OBJPROP_XDISTANCE,x);
  ObjectSetInteger(m_chart_id,name,OBJPROP_YDISTANCE,y);
  ObjectSetString(m_chart_id,name,OBJPROP_TEXT,text);
  ObjectSetInteger(m_chart_id,name,OBJPROP_STATE,state);
  }
//--------------------------------------------------------- Add Edit to chart --
void AllGrObject::AddEdit(string name,int xsize,int ysize,
                          color bgcol,int fsize,string font,
                          color col,int x,int y,string text="")
  {
  ObjectCreate(m_chart_id,name,OBJ_EDIT,0,0,0);
  ObjectSetInteger(m_chart_id,name,OBJPROP_XSIZE,xsize);
  ObjectSetInteger(m_chart_id,name,OBJPROP_YSIZE,ysize);
  ObjectSetInteger(m_chart_id,name,OBJPROP_CORNER,CORNER_RIGHT_LOWER);
  ObjectSetInteger(m_chart_id,name,OBJPROP_BGCOLOR,bgcol);
  ObjectSetInteger(m_chart_id,name,OBJPROP_FONTSIZE,fsize);
  ObjectSetString(m_chart_id,name,OBJPROP_FONT,font);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  ObjectSetInteger(m_chart_id,name,OBJPROP_XDISTANCE,x);
  ObjectSetInteger(m_chart_id,name,OBJPROP_YDISTANCE,y);
  ObjectSetString(m_chart_id,name,OBJPROP_TEXT,text);
  }
//---------------------------------------------------- Add TrendLine to chart --
void AllGrObject::AddTrendLine(string name,color col,int style=0,int width=1)
  {
  ObjectCreate(0,name,OBJ_TREND,0,0,0);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  ObjectSetInteger(m_chart_id,name,OBJPROP_STYLE,style);
  ObjectSetInteger(m_chart_id,name,OBJPROP_WIDTH,width);
  }
//------------------------------------------------- Add Arrowed Line to chart --
void AllGrObject::AddArrowline(string name,color col,int style=0,int width=1)
  {
  ObjectCreate(m_chart_id,name,OBJ_ARROWED_LINE,0,0,0);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  ObjectSetInteger(m_chart_id,name,OBJPROP_STYLE,style);
  ObjectSetInteger(m_chart_id,name,OBJPROP_WIDTH,width);
  }
//---------------------------------------------------- Add Rectangle to chart --
void AllGrObject::AddRectangle(string name,color col,int style=0,int width=1)
  {
  ObjectCreate(m_chart_id,name,OBJ_RECTANGLE,0,0,0);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  ObjectSetInteger(m_chart_id,name,OBJPROP_STYLE,style);
  ObjectSetInteger(m_chart_id,name,OBJPROP_WIDTH,width);
  }
//------------------------- Move TrendLine, Arrowed Line and Rectangle object --
void AllGrObject::MoveGrObject(string name,int x1,int y1,int x2,int y2)
  {
  datetime t1[1],t2[1];
  long typ;
  
  typ=ObjectGetInteger(m_chart_id,name,OBJPROP_TYPE);
  if(typ==OBJ_TREND||typ==OBJ_ARROWED_LINE||typ==OBJ_RECTANGLE)
    {
    CopyTime(_Symbol,_Period,x1,1,t1);
    CopyTime(_Symbol,_Period,x2,1,t2);
    ObjectSetInteger(m_chart_id,name,OBJPROP_TIME,0,t1[0]);
    ObjectSetDouble(m_chart_id,name,OBJPROP_PRICE,0,_Point*y1);
    ObjectSetInteger(m_chart_id,name,OBJPROP_TIME,1,t2[0]);
    ObjectSetDouble(m_chart_id,name,OBJPROP_PRICE,1,_Point*y2);
    }
  }
//--------------------------------------------- Change Button color and state --
void AllGrObject::SetButtonProp(string name,bool state,color col)
  {
  ObjectSetInteger(m_chart_id,name,OBJPROP_STATE,state);
  ObjectSetInteger(m_chart_id,name,OBJPROP_COLOR,col);
  }
//------------------------------------------------ Get row number for listing --
long AllGrObject::GetRowNumber(string name)
  {
  long p;
  p=StringToInteger(ObjectGetString(m_chart_id,name,OBJPROP_TEXT));
  ObjectSetString(m_chart_id,name,OBJPROP_TEXT,"");         // Clear input field
  return(p);
  }
//------------------------------------------------------------ Set Label text --
void AllGrObject::LabelTxt(string name,string str)
  {
  ObjectSetString(m_chart_id,name,OBJPROP_TEXT,str);
  }

//------------------------------------------------------------------------------
//--------------------------------------------------------------- FFT functin --
/*************************************************************************
  

     
,  n    .

     ,  
 ,    .

 :
    tnn  -     .     
            .        
             .
    a   -   array [0 .. nn-1] of Real
             .
    InverseFFT
        -    .
            True,  , False,  .
            
 :
    a   -      .       .
              . http://alglib.sources.ru/fft/
*************************************************************************/
void realfastfouriertransform(double& a[], int tnn, bool inversefft)
{
    double twr;
    double twi;
    double twpr;
    double twpi;
    double twtemp;
    double ttheta;
    int i;
    int i1;
    int i2;
    int i3;
    int i4;
    double c1;
    double c2;
    double h1r;
    double h1i;
    double h2r;
    double h2i;
    double wrs;
    double wis;
    int nn;
    int ii;
    int jj;
    int n;
    int mmax;
    int m;
    int j;
    int istep;
    int isign;
    double wtemp;
    double wr;
    double wpr;
    double wpi;
    double wi;
    double theta;
    double tempr;
    double tempi;

    if( tnn==1 )
    {
        return;
    }
    if( !inversefft )
    {
        ttheta = 2.0*M_PI/tnn;
        c1 = 0.5;
        c2 = -0.5;
    }
    else
    {
        ttheta = 2.0*M_PI/tnn;
        c1 = 0.5;
        c2 = 0.5;
        ttheta = -ttheta;
        twpr = -2.0*MathPow(MathSin(0.5*ttheta),2);
        twpi = MathSin(ttheta);
        twr = 1.0+twpr;
        twi = twpi;
        for(i = 2; i <= tnn/4+1; i++)
        {
            i1 = i+i-2;
            i2 = i1+1;
            i3 = tnn+1-i2;
            i4 = i3+1;
            wrs = twr;
            wis = twi;
            h1r = c1*(a[i1]+a[i3]);
            h1i = c1*(a[i2]-a[i4]);
            h2r = -c2*(a[i2]+a[i4]);
            h2i = c2*(a[i1]-a[i3]);
            a[i1] = h1r+wrs*h2r-wis*h2i;
            a[i2] = h1i+wrs*h2i+wis*h2r;
            a[i3] = h1r-wrs*h2r+wis*h2i;
            a[i4] = -h1i+wrs*h2i+wis*h2r;
            twtemp = twr;
            twr = twr*twpr-twi*twpi+twr;
            twi = twi*twpr+twtemp*twpi+twi;
        }
        h1r = a[0];
        a[0] = c1*(h1r+a[1]);
        a[1] = c1*(h1r-a[1]);
    }
    if( inversefft )
    {
        isign = -1;
    }
    else
    {
        isign = 1;
    }
    n = tnn;
    nn = tnn/2;
    j = 1;
    for(ii = 1; ii <= nn; ii++)
    {
        i = 2*ii-1;
        if( j>i )
        {
            tempr = a[j-1];
            tempi = a[j];
            a[j-1] = a[i-1];
            a[j] = a[i];
            a[i-1] = tempr;
            a[i] = tempi;
        }
        m = n/2;
        while(m>=2&&j>m)
        {
            j = j-m;
            m = m/2;
        }
        j = j+m;
    }
    mmax = 2;
    while(n>mmax)
    {
        istep = 2*mmax;
        theta = 2.0*M_PI/(isign*mmax);
        wpr = -2.0*MathPow(MathSin(0.5*theta),2);
        wpi = MathSin(theta);
        wr = 1.0;
        wi = 0.0;
        for(ii = 1; ii <= mmax/2; ii++)
        {
            m = 2*ii-1;
            for(jj = 0; jj <= (n-m)/istep; jj++)
            {
                i = m+jj*istep;
                j = i+mmax;
                tempr = wr*a[j-1]-wi*a[j];
                tempi = wr*a[j]+wi*a[j-1];
                a[j-1] = a[i-1]-tempr;
                a[j] = a[i]-tempi;
                a[i-1] = a[i-1]+tempr;
                a[i] = a[i]+tempi;
            }
            wtemp = wr;
            wr = wr*wpr-wi*wpi+wr;
            wi = wi*wpr+wtemp*wpi+wi;
        }
        mmax = istep;
    }
    if( inversefft )
    {
        for(i = 1; i <= 2*nn; i++)
        {
            a[i-1] = a[i-1]/nn;
        }
    }
    if( !inversefft )
    {
        twpr = -2.0*MathPow(MathSin(0.5*ttheta),2);
        twpi = MathSin(ttheta);
        twr = 1.0+twpr;
        twi = twpi;
        for(i = 2; i <= tnn/4+1; i++)
        {
            i1 = i+i-2;
            i2 = i1+1;
            i3 = tnn+1-i2;
            i4 = i3+1;
            wrs = twr;
            wis = twi;
            h1r = c1*(a[i1]+a[i3]);
            h1i = c1*(a[i2]-a[i4]);
            h2r = -c2*(a[i2]+a[i4]);
            h2i = c2*(a[i1]-a[i3]);
            a[i1] = h1r+wrs*h2r-wis*h2i;
            a[i2] = h1i+wrs*h2i+wis*h2r;
            a[i3] = h1r-wrs*h2r+wis*h2i;
            a[i4] = -h1i+wrs*h2i+wis*h2r;
            twtemp = twr;
            twr = twr*twpr-twi*twpi+twr;
            twi = twi*twpr+twtemp*twpi+twi;
        }
        h1r = a[0];
        a[0] = h1r+a[1];
        a[1] = h1r-a[1];
    }
    return;
}
/************************************************************************/





      
      
      
      
      
      
      