//+------------------------------------------------------------------+
//|                                                  C_SubWindow.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "C_TemplateChart.mqh"
//+------------------------------------------------------------------+
class C_SubWindow : public C_TemplateChart
{
	private	:
		int	m_IdSub,
				m_handleSub;
//+------------------------------------------------------------------+
	public	:
		C_SubWindow() : m_IdSub(-1), m_handleSub(INVALID_HANDLE) {}
//+------------------------------------------------------------------+
		~C_SubWindow()
			{
				Close();
			}	
//+------------------------------------------------------------------+
		bool Init(void)
			{
				if (m_handleSub != INVALID_HANDLE) return true;
				if ((m_handleSub = iCustom(NULL, 0, "::" + def_Resource)) == INVALID_HANDLE) return false;
				m_IdSub = (int) ChartGetInteger(Terminal.Get_ID(), CHART_WINDOWS_TOTAL);
				if (!ChartIndicatorAdd(Terminal.Get_ID(), m_IdSub, m_handleSub)) return false;
				
				return true;
			}
//+------------------------------------------------------------------+
		void Close(void)
			{
				ClearTemplateChart();
				if (m_handleSub == INVALID_HANDLE) return;
				IndicatorRelease(m_IdSub);
				ChartIndicatorDelete(Terminal.Get_ID(), m_IdSub, ChartIndicatorName(Terminal.Get_ID(), m_IdSub, 0));
				ChartRedraw();
				m_handleSub = INVALID_HANDLE;
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
