//+------------------------------------------------------------------+
//|                                                 HML_Minute15.mq4 |
//|                                Copyright  2010, Investors Haven |
//|                                    http://www.InvestorsHaven.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Investors Haven"
#property link      "http://www.InvestorsHaven.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 MediumTurquoise            // Sets the colors of the first
#property indicator_color2 MediumTurquoise            // 8 lines of the 24 line set
#property indicator_color3 MediumTurquoise
#property indicator_width1 3           // Sets the width of the lins in pixels
#property indicator_width2 3
#property indicator_width3 3


int BandsPeriod = 20;                        // sets an initial amount on the
//---- buffers                               // lines prior to displaying them
double M15High[];                          // Array buffer for M15s High
double M15Median[];                        // Array buffer for M15s median
double M15Low[];                           // Array buffer for M15s Low
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);         // Section draws the lines for each
   SetIndexBuffer(0,M15High);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,M15Median);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,M15Low);

   
   SetIndexDrawBegin(0,BandsPeriod);      // Sets the lines starting point
   SetIndexDrawBegin(1,BandsPeriod);
   SetIndexDrawBegin(2,BandsPeriod);
   
   SetIndexLabel(0,"M15 High");         // Label the lines for easy reading
   SetIndexLabel(1,"M15 Median");
   SetIndexLabel(2,"M15 Low");
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   if(Bars<=BandsPeriod) return(0);     // exit if we don't have enough bars
   
   int    i,counted_bars=IndicatorCounted();   // Init variables
   
   //---- initial zero
   if(counted_bars<1)                        // No bars have been counted
   {
      for(i=1;i<=BandsPeriod;i++)            // Loop through assigning
        {                                    // all lines to empty
            M15High[Bars-i]=EMPTY_VALUE;   // so lines are  clean
            M15Median[Bars-i]=EMPTY_VALUE; 
            M15Low[Bars-i]=EMPTY_VALUE;
        }
     }
     
   int limit=Bars-counted_bars;              // determine our limit
   if(counted_bars>0) limit++;               // Track our limit as we count
   for(i=0; i<limit; i++)                    // Now loop through and assign
   {                                         // price values to lines via buffers
      M15High[i]= iHigh(NULL,PERIOD_M15,0);// get high for M15
      M15Median[i]= (((iHigh(NULL,PERIOD_M15,0) - iLow(NULL,PERIOD_M15,0))/2) + iLow(NULL,PERIOD_M15,0));
      M15Low[i]= iLow(NULL,PERIOD_M15,0);  // get low for PERIOD_PERIOD_M15
  }

   
//----
   return(0);
  }
//+------------------------------------------------------------------+