//+------------------------------------------------------------------+
//|                                                    HML_Daily.mq4 |
//|                                Copyright  2010, Investors Haven |
//|                                    http://www.InvestorsHaven.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Investors Haven"
#property link      "http://www.InvestorsHaven.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 MediumTurquoise            // Sets the colors of the first
#property indicator_color2 MediumTurquoise            // 8 lines of the 24 line set
#property indicator_color3 MediumTurquoise
#property indicator_width1 3           // Sets the width of the lins in pixels
#property indicator_width2 3
#property indicator_width3 3


int BandsPeriod = 20;                        // sets an initial amount on the
//---- buffers                               // lines prior to displaying them
double DailyHigh[];                          // Array buffer for Dailys High
double DailyMedian[];                        // Array buffer for Dailys median
double DailyLow[];                           // Array buffer for Dailys Low
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);         // Section draws the lines for each
   SetIndexBuffer(0,DailyHigh);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,DailyMedian);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,DailyLow);

   
   SetIndexDrawBegin(0,BandsPeriod);      // Sets the lines starting point
   SetIndexDrawBegin(1,BandsPeriod);
   SetIndexDrawBegin(2,BandsPeriod);
   
   SetIndexLabel(0,"Daily High");         // Label the lines for easy reading
   SetIndexLabel(1,"Daily Median");
   SetIndexLabel(2,"Daily Low");
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   if(Bars<=BandsPeriod) return(0);     // exit if we don't have enough bars
   
   int    i,counted_bars=IndicatorCounted();   // Init variables
   
   //---- initial zero
   if(counted_bars<1)                        // No bars have been counted
   {
      for(i=1;i<=BandsPeriod;i++)            // Loop through assigning
        {                                    // all lines to empty
            DailyHigh[Bars-i]=EMPTY_VALUE;   // so lines are  clean
            DailyMedian[Bars-i]=EMPTY_VALUE; 
            DailyLow[Bars-i]=EMPTY_VALUE;
        }
     }
     
   int limit=Bars-counted_bars;              // determine our limit
   if(counted_bars>0) limit++;               // Track our limit as we count
   for(i=0; i<limit; i++)                    // Now loop through and assign
   {                                         // price values to lines via buffers
      DailyHigh[i]= iHigh(NULL,PERIOD_D1,0);// get high for Daily
      DailyMedian[i]= (((iHigh(NULL,PERIOD_D1,0) - iLow(NULL,PERIOD_D1,0))/2) + iLow(NULL,PERIOD_D1,0));
      DailyLow[i]= iLow(NULL,PERIOD_D1,0);  // get low for PERIOD_D1
  }

   
//----
   return(0);
  }
//+------------------------------------------------------------------+