//+------------------------------------------------------------------+
//|                                                      sMatrix.mq4 |
//|                                                                * |
//|                                                                * |
//+------------------------------------------------------------------+

#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"

#include <incMatrix.mqh>

CIntMatrix Mx;
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int OnStart()
  {

/*

      Solution of linear equations system

      3*x0  + 2*x1  - 5*x2  = -1
      2*x0  - 1*x1  + 3*x2  = 13
      1*x0  + 2*x1  - 1*x2  = 9
   
   */

   double k[]=
     {
      3,2,-5,
      2,-1,3,
      1,2,-1,
      3,3 // the last two elements are the size of matrix: number of rows and number of columns
     };
   double y[]=
     {
      -1,
      13,
      9,
      3,1 // size
     };

   switch(Mx.SystemCheck(k,y))
     {
      case -1:
         Alert("System has no solutions");
         return(0);
         break;
      case 0:
         Alert("System has one solution");
         break;
      case 1:
         Alert("System has multiple solutions");
         return(0);
         break;
     }

   double x[]; // array for results

   if(Mx.SystemKramer(k,y,x))
     {
      Mx.Alert2(x,8,"Solution using Cramer's rule");
     }
   else
     {
      Alert("No solution or multiple solutions (Cramer's rule)");
     }

   if(Mx.SystemInverse(k,y,x))
     {
      Mx.Alert2(x,8,"Solution using invertible matrix");
     }
   else
     {
      Alert("No solution or multiple solutions (invertible matrix)");
     }

   if(Mx.SystemGauss(k,y,x))
     {
      Mx.Alert2(x,8,"Solution using Gaussian elimination");
     }
   else
     {
      Alert("No solution or multiple solutions (Gaussian elimination)");
     }

   return(0);
  }
//+------------------------------------------------------------------+
