//+------------------------------------------------------------------+
//|                                                 Williams_Inds.mq4 |
//|                                                      Denis Orlov |
//|                                    http://denis-or-love.narod.ru |
/*
    .,    . 
   AO, AC,  MACD.
http://codebase.mql4.com/ru/6318

The moved panel with the indicators of B.Williams, for strategy Trading chaos. 
It shows a direction of indicators AO, AC, and MACD.
http://codebase.mql4.com/6319

 
http://denis-or-love.narod.ru

***
  :
http://codebase.mql4.com/ru/author/denis_orlov
***
  !

*/
//+------------------------------------------------------------------+
#property copyright "Denis Orlov"
#property link      "http://denis-or-love.narod.ru"

#property indicator_chart_window
#define Pref "B.Williams PanelS: "


extern string note1="Parameters of MACD:";
extern int FastEMA=12;
extern int SlowEMA=26;
extern int SignalSMA=9;
extern string note2="Coordinates:";
extern int X=20;
extern int Y=50;
extern int RowStep=12;
extern int ColStep=17;
extern int Corner=1; 
extern int FSize=10;
//extern int H=0;
extern string note3="Colors, two themes:";
extern color RectClr=Gray;
extern color TxtClr=White;
extern color UpClr=Lime;
extern color DnClr=Red;
extern bool White_Chart_Theme=True;
extern color RectClr1=Gray;
extern color TxtClr1=Maroon;
extern color UpClr1=Green;
extern color DnClr1=Red;


int TimeX;
double PriceY;

int codeAO, codeAC, codeMACD;
color ClrAO , ClrAC, ClrMACD ;

//bool Alert_=False;
//color Alert_Clr=Red;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
      
      if(White_Chart_Theme)
            {
                RectClr=RectClr1;
                TxtClr=TxtClr1;
                UpClr=UpClr1;
                DnClr=DnClr1;
            }
       
       DrawPanel();
      
      
//----

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Delete_My_Obj(Pref);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----

      if ( iAO( NULL , Period(), 1)< iAO( NULL , Period(), 0) ) 
         {codeAO=217; ClrAO=UpClr; } else
         {codeAO=218; ClrAO=DnClr;}
         
      if (iAC( NULL , Period(), 1)<iAC( NULL , Period(), 0)) 
         {codeAC=217; ClrAC=UpClr;} else
         {codeAC=218; ClrAC=DnClr;} /* */
       
      if( iMACD( NULL , Period(),  
            FastEMA, SlowEMA, SignalSMA, PRICE_CLOSE, MODE_MAIN, 1)< iMACD( NULL , Period(),  
            FastEMA, SlowEMA, SignalSMA, PRICE_CLOSE, MODE_MAIN, 0) ) 
          {codeMACD=217; ClrMACD=UpClr;} else
         {codeMACD=218; ClrMACD=DnClr;} 
         
          
     /* if(Alert_)
            {
               
               if(codeAO==217 && codeAC==217 && codeMACD==217)
                  {Alert(Symbol()+" "+PeriodToStr(Period())
                  +" : AO, AC and MACD are UP at "+TimeToStr(TimeCurrent(),TIME_MINUTES)); 
                  ObjectDelete(Pref+"Unidirection Alert"); }
               
               if(codeAO==218 && codeAC==218 && codeMACD==218)
                  {Alert(Symbol()+" "+PeriodToStr(Period())
                  +" : AO, AC and MACD are DOWN at "+TimeToStr(TimeCurrent(),TIME_MINUTES) ); 
                  ObjectDelete(Pref+"Unidirection Alert"); }
               
            }
          
      if(ObjectFind(Pref+"Unidirection Alert")<0)
            Alert_=!Alert_;
      if(Alert_)Alert_Clr=UpClr; else Alert_Clr=DnClr;*/ 
      
            
      DrawPanel();
//----
   return(0);
  }
//+------------------------------------------------------------------+
int DrawText( string name, datetime T, double P, string Text, int code=0, color Clr=Green,  int Fsize=10, int Win=0)
   { 
      if (name=="") name="Text_"+T;
      
      int Error=ObjectFind(name);//  
   if (Error!=Win)//    .   :(
    { 
      ObjectCreate(name, OBJ_TEXT, Win, T, P);
      }
      
      ObjectSet(name, OBJPROP_TIME1, T);
      ObjectSet(name, OBJPROP_PRICE1, P);
      if(code==0)
      ObjectSetText(name, Text ,Fsize,"Arial",Clr);
      else
      ObjectSetText(name, CharToStr(code), Fsize,"Wingdings",Clr);
   }
   
//--------------------------------------
void DrawPanel()
{     if(Y<0) Y=0;
      //if(Y>(WindowPriceMax()-WindowPriceMin())/Point-H)
      // Y=(WindowPriceMax()-WindowPriceMin())/Point-H;
      
     // TimeX=Time[WindowFirstVisibleBar()]+X*Period()*60; 
     // PriceY=WindowPriceMax()-Y*Point;
      
     // DrawRect( Pref+"Rect", TimeX, PriceY, TimeX+TimeW ,PriceY-PriceH, RectClr, 1, "");
      
     // DrawText( Pref+"Allow Hand Moving", TimeX+1*Period()*60, PriceY-1*Point, "", 73, HandClr );
      //DrawText( Pref+"Unidirection Alert", TimeX+1*Period()*60, PriceY-(1+StepS)*Point, "", 37, Alert_Clr );
      
     // DrawText( Pref+"AO", TimeX+4*Period()*60, PriceY-1*Point, "AO", 0,TxtClr );//0, 10, 0
    //  DrawText( Pref+"AC", TimeX+4*Period()*60, PriceY-(1+StepS)*Point, "AC", 0,TxtClr );
     // DrawText( Pref+"MACD", TimeX+3*Period()*60, PriceY-(1+2*StepS)*Point, "MACD", 0,TxtClr );
      
     // DrawText( Pref+"AO direction", TimeX+8*Period()*60, PriceY-1*Point, "", codeAO, ClrAO );
     // DrawText( Pref+"AC direction", TimeX+8*Period()*60, PriceY-(1+StepS)*Point, "", codeAC, ClrAC );
     // DrawText( Pref+"MACD direction", TimeX+8*Period()*60, PriceY-(1+2*StepS)*Point, "", codeMACD, ClrMACD );

     DrawLabels(Pref+"AO",  Corner, X, Y, "AO", 0,TxtClr, 0, FSize);
     DrawLabels(Pref+"AC",  Corner, X, Y+RowStep, "AC",0, TxtClr, 0, FSize);
     DrawLabels(Pref+"MACD",  Corner, X, Y+RowStep*2, "MACD", 0,TxtClr, 0, FSize);
     
     DrawLabels(Pref+"AO direction",  Corner, X-ColStep, Y, "", codeAO,ClrAO, 0, FSize);
     DrawLabels(Pref+"AC direction",  Corner, X-ColStep, Y+RowStep, "", codeAC, ClrAC, 0, FSize);
     DrawLabels(Pref+"MACD direction",  Corner, X-ColStep, Y+RowStep*2, "", codeMACD, ClrMACD, 0, FSize);
      
      
      
      
      

}

//---------------------------------
int DrawRect( string name, datetime T1, double P1,datetime T2, double P2,
                    color Clr=Green, int Width=1, string Text="", int Win=0)
   { 
      if (name=="") name="Text_"+T1;
      
      int Error=ObjectFind(name);//  
    if (Error!=Win)//    .   :(
    {  
      ObjectCreate(name, OBJ_RECTANGLE, Win,T1,P1,T2,P2);//  
    }
     
    ObjectSet(name, OBJPROP_TIME1 ,T1);
    ObjectSet(name, OBJPROP_PRICE1,P1);
    ObjectSet(name, OBJPROP_TIME2 ,T2);
    ObjectSet(name, OBJPROP_PRICE2,P2);
    ObjectSet(name,OBJPROP_BACK, false);
    ObjectSet(name,OBJPROP_STYLE,0);
    ObjectSet(name, OBJPROP_COLOR , Clr);
    ObjectSet(name, OBJPROP_WIDTH , Width);
    ObjectSetText(name,Text);
    
    }
///-----------------------
void Delete_My_Obj(string Prefix)
   {//Alert(ObjectsTotal());
   for(int k=ObjectsTotal()-1; k>=0; k--)  //     
     {
      string Obj_Name=ObjectName(k);   //   
      string Head=StringSubstr(Obj_Name,0,StringLen(Prefix));//   

      if (Head==Prefix)//  , ..
         {
         ObjectDelete(Obj_Name);
         //Alert(Head+";"+Prefix);
         }                
        
     }
   }
///=====================
string PeriodToStr(int Per)
   {
      switch(Per)                 //   ..     
      {                              // ..       
      case     1: return("M1"); break;//  1      
      case     5: return("M5"); break;//  5      
      case    15: return("M15"); break;//  15      
      case    30: return("M30"); break;//  30      
      case    60: return("H1"); break;//  H1      
      case   240: return("H4"); break;//  H4      
      case  1440: return("D1"); break;//  D1      
      case 10080: return("W1"); break;//  W1      
      case 43200: return("N"); break;//  N     
      }
 }
//==================================
/*int CalculeH()
   {
      switch(Period())                 //   ..     
      {                              // ..       
      case     1: return(15); break;//  1      
      case     5: return(15); break;//  5      
      case    15: return(30); break;//  15      
      case    30: return(45); break;//  30      
      case    60: return(60); break;//  H1      
      case   240: return(180); break;//  H4      
      case  1440: return(270); break;//  D1      
      case 10080: return(450); break;//  W1      
      case 43200: return(900); break;//  N     
      }   
    }*/
    
int DrawLabels(string name, int corn, int X, int Y, string Text, int code=0, color Clr=Green, int Win=0, int FSize=10)
   {
     int Error=ObjectFind(name);//  
   if (Error!=Win)//    .   :(
    {  
      ObjectCreate(name,OBJ_LABEL,Win, 0,0); //  
    }
     
     ObjectSet(name, OBJPROP_CORNER, corn);     //      
     ObjectSet(name, OBJPROP_XDISTANCE, X);  //     
     ObjectSet(name,OBJPROP_YDISTANCE,Y);//  Y   
     ObjectSetText(name,Text,FSize,"Arial",Clr);
          if(code==0)
      ObjectSetText(name, Text ,FSize,"Arial",Clr);
      else
      ObjectSetText(name, CharToStr(code), FSize,"Wingdings",Clr);
   } }