//+------------------------------------------------------------------+
//|                                                    _Open_BUY.mq4 |
//|                                           "  " |
//|                BUY    FreeMargin |
//|                                                                  |
//|                                      USD...  ...USD |
//|                               ( komposter  ) |
//|                                                                  |
//|                           Bookkeeper, 2006, yuzefovich@gmail.com |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""
#property show_inputs //       
//+------------------------------------------------------------------+
extern int    Interest   = 100;  //   FreeMargin  :
                                 // = 0   
                                 // = 100    
extern int    DistSL     = 35;   //   SL
extern int    DistTP     = 35;   //   TP
extern int    Slippage   = 5;    // 
extern bool   StopLoss   = true; //   
extern bool   TakeProfit = true; //   
//+------------------------------------------------------------------+
void start() 
{
int    ticket;
double SL=0,TP=0,Stake,StepDgts,Share,QQ=1.0;
double Step=MarketInfo(Symbol(),MODE_MINLOT);   
int    Dgts=MarketInfo(Symbol(),MODE_DIGITS);     
string FirstPart=StringSubstr(Symbol(), 0, 3 );   
string SecondPart=StringSubstr(Symbol(), 3, 3 );
   Share=0.01*Interest;
   if(SecondPart == "USD") QQ=Ask;
   else
   {
      if(FirstPart != "USD") 
         Alert("OpenBUY: Who is that - "+Symbol()+"? I do not know..."); // :)

   }
   if(AccountFreeMargin()<Step*1000*QQ)
   {
      Alert("Open_BUY: No maney...");
      return;
   }
   if(Share>1.0) Share=1.0; //     
   if(Share<0) Share=0;    // (???)
   if(Step<0.1) StepDgts=2;
   else
   {
      if(Step<1.0) StepDgts=1;
      else StepDgts=0;
   }
   Stake=NormalizeDouble(AccountFreeMargin()*Share/1000/QQ,StepDgts);
   if(AccountFreeMargin()<Stake*1000*QQ) //    
      Stake=NormalizeDouble(Stake-Step,StepDgts); //      
   //        ,
   //     
   if(Stake<Step) Stake=Step;
   if(StopLoss==true) SL=Bid-DistSL*Point;
   if(TakeProfit==true) TP=Ask+2*DistTP*Point;
   ticket=OrderSend(Symbol(),OP_BUY,Stake,Ask,Slippage,
                    NormalizeDouble(SL,Dgts),
                    NormalizeDouble(TP,Dgts),
                    "",0,0,CLR_NONE);
   if(ticket<=0) Alert("Error Open_SELL: ",GetLastError()); 
   return(0);
}
//+------------------------------------------------------------------+

