//+------------------------------------------------------------------+
//|                                                   mysqlerror.mq4 |
//|                                       Copyright  2008, HIDDEN  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, HIDDEN "

//+------------------------------------------------------------------+
//| Server Error Codes and Messages                                  |
//+------------------------------------------------------------------+
#define ER_HASHCHK			      			1000	//Message: hashchk
#define ER_NISAMCHK					      	1001	//Message: isamchk
#define ER_NO				          			1002	//Message: NO
#define ER_YES				         			1003	//Message: YES
#define ER_CANT_CREATE_FILE	           	1004	//Message: Can't create file '%s' (errno: %d)
#define ER_CANT_CREATE_TABLE        		1005	//Message: Can't create table '%s' (errno: %d)
#define ER_CANT_CREATE_DB	             	1006	//Message: Can't create database '%s' (errno: %d)
#define ER_DB_CREATE_EXISTS         		1007	//Message: Can't create database '%s'; database exists
#define ER_DB_DROP_EXISTS	             	1008	//Message: Can't drop database '%s'; database doesn't exist
#define ER_DB_DROP_DELETE	             	1009	//Message: Error dropping database (can't delete '%s', errno: %d)
#define ER_DB_DROP_RMDIR	              	1010	//Message: Error dropping database (can't rmdir '%s', errno: %d)
#define ER_CANT_DELETE_FILE		         1011	//Message: Error on delete of '%s' (errno: %d)
#define ER_CANT_FIND_SYSTEM_REC		      1012	//Message: Can't read record in system table
#define ER_CANT_GET_STAT		            1013	//Message: Can't get status of '%s' (errno: %d)
#define ER_CANT_GET_WD						   1014	//Message: Can't get working directory (errno: %d)
#define ER_CANT_LOCK					        	1015	//Message: Can't lock file (errno: %d)
#define ER_CANT_OPEN_FILE	             	1016	//Message: Can't open file: '%s' (errno: %d)
#define ER_FILE_NOT_FOUND	             	1017	//Message: Can't find file: '%s' (errno: %d)
#define ER_CANT_READ_DIR	              	1018	//Message: Can't read dir of '%s' (errno: %d)
#define ER_CANT_SET_WD			  	     		1019	//Message: Can't change dir to '%s' (errno: %d)
#define ER_CHECKREAD		        				1020	//Message: Record has changed since last read in table '%s'
#define ER_DISK_FULL			       			1021	//Message: Disk full (%s); waiting for someone to free some space...
#define ER_DUP_KEY				        		1022	//Message: Can't write; duplicate key in table '%s'
#define ER_ERROR_ON_CLOSE						1023	//Message: Error on close of '%s' (errno: %d)
#define ER_ERROR_ON_READ						1024	//Message: Error reading file '%s' (errno: %d)
#define ER_ERROR_ON_RENAME						1025	//Message: Error on rename of '%s' to '%s' (errno: %d)
#define ER_ERROR_ON_WRITE						1026	//Message: Error writing file '%s' (errno: %d)
#define ER_FILE_USED				      		1027	//Message: '%s' is locked against change
#define ER_FILSORT_ABORT						1028	//Message: Sort aborted
#define ER_FORM_NOT_FOUND						1029	//Message: View '%s' doesn't exist for '%s'
#define ER_GET_ERRNO				      		1030	//Message: Got error %d from storage engine
#define ER_ILLEGAL_HA				     		1031	//Message: Table storage engine for '%s' doesn't have this option
#define ER_KEY_NOT_FOUND						1032	//Message: Can't find record in '%s'
#define ER_NOT_FORM_FILE						1033	//Message: Incorrect information in file: '%s'
#define ER_NOT_KEYFILE				    		1034	//Message: Incorrect key file for table '%s'; try to repair it
#define ER_OLD_KEYFILE				    		1035	//Message: Old key file for table '%s'; repair it!
#define ER_OPEN_AS_READONLY					1036	//Message: Table '%s' is read only
#define ER_OUTOFMEMORY					   	1037	//Message: Out of memory; restart server and try again (needed %d bytes)
#define ER_OUT_OF_SORTMEMORY					1038	//Message: Out of sort memory; increase server sort buffer size
#define ER_UNEXPECTED_EOF						1039	//Message: Unexpected EOF found when reading file '%s' (errno: %d)
#define ER_CON_COUNT_ERROR						1040	//Message: Too many connections
#define ER_OUT_OF_RESOURCES					1041	//Message: Out of memory; check if mysqld or some other process uses all available memory; if not, you may have to use 'ulimit' to allow mysqld to use more memory or you can add more swap space
#define ER_BAD_HOST_ERROR						1042	//Message: Can't get hostname for your address
#define ER_HANDSHAKE_ERROR						1043	//Message: Bad handshake
#define ER_DBACCESS_DENIED_ERROR				1044	//Message: Access denied for user '%s'@'%s' to database '%s'
#define ER_ACCESS_DENIED_ERROR				1045	//Message: Access denied for user '%s'@'%s' (using password: %s)
#define ER_NO_DB_ERROR						   1046	//Message: No database selected
#define ER_UNKNOWN_COM_ERROR					1047	//Message: Unknown command
#define ER_BAD_NULL_ERROR						1048	//Message: Column '%s' cannot be null
#define ER_BAD_DB_ERROR				   		1049	//Message: Unknown database '%s'
#define ER_TABLE_EXISTS_ERROR					1050	//Message: Table '%s' already exists
#define ER_BAD_TABLE_ERROR						1051	//Message: Unknown table '%s'
#define ER_NON_UNIQ_ERROR						1052	//Message: Column '%s' in %s is ambiguous
#define ER_SERVER_SHUTDOWN						1053	//Message: Server shutdown in progress
#define ER_BAD_FIELD_ERROR						1054	//Message: Unknown column '%s' in '%s'
#define ER_WRONG_FIELD_WITH_GROUP			1055	//Message: '%s' isn't in GROUP BY
#define ER_WRONG_GROUP_FIELD			     	1056	//Message: Can't group on '%s'
#define ER_WRONG_SUM_SELECT					1057	//Message: Statement has sum functions and columns in same statement
#define ER_WRONG_VALUE_COUNT					1058	//Message: Column count doesn't match value count
#define ER_TOO_LONG_IDENT						1059	//Message: Identifier name '%s' is too long
#define ER_DUP_FIELDNAME						1060	//Message: Duplicate column name '%s'
#define ER_DUP_KEYNAME					   	1061	//Message: Duplicate key name '%s'
#define ER_DUP_ENTRY					        	1062	//Message: Duplicate entry '%s' for key %d
#define ER_WRONG_FIELD_SPEC					1063	//Message: Incorrect column specifier for column '%s'
#define ER_PARSE_ERROR					   	1064	//Message: %s near '%s' at line %d
#define ER_EMPTY_QUERY					   	1065	//Message: Query was empty
#define ER_NONUNIQ_TABLE						1066	//Message: Not unique table/alias: '%s'
#define ER_INVALID_DEFAULT						1067	//Message: Invalid default value for '%s'
#define ER_MULTIPLE_PRI_KEY					1068	//Message: Multiple primary key defined
#define ER_TOO_MANY_KEYS						1069	//Message: Too many keys specified; max %d keys allowed
#define ER_TOO_MANY_KEY_PARTS					1070	//Message: Too many key parts specified; max %d parts allowed
#define ER_TOO_LONG_KEY				   		1071	//Message: Specified key was too long; max key length is %d bytes
#define ER_KEY_COLUMN_DOES_NOT_EXITS		1072	//Message: Key column '%s' doesn't exist in table
#define ER_BLOB_USED_AS_KEY					1073	//Message: BLOB column '%s' can't be used in key specification with the used table type
#define ER_TOO_BIG_FIELDLENGTH				1074	//Message: Column length too big for column '%s' (max = %lu); use BLOB or TEXT instead
#define ER_WRONG_AUTO_KEY						1075	//Message: Incorrect table definition; there can be only one auto column and it must be defined as a key
#define ER_READY					         	1076	//Message: %s: ready for connections. Version: '%s' socket: '%s' port: %d
#define ER_NORMAL_SHUTDOWN						1077	//Message: %s: Normal shutdown
#define ER_GOT_SIGNAL					    	1078	//Message: %s: Got signal %d. Aborting!
#define ER_SHUTDOWN_COMPLETE					1079	//Message: %s: Shutdown complete
#define ER_FORCING_CLOSE						1080	//Message: %s: Forcing close of thread %ld user: '%s'
#define ER_IPSOCK_ERROR					     	1081	//Message: Can't create IP socket
#define ER_NO_SUCH_INDEX						1082	//Message: Table '%s' has no index like the one used in CREATE INDEX; recreate the table
#define ER_WRONG_FIELD_TERMINATORS			1083	//Message: Field separator argument is not what is expected; check the manual
#define ER_BLOBS_AND_NO_TERMINATED			1084	//Message: You can't use fixed rowlength with BLOBs; please use 'fields terminated by'
#define ER_TEXTFILE_NOT_READABLE			   1085	//Message: The file '%s' must be in the database directory or be readable by all
#define ER_FILE_EXISTS_ERROR					1086	//Message: File '%s' already exists
#define ER_LOAD_INFO				      		1087	//Message: Records: %ld Deleted: %ld Skipped: %ld Warnings: %ld
#define ER_ALTER_INFO					    	1088	//Message: Records: %ld Duplicates: %ld
#define ER_WRONG_SUB_KEY						1089	//Message: Incorrect sub part key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique sub keys
#define ER_CANT_REMOVE_ALL_FIELDS			1090	//Message: You can't delete all columns with ALTER TABLE; use DROP TABLE instead
#define ER_CANT_DROP_FIELD_OR_KEY			1091	//Message: Can't DROP '%s'; check that column/key exists
#define ER_INSERT_INFO				    		1092	//Message: Records: %ld Duplicates: %ld Warnings: %ld
#define ER_UPDATE_TABLE_USED					1093	//Message: You can't specify target table '%s' for update in FROM clause
#define ER_NO_SUCH_THREAD						1094	//Message: Unknown thread id: %lu
#define ER_KILL_DENIED_ERROR					1095	//Message: You are not owner of thread %lu
#define ER_NO_TABLES_USED						1096	//Message: No tables used
#define ER_TOO_BIG_SET					   	1097	//Message: Too many strings for column %s and SET
#define ER_NO_UNIQUE_LOGFILE				   1098	//Message: Can't generate a unique log-filename %s.(1-999)
#define ER_TABLE_NOT_LOCKED_FOR_WRITE		1099	//Message: Table '%s' was locked with a READ lock and can't be updated
#define ER_TABLE_NOT_LOCKED					1100	//Message: Table '%s' was not locked with LOCK TABLES
#define ER_BLOB_CANT_HAVE_DEFAULT			1101	//Message: BLOB/TEXT column '%s' can't have a default value
#define ER_WRONG_DB_NAME						1102	//Message: Incorrect database name '%s'
#define ER_WRONG_TABLE_NAME					1103	//Message: Incorrect table name '%s'
#define ER_TOO_BIG_SELECT						1104	//Message: The SELECT would examine more than MAX_JOIN_SIZE rows; check your WHERE and use SET SQL_BIG_SELECTS=1 or SET SQL_MAX_JOIN_SIZE=# if the SELECT is okay
#define ER_UNKNOWN_ERROR						1105	//Message: Unknown error
#define ER_UNKNOWN_PROCEDURE					1106	//Message: Unknown procedure '%s'
#define ER_WRONG_PARAMCOUNT_TO_PROCEDURE	1107	//Message: Incorrect parameter count to procedure '%s'
#define ER_WRONG_PARAMETERS_TO_PROCEDURE	1108	//Message: Incorrect parameters to procedure '%s'
#define ER_UNKNOWN_TABLE						1109	//Message: Unknown table '%s' in %s
#define ER_FIELD_SPECIFIED_TWICE				1110	//Message: Column '%s' specified twice
#define ER_INVALID_GROUP_FUNC_USE			1111	//Message: Invalid use of group function
#define ER_UNSUPPORTED_EXTENSION				1112	//Message: Table '%s' uses an extension that doesn't exist in this MySQL version
#define ER_TABLE_MUST_HAVE_COLUMNS			1113	//Message: A table must have at least 1 column
#define ER_RECORD_FILE_FULL				   1114	//Message: The table '%s' is full
#define ER_UNKNOWN_CHARACTER_SET				1115	//Message: Unknown character set: '%s'
#define ER_TOO_MANY_TABLES						1116	//Message: Too many tables; MySQL can only use %d tables in a join
#define ER_TOO_MANY_FIELDS						1117	//Message: Too many columns
#define ER_TOO_BIG_ROWSIZE						1118	//Message: Row size too large. The maximum row size for the used table type, not counting BLOBs, is %ld. You have to change some columns to TEXT or BLOBs
#define ER_STACK_OVERRUN						1119	//Message: Thread stack overrun: Used: %ld of a %ld stack. Use 'mysqld -O thread_stack=#' to specify a bigger stack if needed
#define ER_WRONG_OUTER_JOIN					1120	//Message: Cross dependency found in OUTER JOIN; examine your ON conditions
#define ER_NULL_COLUMN_IN_INDEX				1121	//Message: Column '%s' is used with UNIQUE or INDEX but is not defined as NOT NULL
#define ER_CANT_FIND_UDF						1122	//Message: Can't load function '%s'
#define ER_CANT_INITIALIZE_UDF				1123	//Message: Can't initialize function '%s'; %s
#define ER_UDF_NO_PATHS						   1124	//Message: No paths allowed for shared library
#define ER_UDF_EXISTS				     		1125	//Message: Function '%s' already exists
#define ER_CANT_OPEN_LIBRARY					1126	//Message: Can't open shared library '%s' (errno: %d %s)
#define ER_CANT_FIND_DL_ENTRY					1127	//Message: Can't find function '%s' in library
#define ER_FUNCTION_NOT_DEFINED				1128	//Message: Function '%s' is not defined
#define ER_HOST_IS_BLOCKED						1129	//Message: Host '%s' is blocked because of many connection errors; unblock with 'mysqladmin flush-hosts'
#define ER_HOST_NOT_PRIVILEGED				1130	//Message: Host '%s' is not allowed to connect to this MySQL server
#define ER_PASSWORD_ANONYMOUS_USER			1131	//Message: You are using MySQL as an anonymous user and anonymous users are not allowed to change passwords
#define ER_PASSWORD_NOT_ALLOWED				1132	//Message: You must have privileges to update tables in the mysql database to be able to change passwords for others
#define ER_PASSWORD_NO_MATCH				   1133	//Message: Can't find any matching row in the user table
#define ER_UPDATE_INFO						   1134	//Message: Rows matched: %ld Changed: %ld Warnings: %ld
#define ER_CANT_CREATE_THREAD				   1135	//Message: Can't create a new thread (errno %d); if you are not out of available memory, you can consult the manual for a possible OS-dependent bug
#define ER_WRONG_VALUE_COUNT_ON_ROW			1136	//Message: Column count doesn't match value count at row %ld
#define ER_CANT_REOPEN_TABLE					1137	//Message: Can't reopen table: '%s'
#define ER_INVALID_USE_OF_NULL				1138	//Message: Invalid use of NULL value
#define ER_REGEXP_ERROR						   1139	//Message: Got error '%s' from regexp
#define ER_MIX_OF_GROUP_FUNC_AND_FIELDS	1140	//Message: Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause
#define ER_NONEXISTING_GRANT					1141	//Message: There is no such grant defined for user '%s' on host '%s'
#define ER_TABLEACCESS_DENIED_ERROR		   1142	//Message: %s command denied to user '%s'@'%s' for table '%s'
#define ER_COLUMNACCESS_DENIED_ERROR		1143	//Message: %s command denied to user '%s'@'%s' for column '%s' in table '%s'
#define ER_ILLEGAL_GRANT_FOR_TABLE			1144	//Message: Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used
#define ER_GRANT_WRONG_HOST_OR_USER			1145	//Message: The host or user argument to GRANT is too long
#define ER_NO_SUCH_TABLE						1146	//Message: Table '%s.%s' doesn't exist
#define ER_NONEXISTING_TABLE_GRANT			1147	//Message: There is no such grant defined for user '%s' on host '%s' on table '%s'
#define ER_NOT_ALLOWED_COMMAND				1148	//Message: The used command is not allowed with this MySQL version
#define ER_SYNTAX_ERROR					     	1149	//Message: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use
#define ER_DELAYED_CANT_CHANGE_LOCK			1150	//Message: Delayed insert thread couldn't get requested lock for table %s
#define ER_TOO_MANY_DELAYED_THREADS			1151	//Message: Too many delayed threads in use
#define ER_ABORTING_CONNECTION				1152	//Message: Aborted connection %ld to db: '%s' user: '%s' (%s)
#define ER_NET_PACKET_TOO_LARGE				1153	//Message: Got a packet bigger than 'max_allowed_packet' bytes
#define ER_NET_READ_ERROR_FROM_PIPE			1154	//Message: Got a read error from the connection pipe
#define ER_NET_FCNTL_ERROR						1155	//Message: Got an error from fcntl()
#define ER_NET_PACKETS_OUT_OF_ORDER			1156	//Message: Got packets out of order
#define ER_NET_UNCOMPRESS_ERROR			   1157	//Message: Couldn't uncompress communication packet
#define ER_NET_READ_ERROR						1158	//Message: Got an error reading communication packets
#define ER_NET_READ_INTERRUPTED				1159	//Message: Got timeout reading communication packets
#define ER_NET_ERROR_ON_WRITE					1160	//Message: Got an error writing communication packets
#define ER_NET_WRITE_INTERRUPTED				1161	//Message: Got timeout writing communication packets
#define ER_TOO_LONG_STRING						1162	//Message: Result string is longer than 'max_allowed_packet' bytes
#define ER_TABLE_CANT_HANDLE_BLOB			1163	//Message: The used table type doesn't support BLOB/TEXT columns
#define ER_TABLE_CANT_HANDLE_AUTO_INCREMENT  1164	//Message: The used table type doesn't support AUTO_INCREMENT columns
#define ER_DELAYED_INSERT_TABLE_LOCKED		1165	//Message: INSERT DELAYED can't be used with table '%s' because it is locked with LOCK TABLES
#define ER_WRONG_COLUMN_NAME					1166	//Message: Incorrect column name '%s'
#define ER_WRONG_KEY_COLUMN					1167	//Message: The used storage engine can't index column '%s'
#define ER_WRONG_MRG_TABLE						1168	//Message: Unable to open underlying table which is differently defined or of non-MyISAM type or doesn't exist
#define ER_DUP_UNIQUE						   1169	//Message: Can't write, because of unique constraint, to table '%s'
#define ER_BLOB_KEY_WITHOUT_LENGTH			1170	//Message: BLOB/TEXT column '%s' used in key specification without a key length
#define ER_PRIMARY_CANT_HAVE_NULL			1171	//Message: All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead
#define ER_TOO_MANY_ROWS						1172	//Message: Result consisted of more than one row
#define ER_REQUIRES_PRIMARY_KEY				1173	//Message: This table type requires a primary key
#define ER_NO_RAID_COMPILED					1174	//Message: This version of MySQL is not compiled with RAID support
#define ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE   1175	//Message: You are using safe update mode and you tried to update a table without a WHERE that uses a KEY column
#define ER_KEY_DOES_NOT_EXITS					1176	//Message: Key '%s' doesn't exist in table '%s'
#define ER_CHECK_NO_SUCH_TABLE				1177	//Message: Can't open table
#define ER_CHECK_NOT_IMPLEMENTED				1178	//Message: The storage engine for the table doesn't support %s
#define ER_CANT_DO_THIS_DURING_AN_TRANSACTION   1179	//Message: You are not allowed to execute this command in a transaction
#define ER_ERROR_DURING_COMMIT						1180	//Message: Got error %d during COMMIT
#define ER_ERROR_DURING_ROLLBACK						1181	//Message: Got error %d during ROLLBACK
#define ER_ERROR_DURING_FLUSH_LOGS					1182	//Message: Got error %d during FLUSH_LOGS
#define ER_ERROR_DURING_CHECKPOINT					1183	//Message: Got error %d during CHECKPOINT
#define ER_NEW_ABORTING_CONNECTION					1184	//Message: Aborted connection %ld to db: '%s' user: '%s' host: '%s' (%s)
#define ER_DUMP_NOT_IMPLEMENTED						1185	//Message: The storage engine for the table does not support binary table dump
#define ER_FLUSH_MASTER_BINLOG_CLOSED				1186	//Message: Binlog closed, cannot RESET MASTER
#define ER_INDEX_REBUILD						      1187	//Message: Failed rebuilding the index of dumped table '%s'
#define ER_MASTER						               1188	//Message: Error from master: '%s'
#define ER_MASTER_NET_READ						      1189	//Message: Net error reading from master
#define ER_MASTER_NET_WRITE						   1190	//Message: Net error writing to master
#define ER_FT_MATCHING_KEY_NOT_FOUND				1191	//Message: Can't find FULLTEXT index matching the column list
#define ER_LOCK_OR_ACTIVE_TRANSACTION				1192	//Message: Can't execute the given command because you have active locked tables or an active transaction
#define ER_UNKNOWN_SYSTEM_VARIABLE					1193	//Message: Unknown system variable '%s'
#define ER_CRASHED_ON_USAGE						   1194	//Message: Table '%s' is marked as crashed and should be repaired
#define ER_CRASHED_ON_REPAIR						   1195	//Message: Table '%s' is marked as crashed and last (automatic?) repair failed
#define ER_WARNING_NOT_COMPLETE_ROLLBACK			1196	//Message: Some non-transactional changed tables couldn't be rolled back
#define ER_TRANS_CACHE_FULL						   1197	//Message: Multi-statement transaction required more than 'max_binlog_cache_size' bytes of storage; increase this mysqld variable and try again
#define ER_SLAVE_MUST_STOP						      1198	//Message: This operation cannot be performed with a running slave; run STOP SLAVE first
#define ER_SLAVE_NOT_RUNNING						   1199	//Message: This operation requires a running slave; configure slave and do START SLAVE
#define ER_BAD_SLAVE						            1200	//Message: The server is not configured as slave; fix in config file or with CHANGE MASTER TO
#define ER_MASTER_INFO						         1201	//Message: Could not initialize master info structure; more error messages can be found in the MySQL error log
#define ER_SLAVE_THREAD						         1202	//Message: Could not create slave thread; check system resources
#define ER_TOO_MANY_USER_CONNECTIONS				1203	//Message: User %s already has more than 'max_user_connections' active connections
#define ER_SET_CONSTANTS_ONLY						   1204	//Message: You may only use constant expressions with SET
#define ER_LOCK_WAIT_TIMEOUT						   1205	//Message: Lock wait timeout exceeded; try restarting transaction
#define ER_LOCK_TABLE_FULL						      1206	//Message: The total number of locks exceeds the lock table size
#define ER_READ_ONLY_TRANSACTION						1207	//Message: Update locks cannot be acquired during a READ UNCOMMITTED transaction
#define ER_DROP_DB_WITH_READ_LOCK					1208	//Message: DROP DATABASE not allowed while thread is holding global read lock
#define ER_CREATE_DB_WITH_READ_LOCK					1209	//Message: CREATE DATABASE not allowed while thread is holding global read lock
#define ER_WRONG_ARGUMENTS						      1210	//Message: Incorrect arguments to %s
#define ER_NO_PERMISSION_TO_CREATE_USER			1211	//Message: '%s'@'%s' is not allowed to create new users
#define ER_UNION_TABLES_IN_DIFFERENT_DIR			1212	//Message: Incorrect table definition; all MERGE tables must be in the same database
#define ER_LOCK_DEADLOCK						      1213	//Message: Deadlock found when trying to get lock; try restarting transaction
#define ER_TABLE_CANT_HANDLE_FT						1214	//Message: The used table type doesn't support FULLTEXT indexes
#define ER_CANNOT_ADD_FOREIGN						   1215	//Message: Cannot add foreign key constraint
#define ER_NO_REFERENCED_ROW						   1216	//Message: Cannot add or update a child row: a foreign key constraint fails
#define ER_ROW_IS_REFERENCED						   1217	//Message: Cannot delete or update a parent row: a foreign key constraint fails
#define ER_CONNECT_TO_MASTER						   1218	//Message: Error connecting to master: %s
#define ER_QUERY_ON_MASTER						      1219	//Message: Error running query on master: %s
#define ER_ERROR_WHEN_EXECUTING_COMMAND			1220	//Message: Error when executing command %s: %s
#define ER_WRONG_USAGE						         1221	//Message: Incorrect usage of %s and %s
#define ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT		1222	//Message: The used SELECT statements have a different number of columns
#define ER_CANT_UPDATE_WITH_READLOCK				1223	//Message: Can't execute the query because you have a conflicting read lock
#define ER_MIXING_NOT_ALLOWED						   1224	//Message: Mixing of transactional and non-transactional tables is disabled
#define ER_DUP_ARGUMENT						         1225	//Message: Option '%s' used twice in statement
#define ER_USER_LIMIT_REACHED						   1226	//Message: User '%s' has exceeded the '%s' resource (current value: %ld)
#define ER_SPECIFIC_ACCESS_DENIED_ERROR			1227	//Message: Access denied; you need the %s privilege for this operation
#define ER_LOCAL_VARIABLE						      1228	//Message: Variable '%s' is a SESSION variable and can't be used with SET GLOBAL
#define ER_GLOBAL_VARIABLE						      1229	//Message: Variable '%s' is a GLOBAL variable and should be set with SET GLOBAL
#define ER_NO_DEFAULT						         1230	//Message: Variable '%s' doesn't have a default value
#define ER_WRONG_VALUE_FOR_VAR						1231	//Message: Variable '%s' can't be set to the value of '%s'
#define ER_WRONG_TYPE_FOR_VAR						   1232	//Message: Incorrect argument type to variable '%s'
#define ER_VAR_CANT_BE_READ						   1233	//Message: Variable '%s' can only be set, not read
#define ER_CANT_USE_OPTION_HERE						1234	//Message: Incorrect usage/placement of '%s'
#define ER_NOT_SUPPORTED_YET						   1235	//Message: This version of MySQL doesn't yet support '%s'
#define ER_MASTER_FATAL_ERROR_READING_BINLOG		1236	//Message: Got fatal error %d: '%s' from master when reading data from binary log
#define ER_SLAVE_IGNORED_TABLE						1237	//Message: Slave SQL thread ignored the query because of replicate-*-table rules
#define ER_INCORRECT_GLOBAL_LOCAL_VAR				1238	//Message: Variable '%s' is a %s variable
#define ER_WRONG_FK_DEF						         1239	//Message: Incorrect foreign key definition for '%s': %s
#define ER_KEY_REF_DO_NOT_MATCH_TABLE_REF			1240	//Message: Key reference and table reference don't match
#define ER_OPERAND_COLUMNS						      1241	//Message: Operand should contain %d column(s)
#define ER_SUBQUERY_NO_1_ROW						   1242	//Message: Subquery returns more than 1 row
#define ER_UNKNOWN_STMT_HANDLER						1243	//Message: Unknown prepared statement handler (%.*s) given to %s
#define ER_CORRUPT_HELP_DB						      1244	//Message: Help database is corrupt or does not exist
#define ER_CYCLIC_REFERENCE						   1245	//Message: Cyclic reference on subqueries
#define ER_AUTO_CONVERT						         1246	//Message: Converting column '%s' from %s to %s
#define ER_ILLEGAL_REFERENCE						   1247	//Message: Reference '%s' not supported (%s)
#define ER_DERIVED_MUST_HAVE_ALIAS					1248	//Message: Every derived table must have its own alias
#define ER_SELECT_REDUCED						      1249	//Message: Select %u was reduced during optimization
#define ER_TABLENAME_NOT_ALLOWED_HERE				1250	//Message: Table '%s' from one of the SELECTs cannot be used in %s
#define ER_NOT_SUPPORTED_AUTH_MODE					1251	//Message: Client does not support authentication protocol requested by server; consider upgrading MySQL client
#define ER_SPATIAL_CANT_HAVE_NULL					1252	//Message: All parts of a SPATIAL index must be NOT NULL
#define ER_COLLATION_CHARSET_MISMATCH				1253	//Message: COLLATION '%s' is not valid for CHARACTER SET '%s'
#define ER_SLAVE_WAS_RUNNING						   1254	//Message: Slave is already running
#define ER_SLAVE_WAS_NOT_RUNNING						1255	//Message: Slave already has been stopped
#define ER_TOO_BIG_FOR_UNCOMPRESS					1256	//Message: Uncompressed data size too large; the maximum size is %d (probably, length of uncompressed data was corrupted)
#define ER_ZLIB_Z_MEM_ERROR						   1257	//Message: ZLIB: Not enough memory
#define ER_ZLIB_Z_BUF_ERROR						   1258	//Message: ZLIB: Not enough room in the output buffer (probably, length of uncompressed data was corrupted)
#define ER_ZLIB_Z_DATA_ERROR						   1259	//Message: ZLIB: Input data corrupted
#define ER_CUT_VALUE_GROUP_CONCAT					1260	//Message: %d line(s) were cut by GROUP_CONCAT()
#define ER_WARN_TOO_FEW_RECORDS						1261	//Message: Row %ld doesn't contain data for all columns
#define ER_WARN_TOO_MANY_RECORDS						1262	//Message: Row %ld was truncated; it contained more data than there were input columns
#define ER_WARN_NULL_TO_NOTNULL						1263	//Message: Column was set to data type implicit default; NULL supplied for NOT NULL column '%s' at row %ld
#define ER_WARN_DATA_OUT_OF_RANGE					1264	//Message: Out of range value adjusted for column '%s' at row %ld
#define WARN_DATA_TRUNCATED						   1265	//Message: Data truncated for column '%s' at row %ld
#define ER_WARN_USING_OTHER_HANDLER					1266	//Message: Using storage engine %s for table '%s'
#define ER_CANT_AGGREGATE_2COLLATIONS				1267	//Message: Illegal mix of collations (%s,%s) and (%s,%s) for operation '%s'
#define ER_DROP_USER						            1268	//Message: Cannot drop one or more of the requested users
#define ER_REVOKE_GRANTS						      1269	//Message: Can't revoke all privileges for one or more of the requested users
#define ER_CANT_AGGREGATE_3COLLATIONS				1270	//Message: Illegal mix of collations (%s,%s), (%s,%s), (%s,%s) for operation '%s'
#define ER_CANT_AGGREGATE_NCOLLATIONS				1271	//Message: Illegal mix of collations for operation '%s'
#define ER_VARIABLE_IS_NOT_STRUCT					1272	//Message: Variable '%s' is not a variable component (can't be used as XXXX.variable_name)
#define ER_UNKNOWN_COLLATION						   1273	//Message: Unknown collation: '%s'
#define ER_SLAVE_IGNORED_SSL_PARAMS					1274	//Message: SSL parameters in CHANGE MASTER are ignored because this MySQL slave was compiled without SSL support; they can be used later if MySQL slave with SSL is started
#define ER_SERVER_IS_IN_SECURE_AUTH_MODE			1275	//Message: Server is running in --secure-auth mode, but '%s'@'%s' has a password in the old format; please change the password to the new format
#define ER_WARN_FIELD_RESOLVED						1276	//Message: Field or reference '%s%s%s%s%s' of SELECT #%d was resolved in SELECT #%d
#define ER_BAD_SLAVE_UNTIL_COND						1277	//Message: Incorrect parameter or combination of parameters for START SLAVE UNTIL
#define ER_MISSING_SKIP_SLAVE						   1278	//Message: It is recommended to use --skip-slave-start when doing step-by-step replication with START SLAVE UNTIL; otherwise, you will get problems if you get an unexpected slave's mysqld restart
#define ER_UNTIL_COND_IGNORED						   1279	//Message: SQL thread is not to be started so UNTIL options are ignored
#define ER_WRONG_NAME_FOR_INDEX						1280	//Message: Incorrect index name '%s'
#define ER_WRONG_NAME_FOR_CATALOG					1281	//Message: Incorrect catalog name '%s'
#define ER_WARN_QC_RESIZE						      1282	//Message: Query cache failed to set size %lu; new query cache size is %lu
#define ER_BAD_FT_COLUMN						      1283	//Message: Column '%s' cannot be part of FULLTEXT index
#define ER_UNKNOWN_KEY_CACHE						   1284	//Message: Unknown key cache '%s'
#define ER_WARN_HOSTNAME_WONT_WORK					1285	//Message: MySQL is started in --skip-name-resolve mode; you must restart it without this switch for this grant to work
#define ER_UNKNOWN_STORAGE_ENGINE					1286	//Message: Unknown table engine '%s'
#define ER_WARN_DEPRECATED_SYNTAX					1287	//Message: '%s' is deprecated; use '%s' instead
#define ER_NON_UPDATABLE_TABLE						1288	//Message: The target table %s of the %s is not updatable
#define ER_FEATURE_DISABLED						   1289	//Message: The '%s' feature is disabled; you need MySQL built with '%s' to have it working
#define ER_OPTION_PREVENTS_STATEMENT				1290	//Message: The MySQL server is running with the %s option so it cannot execute this statement
#define ER_DUPLICATED_VALUE_IN_TYPE					1291	//Message: Column '%s' has duplicated value '%s' in %s
#define ER_TRUNCATED_WRONG_VALUE						1292	//Message: Truncated incorrect %s value: '%s'
#define ER_TOO_MUCH_AUTO_TIMESTAMP_COLS			1293	//Message: Incorrect table definition; there can be only one TIMESTAMP column with CURRENT_TIMESTAMP in DEFAULT or ON UPDATE clause
#define ER_INVALID_ON_UPDATE						   1294	//Message: Invalid ON UPDATE clause for '%s' column
#define ER_UNSUPPORTED_PS						      1295	//Message: This command is not supported in the prepared statement protocol yet
#define ER_GET_ERRMSG						         1296	//Message: Got error %d '%s' from %s
#define ER_GET_TEMPORARY_ERRMSG						1297	//Message: Got temporary error %d '%s' from %s
#define ER_UNKNOWN_TIME_ZONE						   1298	//Message: Unknown or incorrect time zone: '%s'
#define ER_WARN_INVALID_TIMESTAMP					1299	//Message: Invalid TIMESTAMP value in column '%s' at row %ld
#define ER_INVALID_CHARACTER_STRING					1300	//Message: Invalid %s character string: '%s'
#define ER_WARN_ALLOWED_PACKET_OVERFLOWED			1301	//Message: Result of %s() was larger than max_allowed_packet (%ld) - truncated
#define ER_CONFLICTING_DECLARATIONS					1302	//Message: Conflicting declarations: '%s%s' and '%s%s'
#define ER_SP_NO_RECURSIVE_CREATE					1303	//Message: Can't create a %s from within another stored routine
#define ER_SP_ALREADY_EXISTS						   1304	//Message: %s %s already exists
#define ER_SP_DOES_NOT_EXIST						   1305	//Message: %s %s does not exist
#define ER_SP_DROP_FAILED						      1306	//Message: Failed to DROP %s %s
#define ER_SP_STORE_FAILED						      1307	//Message: Failed to CREATE %s %s
#define ER_SP_LILABEL_MISMATCH						1308	//Message: %s with no matching label: %s
#define ER_SP_LABEL_REDEFINE						   1309	//Message: Redefining label %s
#define ER_SP_LABEL_MISMATCH						   1310	//Message: End-label %s without match
#define ER_SP_UNINIT_VAR						      1311	//Message: Referring to uninitialized variable %s
#define ER_SP_BADSELECT						         1312	//Message: PROCEDURE %s can't return a result set in the given context
#define ER_SP_BADRETURN						         1313	//Message: RETURN is only allowed in a FUNCTION
#define ER_SP_BADSTATEMENT						      1314	//Message: %s is not allowed in stored procedures
#define ER_UPDATE_LOG_DEPRECATED_IGNORED			1315	//Message: The update log is deprecated and replaced by the binary log; SET SQL_LOG_UPDATE has been ignored
#define ER_UPDATE_LOG_DEPRECATED_TRANSLATED		1316	//Message: The update log is deprecated and replaced by the binary log; SET SQL_LOG_UPDATE has been translated to SET SQL_LOG_BIN
#define ER_QUERY_INTERRUPTED						   1317	//Message: Query execution was interrupted
#define ER_SP_WRONG_NO_OF_ARGS						1318	//Message: Incorrect number of arguments for %s %s; expected %u, got %u
#define ER_SP_COND_MISMATCH						   1319	//Message: Undefined CONDITION: %s
#define ER_SP_NORETURN						         1320	//Message: No RETURN found in FUNCTION %s
#define ER_SP_NORETURNEND						      1321	//Message: FUNCTION %s ended without RETURN
#define ER_SP_BAD_CURSOR_QUERY						1322	//Message: Cursor statement must be a SELECT
#define ER_SP_BAD_CURSOR_SELECT						1323	//Message: Cursor SELECT must not have INTO
#define ER_SP_CURSOR_MISMATCH						   1324	//Message: Undefined CURSOR: %s
#define ER_SP_CURSOR_ALREADY_OPEN					1325	//Message: Cursor is already open
#define ER_SP_CURSOR_NOT_OPEN						   1326	//Message: Cursor is not open
#define ER_SP_UNDECLARED_VAR						   1327	//Message: Undeclared variable: %s
#define ER_SP_WRONG_NO_OF_FETCH_ARGS				1328	//Message: Incorrect number of FETCH variables
#define ER_SP_FETCH_NO_DATA						   1329	//Message: No data - zero rows fetched, selected, or processed
#define ER_SP_DUP_PARAM						         1330	//Message: Duplicate parameter: %s
#define ER_SP_DUP_VAR						         1331	//Message: Duplicate variable: %s
#define ER_SP_DUP_COND						         1332	//Message: Duplicate condition: %s
#define ER_SP_DUP_CURS						         1333	//Message: Duplicate cursor: %s
#define ER_SP_CANT_ALTER						      1334	//Message: Failed to ALTER %s %s
#define ER_SP_SUBSELECT_NYI						   1335	//Message: Subselect value not supported
#define ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG			1336	//Message: %s is not allowed in stored function or trigger
#define ER_SP_VARCOND_AFTER_CURSHNDLR				1337	//Message: Variable or condition declaration after cursor or handler declaration
#define ER_SP_CURSOR_AFTER_HANDLER					1338	//Message: Cursor declaration after handler declaration
#define ER_SP_CASE_NOT_FOUND						   1339	//Message: Case not found for CASE statement
#define ER_FPARSER_TOO_BIG_FILE						1340	//Message: Configuration file '%s' is too big
#define ER_FPARSER_BAD_HEADER						   1341	//Message: Malformed file type header in file '%s'
#define ER_FPARSER_EOF_IN_COMMENT					1342	//Message: Unexpected end of file while parsing comment '%s'
#define ER_FPARSER_ERROR_IN_PARAMETER				1343	//Message: Error while parsing parameter '%s' (line: '%s')
#define ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER		1344	//Message: Unexpected end of file while skipping unknown parameter '%s'
#define ER_VIEW_NO_EXPLAIN						      1345	//Message: EXPLAIN/SHOW can not be issued; lacking privileges for underlying table
#define ER_FRM_UNKNOWN_TYPE						   1346	//Message: File '%s' has unknown type '%s' in its header
#define ER_WRONG_OBJECT						         1347	//Message: '%s.%s' is not %s
#define ER_NONUPDATEABLE_COLUMN						1348	//Message: Column '%s' is not updatable
#define ER_VIEW_SELECT_DERIVED						1349	//Message: View's SELECT contains a subquery in the FROM clause
#define ER_VIEW_SELECT_CLAUSE						   1350	//Message: View's SELECT contains a '%s' clause
#define ER_VIEW_SELECT_VARIABLE						1351	//Message: View's SELECT contains a variable or parameter
#define ER_VIEW_SELECT_TMPTABLE						1352	//Message: View's SELECT refers to a temporary table '%s'
#define ER_VIEW_WRONG_LIST						      1353	//Message: View's SELECT and view's field list have different column counts
#define ER_WARN_VIEW_MERGE						      1354	//Message: View merge algorithm can't be used here for now (assumed undefined algorithm)
#define ER_WARN_VIEW_WITHOUT_KEY						1355	//Message: View being updated does not have complete key of underlying table in it
#define ER_VIEW_INVALID						         1356	//Message: View '%s.%s' references invalid table(s) or column(s) or function(s) or definer/invoker of view lack rights to use them
#define ER_SP_NO_DROP_SP					       	1357	//Message: Can't drop or alter a %s from within another stored routine
#define ER_SP_GOTO_IN_HNDLR					    	1358	//Message: GOTO is not allowed in a stored procedure handler
#define ER_TRG_ALREADY_EXISTS					     	1359	//Message: Trigger already exists
#define ER_TRG_DOES_NOT_EXIST					     	1360	//Message: Trigger does not exist
#define ER_TRG_ON_VIEW_OR_TEMP_TABLE				1361	//Message: Trigger's '%s' is view or temporary table
#define ER_TRG_CANT_CHANGE_ROW						1362	//Message: Updating of %s row is not allowed in %strigger
#define ER_TRG_NO_SUCH_ROW_IN_TRG					1363	//Message: There is no %s row in %s trigger
#define ER_NO_DEFAULT_FOR_FIELD						1364	//Message: Field '%s' doesn't have a default value
#define ER_DIVISION_BY_ZERO					    	1365	//Message: Division by 0
#define ER_TRUNCATED_WRONG_VALUE_FOR_FIELD		1366	//Message: Incorrect %s value: '%s' for column '%s' at row %ld
#define ER_ILLEGAL_VALUE_FOR_TYPE					1367	//Message: Illegal %s '%s' value found during parsing
#define ER_VIEW_NONUPD_CHECK					   	1368	//Message: CHECK OPTION on non-updatable view '%s.%s'
#define ER_VIEW_CHECK_FAILED					   	1369	//Message: CHECK OPTION failed '%s.%s'
#define ER_PROCACCESS_DENIED_ERROR					1370	//Message: %s command denied to user '%s'@'%s' for routine '%s'
#define ER_RELAY_LOG_FAIL				       		1371	//Message: Failed purging old relay logs: %s
#define ER_PASSWD_LENGTH					       	1372	//Message: Password hash should be a %d-digit hexadecimal number
#define ER_UNKNOWN_TARGET_BINLOG				   	1373	//Message: Target log not found in binlog index
#define ER_IO_ERR_LOG_INDEX_READ						1374	//Message: I/O error reading log index file
#define ER_BINLOG_PURGE_PROHIBITED					1375	//Message: Server configuration does not permit binlog purge
#define ER_FSEEK_FAIL				           		1376	//Message: Failed on fseek()
#define ER_BINLOG_PURGE_FATAL_ERR					1377	//Message: Fatal error during log purge
#define ER_LOG_IN_USE					          	1378	//Message: A purgeable log is in use, will not purge
#define ER_LOG_PURGE_UNKNOWN_ERR						1379	//Message: Unknown error during log purge
#define ER_RELAY_LOG_INIT				       		1380	//Message: Failed initializing relay log position: %s
#define ER_NO_BINARY_LOGGING				    		1381	//Message: You are not using binary logging
#define ER_RESERVED_SYNTAX				      		1382	//Message: The '%s' syntax is reserved for purposes internal to the MySQL server
#define ER_WSAS_FAILED					         	1383	//Message: WSAStartup Failed
#define ER_DIFF_GROUPS_PROC					    	1384	//Message: Can't handle procedures with different groups yet
#define ER_NO_GROUP_FOR_PROC					   	1385	//Message: Select must have a group with this procedure
#define ER_ORDER_WITH_PROC					        	1386	//Message: Can't use ORDER clause with this procedure
#define ER_LOGGING_PROHIBIT_CHANGING_OF			1387	//Message: Binary logging and replication forbid changing the global server %s
#define ER_NO_FILE_MAPPING					        	1388	//Message: Can't map file: %s, errno: %d
#define ER_WRONG_MAGIC					         	1389	//Message: Wrong magic in %s
#define ER_PS_MANY_PARAM				        		1390	//Message: Prepared statement contains too many placeholders
#define ER_KEY_PART_0			         			1391	//Message: Key part '%s' length cannot be 0
#define ER_VIEW_CHECKSUM					       	1392	//Message: View text checksum failed
#define ER_VIEW_MULTIUPDATE				     		1393	//Message: Can not modify more than one base table through a join view '%s.%s'
#define ER_VIEW_NO_INSERT_FIELD_LIST				1394	//Message: Can not insert into join view '%s.%s' without fields list
#define ER_VIEW_DELETE_MERGE_VIEW			   	1395	//Message: Can not delete from join view '%s.%s'
#define ER_CANNOT_USER					         	1396	//Message: Operation %s failed for %s
#define ER_XAER_NOTA					              	1397	//Message: XAER_NOTA: Unknown XID
#define ER_XAER_INVAL				           		1398	//Message: XAER_INVAL: Invalid arguments (or unsupported command)
#define ER_XAER_RMFAIL				          		1399	//Message: XAER_RMFAIL: The command cannot be executed when global transaction is in the %s state
#define ER_XAER_OUTSIDE				         		1400	//Message: XAER_OUTSIDE: Some work is done outside global transaction
#define ER_XAER_RMERR				          		1401	//Message: XAER_RMERR: Fatal error occurred in the transaction branch - check your data for consistency
#define ER_XA_RBROLLBACK				        		1402	//Message: XA_RBROLLBACK: Transaction branch was rolled back
#define ER_NONEXISTING_PROC_GRANT					1403	//Message: There is no such grant defined for user '%s' on host '%s' on routine '%s'
#define ER_PROC_AUTO_GRANT_FAIL						1404	//Message: Failed to grant EXECUTE and ALTER ROUTINE privileges
#define ER_PROC_AUTO_REVOKE_FAIL						1405	//Message: Failed to revoke all privileges to dropped routine
#define ER_DATA_TOO_LONG				        		1406	//Message: Data too long for column '%s' at row %ld
#define ER_SP_BAD_SQLSTATE				      		1407	//Message: Bad SQLSTATE: '%s'
#define ER_STARTUP				              		1408	//Message: %s: ready for connections. Version: '%s' socket: '%s' port: %d %s
#define ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR		1409	//Message: Can't load value from file with fixed size rows to variable
#define ER_CANT_CREATE_USER_WITH_GRANT		     	1410	//Message: You are not allowed to create a user with GRANT
#define ER_WRONG_VALUE_FOR_TYPE						1411	//Message: Incorrect %s value: '%s' for function %s
#define ER_TABLE_DEF_CHANGED				    		1412	//Message: Table definition has changed, please retry transaction
#define ER_SP_DUP_HANDLER				       		1413	//Message: Duplicate handler declared in the same block
#define ER_SP_NOT_VAR_ARG				       		1414	//Message: OUT or INOUT argument %d for routine %s is not a variable or NEW pseudo-variable in BEFORE trigger
#define ER_SP_NO_RETSET					           	1415	//Message: Not allowed to return a result set from a %s
#define ER_CANT_CREATE_GEOMETRY_OBJECT				1416	//Message: Cannot get geometry object from data you send to the GEOMETRY field
#define ER_FAILED_ROUTINE_BREAK_BINLOG				1417	//Message: A routine failed and has neither NO SQL nor READS SQL DATA in its declaration and binary logging is enabled; if non-transactional tables were updated, the binary log will miss their changes
#define ER_BINLOG_UNSAFE_ROUTINE						1418	//Message: This function has none of DETERMINISTIC, NO SQL, or READS SQL DATA in its declaration and binary logging is enabled (you *might* want to use the less safe log_bin_trust_function_creators variable)
#define ER_BINLOG_CREATE_ROUTINE_NEED_SUPER		1419	//Message: You do not have the SUPER privilege and binary logging is enabled (you *might* want to use the less safe log_bin_trust_function_creators variable)
#define ER_EXEC_STMT_WITH_OPEN_CURSOR			   1420	//Message: You can't execute a prepared statement which has an open cursor associated with it. Reset the statement to re-execute it.
#define ER_STMT_HAS_NO_OPEN_CURSOR					1421	//Message: The statement (%lu) has no open cursor.
#define ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG		1422	//Message: Explicit or implicit commit is not allowed in stored function or trigger.
#define ER_NO_DEFAULT_FOR_VIEW_FIELD				1423	//Message: Field of view '%s.%s' underlying table doesn't have a default value
#define ER_SP_NO_RECURSION					        	1424	//Message: Recursive stored functions and triggers are not allowed.
#define ER_TOO_BIG_SCALE				        		1425	//Message: Too big scale %lu specified for column '%s'. Maximum is %d.
#define ER_TOO_BIG_PRECISION				    		1426	//Message: Too big precision %lu specified for column '%s'. Maximum is %lu.
#define ER_M_BIGGER_THAN_D					        	1427	//Message: For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%s').
#define ER_WRONG_LOCK_OF_SYSTEM_TABLE				1428	//Message: You can't combine write-locking of system '%s.%s' table with other tables
#define ER_CONNECT_TO_FOREIGN_DATA_SOURCE			1429	//Message: Unable to connect to foreign data source: %s
#define ER_QUERY_ON_FOREIGN_DATA_SOURCE			1430	//Message: There was a problem processing the query on the foreign data source. Data source %s
#define ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST		1431	//Message: The foreign data source you are trying to reference does not exist. Data source %s
#define ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE    1432	//Message: Can't create federated table. The data source connection string '%s' is not in the correct format
#define ER_FOREIGN_DATA_STRING_INVALID						1433	//Message: The data source connection string '%s' is not in the correct format
#define ER_CANT_CREATE_FEDERATED_TABLE						1434	//Message: Can't create federated table. Foreign data src %s
#define ER_TRG_IN_WRONG_SCHEMA					       	1435	//Message: Trigger in wrong schema
#define ER_STACK_OVERRUN_NEED_MORE				    		1436	//Message: Thread stack overrun: %ld bytes used of a %ld byte stack, and %ld bytes needed. Use 'mysqld -O thread_stack=#' to specify a bigger stack.
#define ER_TOO_LONG_BODY					             	1437	//Message: Routine body for '%s' is too long
#define ER_WARN_CANT_DROP_DEFAULT_KEYCACHE				1438	//Message: Cannot drop default keycache
#define ER_TOO_BIG_DISPLAYWIDTH					      	1439	//Message: Display width out of range for column '%s' (max = %lu)
#define ER_XAER_DUPID				                 		1440	//Message: XAER_DUPID: The XID already exists
#define ER_DATETIME_FUNCTION_OVERFLOW						1441	//Message: Datetime function: %s field overflow
#define ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG			1442	//Message: Can't update table '%s' in stored function/trigger because it is already used by statement which invoked this stored function/trigger.
#define ER_VIEW_PREVENT_UPDATE						      1443	//Message: The definition of table '%s' prevents operation %s on table '%s'.
#define ER_PS_NO_RECURSION			             			1444	//Message: The prepared statement contains a stored routine call that refers to that same statement. It's not allowed to execute a prepared statement in such a recursive manner
#define ER_SP_CANT_SET_AUTOCOMMIT			   			1445	//Message: Not allowed to set autocommit from a stored function or trigger
#define ER_MALFORMED_DEFINER					         	1446	//Message: Definer is not fully qualified
#define ER_VIEW_FRM_NO_USER				           		1447	//Message: View '%s'.'%s' has no definer information (old table format). Current user is used as definer. Please recreate the view!
#define ER_VIEW_OTHER_USER	            					1448	//Message: You need the SUPER privilege for creation view with '%s'@'%s' definer
#define ER_NO_SUCH_USER					                 	1449	//Message: There is no '%s'@'%s' registered
#define ER_FORBID_SCHEMA_CHANGE				       		1450	//Message: Changing schema from '%s' to '%s' is not allowed.
#define ER_ROW_IS_REFERENCED_2				        		1451	//Message: Cannot delete or update a parent row: a foreign key constraint fails (%s)
#define ER_NO_REFERENCED_ROW_2				        		1452	//Message: Cannot add or update a child row: a foreign key constraint fails (%s)
#define ER_SP_BAD_VAR_SHADOW				          		1453	//Message: Variable '%s' must be quoted with `...`, or renamed
#define ER_TRG_NO_DEFINER			              			1454	//Message: No definer attribute for trigger '%s'.'%s'. The trigger will be activated under the authorization of the invoker, which may have insufficient privileges. Please recreate the trigger.
#define ER_OLD_FILE_FORMAT			             			1455	//Message: '%s' has an old format, you should re-create the '%s' object(s)
#define ER_SP_RECURSION_LIMIT			          			1456	//Message: Recursive limit %d (as set by the max_sp_recursion_depth variable) was exceeded for routine %s
#define ER_SP_PROC_TABLE_CORRUPT				      		1457	//Message: Failed to load routine %s. The table mysql.proc is missing, corrupt, or contains bad data (internal code %d)
#define ER_SP_WRONG_NAME			            			1458	//Message: Incorrect routine name '%s'
#define ER_TABLE_NEEDS_UPGRADE					       	1459	//Message: Table upgrade required. Please do "REPAIR TABLE `%s`" to fix it!
#define ER_SP_NO_AGGREGATE					              	1460	//Message: AGGREGATE is not supported for stored functions
#define ER_MAX_PREPARED_STMT_COUNT_REACHED				1461	//Message: Can't create more than max_prepared_stmt_count statements (current value: %lu)
#define ER_VIEW_RECURSIVE			              			1462	//Message: `%s`.`%s` contains view recursion
#define ER_NON_GROUPING_FIELD_USED				    		1463	//Message: non-grouping field '%s' is used in %s clause
#define ER_TABLE_CANT_HANDLE_SPKEYS					     	1464	//Message: The used table type doesn't support SPATIAL indexes
#define ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA				  	1465	//Message: Triggers can not be created on system tables
#define ER_REMOVED_SPACES					            	1466	//Message: Leading spaces are removed from name '%s'
#define ER_AUTOINC_READ_FAILED			      			1467	//Message: Failed to read auto-increment value from storage engine
#define ER_USERNAME					                  	1468	//Message: user name
#define ER_HOSTNAME					                  	1469	//Message: host name
#define ER_WRONG_STRING_LENGTH					       	1470	//Message: String '%s' is too long for %s (should be no longer than %d)
#define ER_NON_INSERTABLE_TABLE				       		1471	//Message: The target table %s of the %s is not insertable-into
#define ER_ADMIN_WRONG_MRG_TABLE				      		1472	//Message: Table '%s' is differently defined or of non-MyISAM type or doesn't exist
#define ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT			1473	//Message: Too high level of nesting for select
#define ER_NAME_BECOMES_EMPTY					           	1474	//Message: Name '%s' has become ''
#define ER_AMBIGUOUS_FIELD_TERM					      	1475	//Message: First character of the FIELDS TERMINATED string is ambiguous; please use non-optional and non-empty FIELDS ENCLOSED BY
#define ER_LOAD_DATA_INVALID_COLUMN					     	1476	//Message: Invalid column reference (%s) in LOAD DATA
#define ER_LOG_PURGE_NO_FILE				          		1477	//Message: Being purged log %s was not found

//+------------------------------------------------------------------+
//| Client Error Codes and Messages                                  |
//+------------------------------------------------------------------+
#define CR_UNKNOWN_ERROR					             	2000	//Message: Unknown MySQL error
#define CR_SOCKET_CREATE_ERROR					       	2001	//Message: Can't create UNIX socket (%d)
#define CR_CONNECTION_ERROR					          	2002	//Message: Can't connect to local MySQL server through socket '%s' (%d)
#define CR_CONN_HOST_ERROR					              	2003	//Message: Can't connect to MySQL server on '%s' (%d)
#define CR_IPSOCK_ERROR					                 	2004	//Message: Can't create TCP/IP socket (%d)
#define CR_UNKNOWN_HOST					                 	2005	//Message: Unknown MySQL server host '%s' (%d)
#define CR_SERVER_GONE_ERROR				          		2006	//Message: MySQL server has gone away
#define CR_VERSION_ERROR					             	2007	//Message: Protocol mismatch; server version = %d, client version = %d
#define CR_OUT_OF_MEMORY					             	2008	//Message: MySQL client ran out of memory
#define CR_WRONG_HOST_INFO				            		2009	//Message: Wrong host info
#define CR_LOCALHOST_CONNECTION						      2010	//Message: Localhost via UNIX socket
#define CR_TCP_CONNECTION			              			2011	//Message: %s via TCP/IP
#define CR_SERVER_HANDSHAKE_ERR					      	2012	//Message: Error in server handshake
#define CR_SERVER_LOST			                 			2013	//Message: Lost connection to MySQL server during query
#define CR_COMMANDS_OUT_OF_SYNC				       		2014	//Message: Commands out of sync; you can't run this command now
#define CR_NAMEDPIPE_CONNECTION				       		2015	//Message: Named pipe: %s
#define CR_NAMEDPIPEWAIT_ERROR			      			2016	//Message: Can't wait for named pipe to host: %s pipe: %s (%lu)
#define CR_NAMEDPIPEOPEN_ERROR				        		2017	//Message: Can't open named pipe to host: %s pipe: %s (%lu)
#define CR_NAMEDPIPESETSTATE_ERROR				    		2018	//Message: Can't set state of named pipe to host: %s pipe: %s (%lu)
#define CR_CANT_READ_CHARSET				          		2019	//Message: Can't initialize character set %s (path: %s)
#define CR_NET_PACKET_TOO_LARGE			        			2020	//Message: Got packet bigger than 'max_allowed_packet' bytes
#define CR_EMBEDDED_CONNECTION				        		2021	//Message: Embedded server
#define CR_PROBE_SLAVE_STATUS			          			2022	//Message: Error on SHOW SLAVE STATUS:
#define CR_PROBE_SLAVE_HOSTS					         	2023	//Message: Error on SHOW SLAVE HOSTS:
#define CR_PROBE_SLAVE_CONNECT				        		2024	//Message: Error connecting to slave:
#define CR_PROBE_MASTER_CONNECT	       					2025	//Message: Error connecting to master:
#define CR_SSL_CONNECTION_ERROR			        			2026	//Message: SSL connection error
#define CR_MALFORMED_PACKET		          				2027	//Message: Malformed packet
#define CR_WRONG_LICENSE				              		2028	//Message: This client library is licensed only for use with MySQL servers having '%s' license
#define CR_NULL_POINTER				               		2029	//Message: Invalid use of null pointer
#define CR_NO_PREPARE_STMT			             			2030	//Message: Statement not prepared
#define CR_PARAMS_NOT_BOUND			         			2031	//Message: No data supplied for parameters in prepared statement
#define CR_DATA_TRUNCATED					            	2032	//Message: Data truncated
#define CR_NO_PARAMETERS_EXISTS				       		2033	//Message: No parameters exist in the statement
#define CR_INVALID_PARAMETER_NO			        			2034	//Message: Invalid parameter number
#define CR_INVALID_BUFFER_USE			          			2035	//Message: Can't send long data for non-string/non-binary data types (parameter: %d)
#define CR_UNSUPPORTED_PARAM_TYPE			   			2036	//Message: Using unsupported buffer type: %d (parameter: %d)
#define CR_SHARED_MEMORY_CONNECTION				   		2037	//Message: Shared memory: %s
#define CR_SHARED_MEMORY_CONNECT_REQUEST_ERROR	 		2038	//Message: Can't open shared memory; client could not create request event (%lu)
#define CR_SHARED_MEMORY_CONNECT_ANSWER_ERROR	     	2039	//Message: Can't open shared memory; no answer event received from server (%lu)
#define CR_SHARED_MEMORY_CONNECT_FILE_MAP_ERROR			2040	//Message: Can't open shared memory; server could not allocate file mapping (%lu)
#define CR_SHARED_MEMORY_CONNECT_MAP_ERROR				2041	//Message: Can't open shared memory; server could not get pointer to file mapping (%lu)
#define CR_SHARED_MEMORY_FILE_MAP_ERROR					2042	//Message: Can't open shared memory; client could not allocate file mapping (%lu)
#define CR_SHARED_MEMORY_MAP_ERROR						   2043	//Message: Can't open shared memory; client could not get pointer to file mapping (%lu)
#define CR_SHARED_MEMORY_EVENT_ERROR						2044	//Message: Can't open shared memory; client could not create %s event (%lu)
#define CR_SHARED_MEMORY_CONNECT_ABANDONED_ERROR		2045	//Message: Can't open shared memory; no answer from server (%lu)
#define CR_SHARED_MEMORY_CONNECT_SET_ERROR				2046	//Message: Can't open shared memory; cannot send request event to server (%lu)
#define CR_CONN_UNKNOW_PROTOCOL					      	2047	//Message: Wrong or unknown protocol
#define CR_INVALID_CONN_HANDLE					       	2048	//Message: Invalid connection handle
#define CR_SECURE_AUTH				                		2049	//Message: Connection using old (pre-4.1.1) authentication protocol refused (client option 'secure_auth' enabled)
#define CR_FETCH_CANCELED				             		2050	//Message: Row retrieval was canceled by mysql_stmt_close() call
#define CR_NO_DATA					                   	2051	//Message: Attempt to read column without prior row fetch
#define CR_NO_STMT_METADATA				           		2052	//Message: Prepared statement contains no metadata
#define CR_NO_RESULT_SET					             	2053	//Message: Attempt to read a row while there is no result set associated with the statement
#define CR_NOT_IMPLEMENTED			             			2054	//Message: This feature is not implemented yet
#define CR_SERVER_LOST_EXTENDED				       		2055	//Message: Lost connection to MySQL server at '%s', system %d

