//+------------------------------------------------------------------+
//|                       IDT_library.mq4                          |
//|                      Copyright  2007, Globus                    |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Globus"
#property library
#include <stdlib.mqh>
#include <WinUser32.mqh>
/*
int init()
  {
   Print("Init function defined as feature sample");
  }
int deinit()
  {
   Print("Deinit function defined as feature sample too");
  }
*/

//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|      cteni globalni promene typu double                             |
//+------------------------------------------------------------------+
double glob(string promena)
  {
   if(GlobalVariableCheck(promena))return(GlobalVariableGet(promena));
   else Print("Promena ",promena," neexistuje. Nutno spustit IDT_variables!");
   return(0);
  }
  
//+------------------------------------------------------------------+
//| script "intraday trading - buy limit"                            |
//+------------------------------------------------------------------+

int buy_limit(string text,int magic)
  {
 
  PlaySound("Tick.wav");
  RefreshRates();
  double PRICE=Ask-glob("skip");
  double LOTS=AccountBalance()* glob("maxrisk") *0.1 / glob("lost");
  double WITHIN=TimeCurrent()+glob("expiration")*60;  
  double sum=OrdersTotal();
  double change=0;
  
  Print ("Count of ticket ",sum);
 
  while (sum>0)
    {
    OrderSelect(sum-1,SELECT_BY_POS);
    Print (OrderTicket ());
    Print (OrderType ());
    
      if (OrderType()==2)
       {
        OrderModify( OrderTicket(), PRICE, Bid-glob("lost")*Point, Ask+glob("profit")*Point-glob("skip"), WITHIN, MidnightBlue);
        change++;    
       }
 
     sum--;
    
    }
      
  Print ("Count of changes ",change);
  if (change==0) 
  {    
 
  Print ("Buy limit at price ",PRICE);
  int ticket=OrderSend( Symbol(), OP_BUYLIMIT, LOTS, PRICE, 0, Bid-glob("lost")*Point, Ask+glob("profit")*Point-glob("skip"), text, magic,WITHIN,Blue);
   }
   
  Print("ticket : ",ticket); 
  if(ticket>1 && ticket<150)
     {
      int error=GetLastError();
      Print("Error = ",ErrorDescription(error));
      PlaySound("alert2.wav");
     }
  else PlaySound("Ok.wav"); 
  return(0);   
 
  }
//+------------------------------------------------------------------+
//| script "intraday trading - buy order"                            |
//+------------------------------------------------------------------+
int buy_order()
  {
  PlaySound("Tick.wav");
  RefreshRates();
  double PRICE=Ask;
  double LOTS=AccountBalance()* glob("maxrisk") *0.1 / glob("lost");
  
  int ticket=OrderSend( Symbol(),OP_BUY,LOTS,Ask,0,Bid-glob("lost")*Point, Ask+glob("profit")*Point,"buy order",3,0,PaleGreen);
 
  Print("ticket : ",ticket); 
  if(ticket>1 && ticket<150)
     {
      int error=GetLastError();
      Print("Error = ",ErrorDescription(error));
      PlaySound("alert2.wav");
     }
  else PlaySound("Ok.wav");      
  return(0);   
 
  }
//+------------------------------------------------------------------+
//| script "intraday trading - sell limit"                            |
//+------------------------------------------------------------------+
int sell_limit(string text,int magic)
  {
  PlaySound("Tick.wav");
  RefreshRates();
  double PRICE=Bid+glob("skip");
  double LOTS=AccountBalance()* glob("maxrisk") *0.1 / glob("lost");
  double WITHIN=TimeCurrent()+glob("expiration")*60;  
  double sum=OrdersTotal();
  double change=0;
  
  Print ("Count of ticket ",sum);
 
  while (sum>0)
    {
    OrderSelect(sum-1,SELECT_BY_POS);
    Print (OrderTicket ());
    Print (OrderType ());
    
      if (OrderType()==3)
       {
        OrderModify( OrderTicket(), PRICE, Ask+glob("lost")*Point, Bid-glob("profit")*Point+glob("skip"), WITHIN, Crimson);
        change++;    
       }
 
     sum--;
    
    }
      
  Print ("Count of changes ",change);
  if (change==0) 
  {    
 
  Print ("Sell limit at price ",PRICE);
  int ticket=OrderSend( Symbol(), OP_SELLLIMIT, LOTS, PRICE, 0, Ask+glob("lost")*Point, Bid-glob("profit")*Point+glob("skip"), text, magic,WITHIN,Red);
  }   
  
  Print("ticket : ",ticket); 
  if(ticket>1 && ticket<150)
     {
      int error=GetLastError();
      Print("Error = ",ErrorDescription(error));
      PlaySound("alert2.wav");
     }
  else PlaySound("Ok.wav");      
  return(0);
  }
  
//+------------------------------------------------------------------+
//| script "intraday trading - sell order"                            |
//+------------------------------------------------------------------+
int sell_order()
  {
  PlaySound("Tick.wav");
  RefreshRates();
  double PRICE=Bid;
  double LOTS=AccountBalance()* glob("maxrisk") *0.1 / glob("lost");
  
  int ticket=OrderSend( Symbol(),OP_SELL,LOTS,Bid,0,Ask+glob("lost")*Point, Bid-glob("profit")*Point,"sell order",3,0,DeepPink);
   
  Print("ticket : ",ticket); 
  if(ticket>1 && ticket<150)
     {
      int error=GetLastError();
      Print("Error = ",ErrorDescription(error));
      PlaySound("alert2.wav");
     }
  else PlaySound("Ok.wav");      
  return(0);   
 
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                       IDT_variables.mq4                          |
//|                      Copyright  2004, Globus                    |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| script "nastaveni globalnich promenych"                            |
//+------------------------------------------------------------------+
int variables(int predvolba)
  {
  PlaySound("Tick.wav");
 
  // promene
  int change=0;
  int lasttickscale=MathAbs(iHighest(NULL,PERIOD_M1,MODE_HIGH,1,0)-iLowest(NULL,PERIOD_M1,MODE_LOW,1,0)); //rozsah posledniho ticku
  int tenminutes=MathAbs(iHighest(NULL,PERIOD_M1,MODE_HIGH,10,0)-iLowest(NULL,PERIOD_M1,MODE_LOW,10,0));  //rozsah poslednich deseti ticku
  int fifteenminutes=MathAbs(iHighest(NULL,PERIOD_M1,MODE_HIGH,15,0)-iLowest(NULL,PERIOD_M1,MODE_LOW,15,0));  //rozsah poslednich deseti ticku
  int profit=3;       //profit do plusu
  int lost=13;        //akceptovane ztraty
  int expiration=60;  //doba v minutach do vyprseni cekajiciho prikazu
  double maxrisk=0.02;  //maximalni riziko na dany obchod v procentech uctu
  double skip=0.0003;   //nakup nebo prodej lisici se o dany pocet bodu
  
  //podminky
  if (predvolba!=change) change=predvolba;
  if (Volume[1]>20 && change==0 && lasttickscale>4) change=1;  //splaseny trh
  if (change==0 && tenminutes>4) change=2;  //trendovy trh
  if (change==0 && tenminutes<5) change=3;  //pohyb do strany
  
  //hodnoty
  switch (change)
   {
      case 1:
         profit=10;       //profit do plusu
         lost=4;        //akceptovane ztraty
         expiration=10;  //doba v minutach do vyprseni cekajiciho prikazu
         maxrisk=0.02;  //maximalni riziko na dany obchod v procentech uctu
         skip=0.0006;   //nakup nebo prodej lisici se o dany pocet bodu  
         
         break;
         
      case 2:
         profit=4;       //profit do plusu
         lost=MathRound(fifteenminutes*0.8);        //akceptovane ztraty
         expiration=15;  //doba v minutach do vyprseni cekajiciho prikazu
         maxrisk=0.02;  //maximalni riziko na dany obchod v procentech uctu
         skip=0.0004;   //nakup nebo prodej lisici se o dany pocet bodu   
         
         if (lost>13 || lost<4) lost=12; 
         break;
         
      case 3:
         profit=2;       //profit do plusu
         lost=MathRound(tenminutes);        //akceptovane ztraty
         expiration=60;  //doba v minutach do vyprseni cekajiciho prikazu
         maxrisk=0.02;  //maximalni riziko na dany obchod v procentech uctu
         skip=0.0003;   //nakup nebo prodej lisici se o dany pocet bodu   
         
         if (lost>13 || lost<4) lost=8; 
         break;
         
      case 4: //automat
         profit=1;       //profit do plusu - automat
         lost=MathRound(tenminutes);        //akceptovane ztraty
         expiration=10;  //doba v minutach do vyprseni cekajiciho prikazu
         maxrisk=0.02;  //maximalni riziko na dany obchod v procentech uctu
         skip=0.0002;   //nakup nebo prodej lisici se o dany pocet bodu   
         
         if (lost>13 || lost<4) lost=8; 
         break;
         
      default:
         profit=3;       //profit do plusu
         lost=13;        //akceptovane ztraty
         expiration=60;  //doba v minutach do vyprseni cekajiciho prikazu
         maxrisk=0.02;  //maximalni riziko na dany obchod v procentech uctu
         skip=0.0002;   //nakup nebo prodej lisici se o dany pocet bodu   
         break;
   }
  Print("Change : ",change," 10/minut : ",tenminutes," 15/minut : ",fifteenminutes);
  GlobalVariableSet("pattern",change);
  GlobalVariableSet("profit",profit);
  GlobalVariableSet("profit",profit);
  GlobalVariableSet("lost",lost);
  GlobalVariableSet("expiration",expiration);
  GlobalVariableSet("maxrisk",maxrisk);
  GlobalVariableSet("skip",skip);

  PlaySound("Ok.wav");      
  return(change);   
 
  }
//+------------------------------------------------------------------+

