//+------------------------------------------------------------------+
//|                                             ind_RSICCIDiv_v1.mq4 |
//|                                                                * |
//|                                                                * |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "for-good-letters@yandex.ru"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 DeepSkyBlue
#property indicator_color2 Red

#property indicator_width1 2
#property indicator_width2 2

 
//---- input parameters
extern   int   RSIPeriod=14;           //  RSI.
extern   int   RSIPrice=0;             //  RSI: 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted.
extern   int   RSILowerLevel=60;       //   RSI,     100-RSILowerLevel.  RSI      ,    - . 
         int   RSIUpperLevel;
extern   int   RSILowerLevel_2=30;     //   RSI      /.     100-RSILowerLevel_2.
         int   RSIUpperLevel_2; 
extern   bool  CheckLastRSIZone=true;  //    / RSI.
extern   bool  ReverseRSIZone=false;   //    / RSI.
extern   int   CCIPeriod=14;           //  CCI
extern   int   CCIPrice=5;             //  CCI: 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted.
extern   int   CCILevel=200;           //   CCI.    - CCILevel.

/*
       :
   
      BUY: 
            RSI    (  RSILowerLevel).     -  40.
            CCI   .     -  -200
            
              CheckLastRSIZone,     / RSI   (RSILowerLevel_2).
             ReverseRSIZone=false,    ,       ,     -  70.
             ReverseRSIZone=true,         ,     -  30.
            
            
            
*/

//---- buffers
double Buy[];
double Sell[];
double LastRSIZone[];
int Sign=1;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(3);
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,241);
   SetIndexBuffer(0,Buy);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,242);
   SetIndexBuffer(1,Sell);
   SetIndexBuffer(2,LastRSIZone);  
   
   SetIndexLabel(0,"Buy");
   SetIndexLabel(1,"Sell");    
   
   
   RSIUpperLevel=100-RSILowerLevel;
   RSIUpperLevel_2=100-RSILowerLevel_2;   
   if(ReverseRSIZone)Sign=-1;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    limit=Bars-IndicatorCounted();
   
      for(int i=limit-1;i>=0;i--){
         LastRSIZone[i]=LastRSIZone[i+1];
         
         double cci=iCCI(NULL,0,CCIPeriod,CCIPrice,i);
         double rsi=iRSI(NULL,0,RSIPeriod,RSIPrice,i);
         
            if(rsi>RSIUpperLevel_2){
               LastRSIZone[i]=1;
            }
            if(rsi<RSILowerLevel_2){
               LastRSIZone[i]=-1;            
            }            
         
            
            if(rsi>RSIUpperLevel){
               if(cci<-CCILevel){
                  if(LastRSIZone[i]==Sign || !CheckLastRSIZone)
                  Buy[i]=Low[i]-Point*5;
               }
            }
            if(rsi<RSILowerLevel){
               if(cci>CCILevel){
                  if(LastRSIZone[i]==-Sign || !CheckLastRSIZone)
                  Sell[i]=High[i]+Point*5;
               }
            }         
      }
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+