//+------------------------------------------------------------------+
//|                                                      FullSSA.mq4 |
//|                                           Copyright  2007, klot |
//|                                                     klot@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, klot"
#property link      "klot@mail.ru"


#import "SSA.ex4" //"FullSSA.dll"
 void fastsingular(double a[],int n,int lag,int s,double& b[]);
#import


#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Yellow
#property indicator_level1 0.0
//----
   extern int Lag=10;
   extern int NumComps=2;
   extern  int PeriodNorm=10;
   extern int N=300;

   double arryTimeSeries[];
//---- buffers
double SSA[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,SSA);
   ArrayResize(arryTimeSeries,N);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
   SetIndexDrawBegin(0,Bars-N);
   double dev,ma;
   int i, nmax, nmin;
   //---
   for( i=N-1; i>=0; i--) {
   //-----
      ma=iMA(NULL,0,PeriodNorm,0,MODE_SMA,PRICE_CLOSE,i);
      dev=3*iStdDev(NULL,0,PeriodNorm,0,MODE_SMA,PRICE_CLOSE,i);
      if(dev==0) dev=0.1;
      arryTimeSeries[i]=(Close[i]-ma)/dev;//iDeMarker(NULL,0,PeriodNorm,i);
   }
   fastsingular(arryTimeSeries,N,Lag,NumComps,SSA);
   nmax=ArrayMaximum(SSA,3,1);
   nmin=ArrayMinimum(SSA,3,1);
   if(nmax==2) {
            ObjectCreate("Sell"+Time[0],OBJ_ARROW,0,Time[0],Open[0]);
            ObjectSet("Sell"+Time[0],OBJPROP_ARROWCODE,226);
   }
   if(nmin==2) {
            ObjectCreate("Buy"+Time[0],OBJ_ARROW,0,Time[0],Open[0]);
            ObjectSet("Buy"+Time[0],OBJPROP_ARROWCODE,225);
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+