//+------------------------------------------------------------------+
//|                                                IncOBVOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   // 0 value for all bars of a chart
   input int OBVPeriod=0;
   
   Declaration:
   #include <IncOnArray/IncOBVOnArray.mqh>
   COBVOnArray obv;

   In OnInit:
   obv.Init(OBVPeriod);   
    
   obv.Init();
   
   In OnCalculate:
   obv.Solve(rates_total,prev_calculated,DataClose,DataVolume,OBVBuffer);
*/
//+------------------------------------------------------------------+
//| COBVOnArray                                                      |
//+------------------------------------------------------------------+
class COBVOnArray
  {
protected:
   int               m_Period;
   string            m_Name;
   int               m_br;
public:
   void Init(int aPeriod=0)
     {
      m_Period=aPeriod;
      m_br=0;
      m_Name="OBV";
      if(m_Period>0)
        {
         m_br=m_Period+1;
         m_Name="OBV("+IntegerToString(m_Period)+")";
        }
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataClose[],
              double  &aDataVolume[],
              double  &aOBV[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         if(m_Period>0)
           {
            for(int i=0;i<aRatesTotal;i++)
              {
               if(aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE)
                 {
                  if(aDataVolume[i]!=0 && aDataVolume[i]!=EMPTY_VALUE)
                    {
                     Start=i;
                     break;
                    }
                 }
              }
            if(Start==0)
              {
               Start=1;
              }
            Start=Start+m_Period;
            aOBV[Start]=0;
            for(int i=Start;i>Start-m_Period;i--)
              {
               if(aDataClose[i]>aDataClose[i-1])
                 {
                  aOBV[Start]+=aDataVolume[i];
                 }
               else if(aDataClose[i]<aDataClose[i-1])
                 {
                  aOBV[Start]-=aDataVolume[i];
                 }
              }
            for(int i=0;i<Start;i++)
              {
               aOBV[i]=0;
              }
           }
         else
           {
            aOBV[Start]=aDataVolume[Start];
           }

         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }
      if(m_Period>0)
        {
         for(int i=Start;i<aRatesTotal;i++)
           {
            aOBV[i]=aOBV[i-1];
            if(aDataClose[i-m_Period]>aDataClose[i-1-m_Period])
              {
               aOBV[i]-=aDataVolume[i-m_Period];
              }
            else if(aDataClose[i-m_Period]<aDataClose[i-1-m_Period])
              {
               aOBV[i]+=aDataVolume[i-m_Period];
              }
            if(aDataClose[i]>aDataClose[i-1])
              {
               aOBV[i]+=aDataVolume[i];
              }
            else if(aDataClose[i]<aDataClose[i-1])
              {
               aOBV[i]-=aDataVolume[i];
              }
           }
        }
      else
        {
         for(int i=Start;i<aRatesTotal;i++)
           {
            if(aDataClose[i]>aDataClose[i-1])
              {
               aOBV[i]=aOBV[i-1]+aDataVolume[i];
              }
            else if(aDataClose[i]<aDataClose[i-1])
              {
               aOBV[i]=aOBV[i-1]-aDataVolume[i];
              }
            else
              {
               aOBV[i]=aOBV[i-1];
              }
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's OBVOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
