//+------------------------------------------------------------------+
//|                                                IncSAROnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input double SARStep =  0.02;
   input double SARMax  =  0.2;

   Declaration:
   #include <IncOnArray/IncSAROnArray.mqh>
   CSAROnArray sar;

   In OnInit:
   sar.Init(SARStep,SARMax);

   In OnCalculate:
   sar.Solve(rates_total,prev_calculated,DataHigh,DataLow,SARBuffer);
*/
//+------------------------------------------------------------------+
//| CSAROnArray                                                      |
//+------------------------------------------------------------------+
class CSAROnArray
  {
protected:
   double            m_max;
   double            m_step;
   int               m_lb;
   double            m_lhl_p;
   double            m_lhl_c;
   double            m_st_p;
   double            m_st_c;
   string            m_name;
   string tz(double aValue)
     {
      string m_tmp=DoubleToString(aValue,8);
      while(StringLen(m_tmp)>1 && StringSubstr(m_tmp,StringLen(m_tmp)-1,1)=="0")
        {
         m_tmp=StringSubstr(m_tmp,0,StringLen(m_tmp)-1);
        }
      if(StringSubstr(m_tmp,StringLen(m_tmp)-1,1)==".")
        {
         m_tmp=StringSubstr(m_tmp,0,StringLen(m_tmp)-1);
        }
      return(m_tmp);
     }
public:
   void Init(double aStep=0.02,double aMax=0.2)
     {
      m_max=aMax;
      m_step=aStep;
      m_name="SAR("+this.tz(aStep)+","+this.tz(aMax)+")";
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aSAR[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i+2;

               break;
              }
           }
         for(int i=Start;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]>aDataHigh[i-1] && aDataLow[i]>=aDataLow[i-1])
              {
               aSAR[i-1]=MathMin(aDataLow[i-1],aDataLow[i-2]);
               m_lhl_p=aDataHigh[i-1];
               m_st_p=m_step;
               Start=i;
               break;
              }
            if(aDataLow[i]<aDataLow[i-1] && aDataHigh[i]<=aDataHigh[i-1])
              {
               aSAR[i-1]=MathMax(aDataHigh[i-1],aDataHigh[i-2]);
               m_lhl_p=aDataLow[i-1];
               m_st_p=-m_step;
               Start=i;
               break;
              }
           }
         m_lb=Start;
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         if(i>m_lb)
           {
            m_lb=i;
            m_lhl_p=m_lhl_c;
            m_st_p=m_st_c;
           }
         else
           {
            m_lhl_c=m_lhl_p;
            m_st_c=m_st_p;
           }
         if(m_st_c>0)
           {
            aSAR[i]=aSAR[i-1]+m_st_c*(m_lhl_c-aSAR[i-1]);
            aSAR[i]=MathMin(aDataLow[i-1],aSAR[i]);
            aSAR[i]=MathMin(aDataLow[i-2],aSAR[i]);
            if(aDataLow[i]<aSAR[i])
              {
               aSAR[i]=m_lhl_c;
               m_st_c=-m_step;
               m_lhl_c=aDataLow[i];
               continue;
              }
            if(aDataHigh[i]>m_lhl_c)
              {
               m_lhl_c=aDataHigh[i];
               m_st_c+=m_step;
               m_st_c=MathMin(m_st_c,m_max);
              }
           }
         if(m_st_c<0)
           {
            aSAR[i]=aSAR[i-1]+m_st_c*(aSAR[i-1]-m_lhl_c);
            aSAR[i]=MathMax(aDataHigh[i-1],aSAR[i]);
            aSAR[i]=MathMax(aDataHigh[i-2],aSAR[i]);
            if(aDataHigh[i]>aSAR[i])
              {
               aSAR[i]=m_lhl_c;
               m_st_c=m_step;
               m_lhl_c=aDataHigh[i];
               continue;
              }
            if(aDataLow[i]<m_lhl_c)
              {
               m_lhl_c=aDataLow[i];
               m_st_c-=m_step;
               m_st_c=MathMax(m_st_c,-m_max);
              }
           }
        }
     }
   string Name()
     {
      return(m_name);
     }
  };
//+------------------------------------------------------------------+
