//+------------------------------------------------------------------+
//|                                                IncMFIOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int               MFIPeriod=14;
   input ENUM_MA_METHOD    MFIMethod=MODE_SMA;

   Declaration:
   #include <IncOnArray/IncMFIOnArray.mqh>
   CMFIOnArray mfi;

   In OnInit: 
   mfi.Init(MFIPeriod,MFIMethod);

   In OnCalculate:
   mfi.Solve(rates_total,prev_calculated,DataPrice,DataVolume,PBuffer,MBuffer,PSBuffer,MSBuffer,MFIBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CMFIOnArray                                                      |
//+------------------------------------------------------------------+
class CMFIOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   int               m_br;
   string            m_Name;
   CMAOnArray        m_map;
   CMAOnArray        m_mam;
public:
   void Init(int aPeriod,ENUM_MA_METHOD aMethod=MODE_SMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_Name="MFI("+IntegerToString(m_Period)+")";
      m_map.Init(m_Period,m_Method);
      m_mam.Init(m_Period,m_Method);
      m_br=m_map.BarsRequired()+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataPrice[],
              double  &aDataVolume[],
              double  &aP[],
              double  &aM[],
              double  &aPS[],
              double  &aMS[],
              double  &aMFI[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataPrice[i]!=0 && aDataPrice[i]!=EMPTY_VALUE)
              {
               if(aDataVolume[i]!=0 && aDataVolume[i]!=EMPTY_VALUE)
                 {
                  Start=i;
                  break;
                 }
              }
           }
         aP[Start]=0.00000001;
         aM[Start]=0.00000001;
         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }

      for(int i=Start;i<aRatesTotal;i++)
        {
         aM[i]=0;
         aP[i]=0;
         if(aDataPrice[i]>aDataPrice[i-1])
           {
            aP[i]=aDataPrice[i]*aDataVolume[i];
           }
         else if(aDataPrice[i]<aDataPrice[i-1])
           {
            aM[i]=aDataPrice[i]*aDataVolume[i];
           }
        }
      m_mam.Solve(aRatesTotal,aPrevCalc,aM,aMS);
      m_map.Solve(aRatesTotal,aPrevCalc,aP,aPS);
      for(int i=Start;i<aRatesTotal;i++)
        {
         if(aMS[i]!=0.0)
           {
            aMFI[i]=100.0-100.0/(1.0+aPS[i]/aMS[i]);
           }
         else
           {
            aMFI[i]=100.0;
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's MFIOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
