//+------------------------------------------------------------------+
//|                                           IncMomentumOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int      MomPeriod   =  14;

   Declaration:
   #include <IncOnArray/IncMomentumOnArray.mqh>
   CMomentumOnArray mom;

   In OnInit:
   mom.Init(MomPeriod);

   In OnCalculate:
   mom.Solve(rates_total,prev_calculated,data,MomBuffer); 
*/
//+------------------------------------------------------------------+
//| CMomentumOnArray                                                 |
//+------------------------------------------------------------------+
class CMomentumOnArray
  {
private:
   int               m_Period;
   string            m_Name;
   double            m_d;
   int               m_br;
public:
   void Init(int aPeriod=14)
     {
      m_Period=aPeriod;
      m_Name="Momentum("+IntegerToString(m_Period)+")";
      m_br=m_Period+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aMomentum[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aData[i]!=0 && aData[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         m_d=aData[i-m_Period];
         if(m_d!=0)
           {
            aMomentum[i]=aData[i]/aData[i-m_Period]*100.0;
           }
         else
           {
            aMomentum[i]=aMomentum[i-1];
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's MomentumOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
