﻿#property copyright "Copyright 2023, Forester"
#property link      "https://www.mql5.com"
#property version   "1.00"

#include <GZIP.mqh>
GZIP gzip;

void OnStart(){
    /*  Print("GZipped webpage read sample:");
      string url="https://..........";
      char out[]; 
      if(http_req(url, out,"GET","Accept-Encoding: gzip, deflate\r\n", 1,0)){
          if(gzip.isGZIP(out)){
            Print("GZIP detected");
            string txt; if(!gzip.unGZIP(out, txt, 1, CP_UTF8)){return;}//CP_ACP
            Print(txt);
         }else{
         Print("No GZIP");Print(CharArrayToString(out, 0, WHOLE_ARRAY, CP_UTF8));
         }
      }*/
      
      Print("File read sample:");
      bool is_common=1;
      string fn="3.csv.gz";
      bool is_zip=1;

      int h;
      if(is_zip){
         h = FileOpen(fn,FILE_READ|FILE_BIN|FILE_READ|(is_common?FILE_COMMON:0));
      }else{
         h = FileOpen(fn,FILE_READ|FILE_CSV|FILE_ANSI|(is_common?FILE_COMMON:0));
      }
      if( h!=INVALID_HANDLE){
         Print ("Start gzip");
         char gz[],tx[];
         FileReadArray(h, gz); FileClose(h); 
         
         if(gzip.isGZIP(gz)){
            Print("GZIP detected");
            string fname;
            if(!gzip.unGZIP(gz, tx,fname,1)){return;}
            //string txt; if(!unGZIP(gz, txt, 1, CP_ACP)){return;}//CP_UTF8
            //string txt=unGZIP(gz, 1, CP_ACP);if(txt==""){return;}
            if(fname!=NULL){Print("File name: ",fname,", file size: ",ArraySize(tx));}
            string t=  CharArrayToString(tx,0,100);Print("Filr content: ",t);t=  CharArrayToString(tx,ArraySize(tx)-100,100);Print("... ",t);

 
            //ulong mcs = GetMicrosecondCount();
            //string csvRow[];int columns=0, next=0; char sep=',', newLine='\n';
            //while(getCSVRow(tx, csvRow, columns, next, sep, newLine) && !IsStopped()){//get next row
              // for(int c=0; c<columns; c++){
               //Print();
              // }
               //Print(next);
            //}
            //Print("CSV parse time: ",(GetMicrosecondCount()-mcs)," mcs");
            //ArrayPrint(csvRow);

        }else{}
      }
}


bool http_req(string url, char& out[],string method="GET",string headers_request=NULL, bool printTime=false,bool debug=false){
   ulong mcs = (printTime?GetMicrosecondCount():0);
   bool retVal=false;
   ResetLastError();
   char data[];string headers=NULL;
   int r=WebRequest(method, url, headers_request, 5000, data, out, headers);
   if(r==-1){Print("Error in WebRequest. Err code =",GetLastError());MessageBox("It is necessary to add the address '"+url+"' to the list of allowed URLs in the 'Advisors' tab","Error",MB_ICONINFORMATION);}
   else{if(r==200){ retVal=  true; }else{PrintFormat("Download error '%s', responce code %d",url,r);Print("Error in WebRequest. Err code =",GetLastError());}}if(debug){PrintFormat("Responce headers: %s\r\nResponce:",headers);Print(CharArrayToString(out));}//
   if(printTime){Print("WebRequest time: ",(GetMicrosecondCount()-mcs)," mcs");}
   return retVal;
}