//+------------------------------------------------------------------+
//|                            eIncGUI_v4_Test_CCalendarInputBox.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"

#include <IncGUI_v4.mqh>
//+------------------------------------------------------------------+
//| Color schemes enumeration                                        |
//+------------------------------------------------------------------+
enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CCalendarInputBox cl;
CCalendarInputBox cl2;
CCalendarInputBox cl3;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   ClrScheme.SetScheme(ColorScheme);

   cl.Init("CCalendar1",true,true,true,true,1,"Date, time with seconds and the line");
   cl.SetSubWindow("TestSubWindow");
   cl.Show(10,20);
   cl.SetValueDateTime(1234567);
//int w=cl.Width();

   cl2.Init("CCalendar2",true,false,true,false,1,"Date");
   cl2.SetSubWindow("TestSubWindow");
//cl2.SetWidth(w);
   cl2.Show(10,40);
   cl2.SetValueDateTime(1234567);

   cl3.Init("CCalendar3",false,true,true,false,1,"Time with seconds");
   cl3.SetSubWindow("TestSubWindow");
//cl3.SetWidth(w);
   cl3.Show(10,60);
   cl3.SetValueDateTime(1234567);

   EventSetTimer(1);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   cl.Hide();
   cl2.Hide();
   cl3.Hide();
   EventKillTimer();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

  }
//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
   cl.TimeNowRefresh();
   cl2.TimeNowRefresh();
   cl3.TimeNowRefresh();
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   if(cl.Event(id,lparam,dparam,sparam)==1)
     {
      Alert("CCalendar1 event. New value: "+cl.ValueString());
     }
   if(cl2.Event(id,lparam,dparam,sparam)==1)
     {
      Alert("CCalendar2 event. New value: "+cl2.ValueString());
     }
   if(cl3.Event(id,lparam,dparam,sparam)==1)
     {
      Alert("CCalendar3 event. New value: "+cl3.ValueString());
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      cl.SetSubWindow("TestSubWindow");
      cl2.SetSubWindow("TestSubWindow");
      cl3.SetSubWindow("TestSubWindow");
     }
  }
//+------------------------------------------------------------------+
