//https://www.mql5.com/en/articles/249
//EXPOSING C# CODE TO MQL5 USING UNMANAGED EXPORTS

//https://learn.microsoft.com/en-us/dotnet/api/system.decimal.round?view=net-7.0
using System;
using System.Runtime.InteropServices;

// decimal type is 128-bits
public class DecimalPrecision
{
	// decimal floating point rounding
	public static double Round(double value, int digits)
	{
		return (Double) Math.Round((decimal) value, digits, MidpointRounding.AwayFromZero);
	}

	// decimal floating point ceiling
	public static double Ceiling(double value, int digits)
	{
		decimal p = (decimal) Math.Pow(10, digits);
		return (Double)(Math.Ceiling((decimal) value * p) / p);
	}

	// decimal floating point floor
	public static double Floor(double value, int digits)
	{
		decimal p = (decimal) Math.Pow(10, digits);
		return (Double)(Math.Floor((decimal) value * p) / p);
	}

	// decimal floating point truncate
	public static double Truncate(double value, int digits)
	{
		decimal p = (decimal) Math.Pow(10, digits);
		return (Double)(Math.Truncate((decimal) value * p) / p);
	}

	// decimal floating point rounding to step
	public static double Round(double value, double step)
	{
		decimal dstep = (decimal) step;
		return (Double)(Math.Round((decimal) value / dstep, MidpointRounding.AwayFromZero) * dstep);
	}

	// decimal floating point ceiling to step
	public static double Ceiling(double value, double step)
	{
		decimal dstep = (decimal) step;
		return (Double)(Math.Ceiling((decimal) value / dstep) * dstep);
	}

	// decimal floating point floor to step
	public static double Floor(double value, double step)
	{
		decimal dstep = (decimal) step;
		return (Double)(Math.Floor((decimal) value / dstep) * dstep);
	}

	// decimal floating point truncate to step
	public static double Truncate(double value, double step)
	{
		decimal dstep = (decimal) step;
		return (Double)(Math.Truncate((decimal) value / dstep) * dstep);
	}

    // https://stackoverflow.com/a/374470/4208440
	public static double RoundToSignificantDigits(double d, int digits)
	{
		if (d == 0)
			return 0;

		decimal scale = (decimal) Math.Pow(10, Math.Floor(Math.Log10(Math.Abs(d))) + 1);
		return (Double)(scale * Math.Round((decimal)d / scale, digits, MidpointRounding.AwayFromZero));
	}
}
