//+------------------------------------------------------------------+ 
//|                                                      MFI_HTF.mq5 | 
//|                               Copyright  2014, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2014, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---   
#property version   "1.60"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---      
#property indicator_color1 clrRed,clrPurple,clrGray,clrTeal,clrLime
//---   - 
#property indicator_style1 STYLE_SOLID
//---     5
#property indicator_width1 5
//---   
#property indicator_label1 "MFI HTF"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +20.0
#property indicator_level2   0.0
#property indicator_level3 -20.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;         //  
input int Length=8;                                //   
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  //  
input bool ReDraw=true;                            //      
//+----------------------------------------------+
//---       
bool Init;
//---      
int min_rates_total;
//---      
int MFI_Handle;
//---   ,    
//---       
double MFIBuffer[],ColorMFIBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//---
   return(StringSubstr(EnumToString(timeframe),7,-1));
//---
  }
//+------------------------------------------------------------------+    
//| MFI indicator initialization function                            | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//---     
   min_rates_total=3;
   Init=true;
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    iMFI       ");
      Init=false;
      return;
     }
//---     iMFI
   MFI_Handle=iMFI(Symbol(),TimeFrame,Length,VolumeType);
   if(MFI_Handle==INVALID_HANDLE)
     {
      Print("       iMFI");
      Init=false;
      return;
     }
//---    MFIBuffer   
   SetIndexBuffer(0,MFIBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL," MFI HTF");
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(MFIBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorMFIBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorMFIBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname," MFI HTF(",GetStringTimeframe(TimeFrame),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+  
//| MFI iteration function                                           | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total || !Init) return(RESET);
   if(BarsCalculated(MFI_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---   
   int limit,bar;
//---       
   double MFI[2];
   datetime MFITime[1];
   static uint LastCountBar;
//---      
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//---         
   ArraySetAsSeries(time,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      MFIBuffer[bar]=EMPTY_VALUE;
      ColorMFIBuffer[bar]=0;
      //---      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,MFITime)<=0) return(RESET);

      if(time[bar]>=MFITime[0] && time[bar+1]<MFITime[0])
        {
         LastCountBar=bar;
         //---      
         if(CopyBuffer(MFI_Handle,0,time[bar],2,MFI)<=0) return(RESET);
         //---      
         MFIBuffer[bar]=MFI[1]-50.0;
         //---
         if(MFIBuffer[bar]>0)
           {
            if(MFI[1]>MFI[0]) ColorMFIBuffer[bar]=4;
            if(MFI[1]<MFI[0]) ColorMFIBuffer[bar]=3;
           }
         //---
         if(MFIBuffer[bar]<0)
           {
            if(MFI[1]<MFI[0]) ColorMFIBuffer[bar]=0;
            if(MFI[1]>MFI[0]) ColorMFIBuffer[bar]=1;
           }
        }
      //---
      if(ReDraw)
        {
         if(MFIBuffer[bar+1]!=EMPTY_VALUE && MFIBuffer[bar]==EMPTY_VALUE)
           {
            MFIBuffer[bar]=MFIBuffer[bar+1];
            ColorMFIBuffer[bar]=ColorMFIBuffer[bar+1];
           }
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
