//+------------------------------------------------------------------+
//|                                                         RFTL.mq5 |
//|                                  Copyright 2002, Finware.ru Ltd. |
//|                                           http://www.finware.ru/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright 2002, Finware.ru Ltd."
//----    
#property link      "http://www.finware.ru/"
//----   
#property version   "2.00"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  Aquamarine
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "RFTL"

//----   
input int RFTLShift=0; //       

//----         
int RFTLPeriod;

//----   ,    
//----      
double ExtLineBuffer[];

//----        
double RFTLTable[]=
  {
   -0.0025097319, +0.0513007762, +0.1142800493, +0.1699342860, +0.2025269304,
   +0.2025269304, +0.1699342860, +0.1142800493, +0.0513007762, -0.0025097319,
   -0.0353166244, -0.0433375629, -0.0311244617, -0.0088618137, +0.0120580088,
   +0.0233183633, +0.0221931304, +0.0115769653, -0.0022157966, -0.0126536111,
   -0.0157416029, -0.0113395830, -0.0025905610, +0.0059521459, +0.0105212252,
   +0.0096970755, +0.0046585685, -0.0017079230, -0.0063513565, -0.0074539350,
   -0.0050439973, -0.0007459678, +0.0032271474, +0.0051357867, +0.0044454862,
   +0.0018784961, -0.0011065767, -0.0031162862, -0.0033443253, -0.0022163335,
   +0.0002573669, +0.0003650790, +0.0060440751, +0.0018747783
  };
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----       RFTLShift
   PlotIndexSetInteger(0,PLOT_SHIFT,RFTLShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,RFTLPeriod);
//----      
   string shortname;
   StringConcatenate(shortname,"RFTL(",RFTLShift,")");
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---    
   RFTLPeriod=ArraySize(RFTLTable);
//----       
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,RFTLPeriod);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[]     //     
                )
  { 
//----       
   if(rates_total<RFTLPeriod-1+begin)
      return(0);

//----    
   int first,bar,iii;
   double RFTL;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=RFTLPeriod-1+begin; //      
      //---      begin ,      
      if(begin>0)
         PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,begin+RFTLPeriod);
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----     
      RFTL=0.0;
      for(iii=0; iii<RFTLPeriod; iii++)
         RFTL+=RFTLTable[iii] *price[bar-iii];

      //----       RFTL
      ExtLineBuffer[bar]=RFTL;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
