#property indicator_buffers 0
#property indicator_plots 0
#property indicator_chart_window

sinput ulong chartID = 0;

#include <fxsaber\TradeTransactions\TradeTransactions.mqh>

TRADETRANSACTIONS Transactions((string)chartID);

void OnTradeTransaction( const MqlTradeTransaction &Trans, const MqlTradeRequest &Request, const MqlTradeResult &Result )
{
  Transactions.Add(Trans, Request, Result, GetCurrenTime());
}

int OnCalculate( const int, const int, const int, const double &[] )
{
  return(0);
}

// https://www.mql5.com/ru/forum/38456/page100#comment_6677928
//    
long GetSymbolTime( const string Symb )
{
  MqlTick Tick;

  return(SymbolInfoTick(Symb, Tick) ? Tick.time_msc : 0);
}

//     
long GetMarketWatchTime( void )
{
  long Res = 0;

  for (int i = SymbolsTotal(true) - 1; i >= 0; i--)
  {
    const long TmpTime = GetSymbolTime(SymbolName(i, true));

    if (TmpTime > Res)
      Res = TmpTime;
  }

  return(Res);
}

//        
long GetCurrenTime( void )
{
  static ulong StartTime = GetMicrosecondCount();
  static long PrevTime = 0;

  const long TmpTime = GetMarketWatchTime();

  if (TmpTime > PrevTime)
  {
    PrevTime = TmpTime;

    StartTime = GetMicrosecondCount();
  }

  return(PrevTime + (long)((GetMicrosecondCount() - StartTime) / 1000));
}