#include "String.mqh"

struct TRADERESULT
{
  uint     retcode;
  ulong    deal;
  ulong    order;
  double   volume;
  double   price;
  double   bid;
  double   ask;
  STRING   comment;
  uint     request_id;
  int      retcode_external; // https://www.mql5.com/ru/forum/1111/page2274#comment_8564616

  void operator =( const MqlTradeResult &Result )
  {
    this.retcode = Result.retcode;
    this.deal = Result.deal;
    this.order = Result.order;
    this.volume = Result.volume;
    this.price = Result.price;
    this.bid = Result.bid;
    this.ask = Result.ask;
    this.comment = Result.comment;
    this.request_id = Result.request_id;
    this.retcode_external = Result.retcode_external;

    return;
  }

  void Get( MqlTradeResult &Result ) const
  {
    Result.retcode = this.retcode;
    Result.deal = this.deal;
    Result.order = this.order;
    Result.volume = this.volume;
    Result.price = this.price;
    Result.bid = this.bid;
    Result.ask = this.ask;
    Result.comment = this.comment.Get();
    Result.request_id = this.request_id;
    Result.retcode_external = this.retcode_external;

    return;
  }
};