#include "String.mqh"

struct TRADEREQUEST
{
  ENUM_TRADE_REQUEST_ACTIONS    action;
  ulong                         magic;
  ulong                         order;
  STRING                        symbol;
  double                        volume;
  double                        price;
  double                        stoplimit;
  double                        sl;
  double                        tp;
  ulong                         deviation;
  ENUM_ORDER_TYPE               type;
  ENUM_ORDER_TYPE_FILLING       type_filling;
  ENUM_ORDER_TYPE_TIME          type_time;
  datetime                      expiration;
  STRING                        comment;
  ulong                         position;
  ulong                         position_by;

  void operator =( const MqlTradeRequest &Request )
  {
    this.action = Request.action;
    this.magic = Request.magic;
    this.order = Request.order;
    this.symbol = Request.symbol;
    this.volume = Request.volume;
    this.price = Request.price;
    this.stoplimit = Request.stoplimit;
    this.sl = Request.sl;
    this.tp = Request.tp;
    this.deviation = Request.deviation;
    this.type = Request.type;
    this.type_filling = Request.type_filling;
    this.type_time = Request.type_time;
    this.expiration = Request.expiration;
    this.comment = Request.comment;
    this.position = Request.position;
    this.position_by = Request.position_by;

    return;
  }

  void Get( MqlTradeRequest &Request ) const
  {
    Request.action = this.action;
    Request.magic = this.magic;
    Request.order = this.order;
    Request.symbol = this.symbol.Get();
    Request.volume = this.volume;
    Request.price = this.price;
    Request.stoplimit = this.stoplimit;
    Request.sl = this.sl;
    Request.tp = this.tp;
    Request.deviation = this.deviation;
    Request.type = this.type;
    Request.type_filling = this.type_filling;
    Request.type_time = this.type_time;
    Request.expiration = this.expiration;
    Request.comment = this.comment.Get();
    Request.position = this.position;
    Request.position_by = this.position_by;

    return;
  }
};