//     OnTradeTransaction

#include <fxsaber\TradeTransactions\TradeTransactions.mqh> //    OnTradeTransaction    

TRADETRANSACTIONS Transactions; //  

const bool Init = EventSetMillisecondTimer(100);

void OnTimer()
{
  static uint Total = 0;
  const uint NewTotal = Transactions.Total(); //    

  for (uint i = Total; i < NewTotal; i++) //    
  {
    MqlTradeTransaction Trans;
    MqlTradeRequest Request;
    MqlTradeResult Result;

    //         .
    Print(TimeToString(Transactions[i].Get(Trans, Request, Result)) + "\n" +
          ToString(Trans) + ToString(Request) + ToString(Result));
  }

  Total = NewTotal;
}

// https://www.mql5.com/ru/forum/38456/page100#comment_6677928
#define TOSTRING(A)  #A + " = " + (string)(A) + "\n"
#define TOSTRING2(A) #A + " = " + EnumToString(A) + " (" + (string)(A) + ")\n"

string ToString( const MqlTradeTransaction &Trans )
{
  return(TOSTRING(Trans.deal) + TOSTRING(Trans.order) + TOSTRING(Trans.symbol) +
         TOSTRING2(Trans.type) + TOSTRING2(Trans.order_type) + TOSTRING2(Trans.order_state) +
         TOSTRING2(Trans.deal_type) + TOSTRING2(Trans.time_type) +
         TOSTRING(Trans.time_expiration) + TOSTRING(Trans.price) + TOSTRING(Trans.price_trigger) +
         TOSTRING(Trans.price_sl) + TOSTRING(Trans.price_tp) + TOSTRING(Trans.volume) +
         TOSTRING(Trans.position) + TOSTRING(Trans.position_by));
}

string ToString( const MqlTradeRequest &Request )
{
  return(TOSTRING2(Request.action) + TOSTRING(Request.magic) + TOSTRING(Request.order) +
         TOSTRING(Request.symbol) + TOSTRING(Request.volume) + TOSTRING(Request.price) +
         TOSTRING(Request.stoplimit) + TOSTRING(Request.sl) +  TOSTRING(Request.tp) +
         TOSTRING(Request.deviation) + TOSTRING2(Request.type) + TOSTRING2(Request.type_filling) +
         TOSTRING2(Request.type_time) + TOSTRING(Request.expiration) + TOSTRING(Request.comment) +
         TOSTRING(Request.position) + TOSTRING(Request.position_by));
}

string ToString( const MqlTradeResult &Result )
{
  return(TOSTRING(Result.retcode) + TOSTRING(Result.deal) + TOSTRING(Result.order) +
         TOSTRING(Result.volume) + TOSTRING(Result.price) + TOSTRING(Result.bid) +
         TOSTRING(Result.ask) + TOSTRING(Result.comment) + TOSTRING(Result.request_id) +
         TOSTRING(Result.retcode_external));
}

string TimeToString( const long Value )
{
  return((string)(datetime)(Value / 1000) + "." + (string)IntegerToString(Value % 1000, 3, '0'));
}