// https://www.mql5.com/ru/code/20225
#property script_show_inputs

#include <fxsaber\ThirdPartyTicks\ThirdPartyTicks.mqh>

sinput bool   Sync = true; // Synchronization
sinput string symbol = ""; // Symbol (NULL - current, "AllSymbols" - All)

THIRDPARTYTICKS ThirdPartyTicks; //     

//  
void CreateSymbol()
{
  //     
  const string Symb = (symbol == "") ? StringSubstr(_Symbol, 0, 6) : symbol;

  if (Sync)
    ThirdPartyTicks.Refresh();                      //       

  ThirdPartyTicks[Symb].Update(false);              //        
  ThirdPartyTicks[Symb].ToCustomSymbol(Sync, true); //       
}

//  
void CreateAllSymbols( const bool ToSymbols = true )
{
  if (Sync)
  {
    ThirdPartyTicks.Refresh();                //       

    Print("OnlineArchive's size is " + (string)(ThirdPartyTicks.GetSize() >> 20) + " Mb.");
  }

  const ulong TotalSize = ThirdPartyTicks.GetSize(Sync);

  const uint Amount = ThirdPartyTicks.GetAmount();
  ulong CalcSize = 0;

  const uint StartTime = GetTickCount();

  for (uint i = 0; _CS(i < Amount); i++)
  {
    Print("Symbol " + ThirdPartyTicks[i].GetName() + " " + (string)(i + 1) + "/" + (string)Amount);

    ThirdPartyTicks[i].Update(false); //        

    if (_CS(ToSymbols))
      ThirdPartyTicks[i].ToCustomSymbol(Sync);      //       

    const uint Interval = (GetTickCount() - StartTime) / 1000;

    CalcSize += ThirdPartyTicks.GetSize(Sync, ThirdPartyTicks[i].GetName());
    const uint EstimatedTime = CalcSize ? (uint)(Interval * TotalSize / CalcSize) : 0;

    if (_CS(true))
    {
      const string Str = "Done " + (string)(i + 1) + "/" + (string)Amount + " symbols, Time = " +
                         TimeToString(Interval, TIME_SECONDS) + " / " + TimeToString(EstimatedTime, TIME_SECONDS) +
                         " (" + (EstimatedTime ? DoubleToString(100.0 * Interval / EstimatedTime, 2) : "0") +
                         "%), Time Left = " + TimeToString(EstimatedTime - Interval, TIME_SECONDS) +
                         " (" + (string)(TimeLocal() + EstimatedTime - Interval) + ")";

      Print(Str);
      Comment(MQLInfoString(MQL_PROGRAM_NAME) + " " + (string)TimeLocal() + "\n" + Str + "\nSee the logs.");
    }
  }

  if (_CS(true) && (ToSymbols || Sync))
    Alert((ToSymbols ? "Created " : "Downloaded ") + (string)Amount + " symbols (See the logs).");

  Comment("");
}

void OnStart()
{
  if (symbol != "AllSymbols")
    CreateSymbol();
  else if (MessageBox("Creating all the symbols can take a long time.\nCurrent size of Offline archive is " +
                      (string)(ThirdPartyTicks.GetSize(false) >> 20) + " Mb.\nDo you agree?", __FILE__, MB_YESNO | MB_ICONQUESTION) == IDYES)
    CreateAllSymbols();
}