//+------------------------------------------------------------------+
//|                                          iTimeSeries_Example.mq5 |
//|                                                      nicholishen |
//|                                   www.reddit.com/u/nicholishenFX |
//+------------------------------------------------------------------+
#property copyright "nicholishen"
#property link      "www.reddit.com/u/nicholishenFX"
#property version   "1.00"

#include <itimeseries_nicholishen_v2.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+

void OnStart()
{
//---
   CiTimeSeries iBar;
   
   datetime          time     = D'2017.04.11 19:56:37';     //testing date
   string            symbol   = Symbol();                   //symbol
   ENUM_TIMEFRAMES   period   = Period();                   //period     
   bool              exact    = false;                      //exact
   bool           autoRefresh = false;                      //auto-refresh flag
   int               calls    = 100000;
   
   ulong             st       = GetMicrosecondCount();      //start timer  
   if(!iBar.Init(symbol,period,autoRefresh))
   {
      Print(__FUNCTION__," Init failed.");
      return;  
   }
   ulong             ed       = GetMicrosecondCount();      //end timer
    
   int cnt = 0;
   int index = 0;
   int p=0; 
   
   Print("iBarShift benchmark based on ",calls," runs.\n=======================================================");
   st = GetMicrosecondCount();  
   for(int i=0;i<calls;i++)
   {
      index = iBarShift2(symbol,period,time,exact);
  
   }
   ed = GetMicrosecondCount();  
   Print("iBarShift(Alain Verleyen) for ",time," is ",index," in ",DoubleToString((double)(ed-st)/1000,3)," milliseconds.\n-------------------------------------------------------------");   
///////////////////////////////   
  
   st = GetMicrosecondCount(); 
   for(int i=0;i<calls;i++)
   {
      index = iBarShift(symbol,period,time,exact);
   
   } 
   ed = GetMicrosecondCount();  
   Print("iBarShift(direct function call) for ",time," is ",index," in ",DoubleToString((double)(ed-st)/1000,3)," milliseconds.\n-------------------------------------------------------------");   
///////////////////////////////   
   
   st = GetMicrosecondCount();
   for(int i=0;i<calls;i++)
   {
      index = iBar.Shift(symbol,period,time,exact);
    
   }
   ed = GetMicrosecondCount();  
   Print("iBar.Shift(performance mode) for ",time," is ",index," in ",DoubleToString((double)(ed-st)/1000,3)," milliseconds.\n-------------------------------------------------------------");   
////////////////////////////// 
   //datetime timeI;
   //st = GetMicrosecondCount(); 
   //for(int i=0;i<calls;i++)
   //{
   //   timeI = iTime(symbol,period,index);
   //   //cnt++;
   //} 
   //ed = GetMicrosecondCount();  
   //Print("iTime(direct function call) for ",timeI," is ",index," in ",DoubleToString((double)(ed-st)/1000,3)," milliseconds.\n-------------------------------------------------------------");   
 
}
//+------------------------------------------------------------------+

int iBarShift2(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
   datetime LastBar;
   if(!SeriesInfoInteger(symbol,timeframe,SERIES_LASTBAR_DATE,LastBar))
     {
      //-- Sometimes SeriesInfoInteger with SERIES_LASTBAR_DATE return an error,
      //-- so we try an other method
      datetime opentimelastbar[1];
      if(CopyTime(symbol,timeframe,0,1,opentimelastbar)==1)
         LastBar=opentimelastbar[0];
      else
         return(-1);
     }
//--- if time > LastBar we always return 0
   if(time>LastBar)
      return(0);
//---
   int shift=Bars(symbol,timeframe,time,LastBar);
   datetime checkcandle[1];

   //-- If time requested doesn't match opening time of a candle, 
   //-- we need a correction of shift value
   if(CopyTime(symbol,timeframe,time,1,checkcandle)==1)
     {
      if(checkcandle[0]==time)
         return(shift-1);
      else if(exact && time>checkcandle[0]+PeriodSeconds(timeframe))
         return(-1);
      else
         return(shift);

      /*
         Can be replaced by the following statement for more concision 
         return(checkcandle[0]==time ? shift-1 : (exact && time>checkcandle[0]+PeriodSeconds(timeframe) ? -1 : shift));
       */
     }
   return(-1);
  }