//+------------------------------------------------------------------+
//|                                                  RSICandleV2.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description "RSICandle Smoothed"
//----   
#property version   "1.00"
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 5
//----     
#property indicator_plots   1
//----      
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1  clrRed,clrViolet,clrDeepSkyBlue,clrBlue
//----   
#property indicator_label1  "RSICandle Open;RSICandle High;RSICandle Low;RSICandle Close"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint RSI_Period=14;
input uint HighLevel=60;                          //  
input uint LowLevel=40;                           //  
//+----------------------------------------------+

//----   ,    
//      
double ExtOpenBuffer[];
double ExtHighBuffer[];
double ExtLowBuffer[];
double ExtCloseBuffer[];
double ExtColorBuffer[];

//----      
int min_rates_total;
//----      
int RSI_Handle[4];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----    
   min_rates_total=int(RSI_Period);

//----    iRSI
   RSI_Handle[0]=iRSI(NULL,0,RSI_Period,PRICE_OPEN);
   if(RSI_Handle[0]==INVALID_HANDLE) Print("      iRSI["+string(0)+"]!");

   RSI_Handle[1]=iRSI(NULL,0,RSI_Period,PRICE_HIGH);
   if(RSI_Handle[1]==INVALID_HANDLE) Print("      iRSI["+string(1)+"]!");

   RSI_Handle[2]=iRSI(NULL,0,RSI_Period,PRICE_LOW);
   if(RSI_Handle[2]==INVALID_HANDLE) Print("      iRSI["+string(2)+"]!");

   RSI_Handle[3]=iRSI(NULL,0,RSI_Period,PRICE_CLOSE);
   if(RSI_Handle[3]==INVALID_HANDLE) Print("      iRSI["+string(3)+"]!");

//----      
   SetIndexBuffer(0,ExtOpenBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtHighBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLowBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtCloseBuffer,INDICATOR_DATA);

//----     ,     
   SetIndexBuffer(4,ExtColorBuffer,INDICATOR_COLOR_INDEX);

//----       
   ArraySetAsSeries(ExtOpenBuffer,true);
   ArraySetAsSeries(ExtHighBuffer,true);
   ArraySetAsSeries(ExtLowBuffer,true);
   ArraySetAsSeries(ExtCloseBuffer,true);
   ArraySetAsSeries(ExtColorBuffer,true);

//----       1
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----         
   string short_name="RSICandleV2";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----    
   IndicatorSetInteger(INDICATOR_LEVELS,2);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,MathMin(100,HighLevel));
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,MathMax(0,LowLevel));
//----        
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(RSI_Handle[0])<rates_total
      || BarsCalculated(RSI_Handle[1])<rates_total
      || BarsCalculated(RSI_Handle[2])<rates_total
      || BarsCalculated(RSI_Handle[3])<rates_total
      || rates_total<min_rates_total)
      return(RESET);

//----    
   int to_copy,limit,bar,clr=0;

//----         limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }

   to_copy=limit+1;

//----      
   if(CopyBuffer(RSI_Handle[0],0,0,to_copy,ExtOpenBuffer)<=0) return(RESET);
   if(CopyBuffer(RSI_Handle[1],0,0,to_copy,ExtHighBuffer)<=0) return(RESET);
   if(CopyBuffer(RSI_Handle[2],0,0,to_copy,ExtLowBuffer)<=0) return(RESET);
   if(CopyBuffer(RSI_Handle[3],0,0,to_copy,ExtCloseBuffer)<=0) return(RESET);


//----      
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double Max=MathMax(ExtOpenBuffer[bar],ExtCloseBuffer[bar]);
      double Min=MathMin(ExtOpenBuffer[bar],ExtCloseBuffer[bar]);

      Max=ExtHighBuffer[bar]=MathMax(Max,ExtHighBuffer[bar]);
      Min=ExtLowBuffer[bar]=MathMin(Min,ExtLowBuffer[bar]);

      if(ExtOpenBuffer[bar]<ExtCloseBuffer[bar])
        {
         if((Max>HighLevel) || (Max>LowLevel && Min<=LowLevel)) clr=3;
         else clr=2;
        }
      else if(ExtOpenBuffer[bar]>ExtCloseBuffer[bar])
        {
         if((Min<LowLevel) || ((Max>HighLevel && Min<=HighLevel))) clr=0;
         else clr=1;
        }
      ExtColorBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
